/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.search.PHPSearchQuery;
import org.eclipse.php.internal.ui.search.decorators.PHPClassConstantDataDecorator;
import org.eclipse.php.internal.ui.search.decorators.PHPClassDataDecorator;
import org.eclipse.php.internal.ui.search.decorators.PHPConstantDataDecorator;
import org.eclipse.php.internal.ui.search.decorators.PHPDataDecorator;
import org.eclipse.php.internal.ui.search.decorators.PHPFunctionDataDecorator;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;

public class PHPSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private PHPSearchQuery fQuery;
    private static final Match[] NO_MATCHES = new Match[0];
    private ISearchResultListener fFilterListener;

    public PHPSearchResult(PHPSearchQuery query) {
        this.fQuery = query;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fQuery.getImageDescriptor();
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public void setFilterListner(ISearchResultListener listener) {
        this.fFilterListener = listener;
    }

    protected void fireChange(SearchResultEvent e) {
        if (this.fFilterListener != null) {
            this.fFilterListener.searchResultChanged(e);
        }
        super.fireChange(e);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput editorInput;
        PHPStructuredEditor structuredEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)editor);
        if (structuredEditor != null) {
            editor = structuredEditor;
        }
        if ((editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return this.computeContainedMatches(result, fileEditorInput.getFile());
        }
        return NO_MATCHES;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        HashSet matches = new HashSet();
        PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(file.getProject());
        if (projectModel != null) {
            this.collectMatches(matches, projectModel.getFileData(file.getFullPath().toString()));
        }
        return matches.toArray(new Match[matches.size()]);
    }

    private void collectMatches(Set matches, PHPFileData fileData) {
        if (fileData == null) {
            return;
        }
        PHPClassData[] classes = fileData.getClasses();
        switch (this.fQuery.getSpecification().getScope().getSearchFor()) {
            case 0: {
                PHPClassData[] classData = fileData.getClasses();
                int i = 0;
                while (i < classData.length) {
                    this.addToMatches(matches, new PHPClassDataDecorator(classData[i], null));
                    ++i;
                }
                break;
            }
            case 1: {
                PHPFunctionData[] functions = fileData.getFunctions();
                int i = 0;
                while (i < functions.length) {
                    this.addToMatches(matches, new PHPFunctionDataDecorator(functions[i], null));
                    ++i;
                }
                i = 0;
                while (i < classes.length) {
                    functions = classes[i].getFunctions();
                    int j = 0;
                    while (j < functions.length) {
                        this.addToMatches(matches, new PHPFunctionDataDecorator(functions[j], null));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                PHPConstantData[] constants = fileData.getConstants();
                int i = 0;
                while (i < constants.length) {
                    this.addToMatches(matches, new PHPConstantDataDecorator(constants[i], null));
                    ++i;
                }
                i = 0;
                while (i < classes.length) {
                    PHPClassConstData[] classConsts = classes[i].getConsts();
                    int j = 0;
                    while (j < classConsts.length) {
                        this.addToMatches(matches, new PHPClassConstantDataDecorator(classConsts[j], null));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private void addToMatches(Set matches, PHPDataDecorator decorator) {
        Match[] hits = this.getMatches(decorator);
        if (hits != null) {
            int i = 0;
            while (i < hits.length) {
                matches.add(hits[i]);
                ++i;
            }
        }
    }

    public IFile getFile(Object element) {
        if (element instanceof CodeData) {
            CodeData cd = (CodeData)element;
            return (IFile)cd.getAdapter(IResource.class);
        }
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        PHPCodeData data;
        IFile file;
        PHPStructuredEditor structuredEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)editor);
        if (structuredEditor != null) {
            editor = structuredEditor;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (match.getElement() instanceof PHPCodeData && (file = (IFile)(data = (PHPCodeData)match.getElement()).getAdapter(IResource.class)) != null && editorInput != null && editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return file.equals((Object)fileEditorInput.getFile());
        }
        return false;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }
}

