/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.search.GroupAction;
import org.eclipse.php.internal.ui.search.PHPSearchContentProvider;
import org.eclipse.php.internal.ui.search.PHPSearchEditorOpener;
import org.eclipse.php.internal.ui.search.PHPSearchTableContentProvider;
import org.eclipse.php.internal.ui.search.PHPSearchTreeContentProvider;
import org.eclipse.php.internal.ui.search.PostfixLabelProvider;
import org.eclipse.php.internal.ui.util.PHPElementSorter;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class PHPSearchResultPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final String KEY_GROUPING = "org.eclipse.php.search.resultpage.grouping";
    private static final String GROUP_GROUPING = "org.eclipse.php.search.resultpage.grouping";
    private GroupAction fGroupTypeAction;
    private GroupAction fGroupFileAction;
    private GroupAction fGroupProjectAction;
    private int fCurrentGrouping;
    private PHPSearchContentProvider fContentProvider;
    private PHPSearchEditorOpener fEditorOpener = new PHPSearchEditorOpener();

    public PHPSearchResultPage() {
        this.initGroupingActions();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IEditorPart editor;
        try {
            editor = this.fEditorOpener.openMatch(match);
        }
        catch (Exception e) {
            throw new PartInitException(e.getMessage());
        }
        if (editor != null && activate) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        Object element = match.getElement();
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(offset, length);
        } else if (editor != null && element instanceof IFile) {
            IFile file = (IFile)element;
            this.showWithMarker(editor, file, offset, length);
        }
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        if (this.getLayout() != 1) {
            this.addGroupActions(tbm);
        }
    }

    void setGrouping(int grouping) {
        this.fCurrentGrouping = grouping;
        StructuredViewer viewer = this.getViewer();
        PHPSearchTreeContentProvider cp = (PHPSearchTreeContentProvider)viewer.getContentProvider();
        cp.setLevel(grouping);
        this.updateGroupingActions();
        this.getSettings().put("org.eclipse.php.search.resultpage.grouping", this.fCurrentGrouping);
        this.getViewPart().updateLabel();
    }

    private void addGroupActions(IToolBarManager mgr) {
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)new Separator("org.eclipse.php.search.resultpage.grouping"));
        mgr.appendToGroup("org.eclipse.php.search.resultpage.grouping", (IAction)this.fGroupProjectAction);
        mgr.appendToGroup("org.eclipse.php.search.resultpage.grouping", (IAction)this.fGroupFileAction);
        mgr.appendToGroup("org.eclipse.php.search.resultpage.grouping", (IAction)this.fGroupTypeAction);
        this.updateGroupingActions();
    }

    private void updateGroupingActions() {
        this.fGroupProjectAction.setChecked(this.fCurrentGrouping == 0);
        this.fGroupFileAction.setChecked(this.fCurrentGrouping == 1);
        this.fGroupTypeAction.setChecked(this.fCurrentGrouping == 2);
    }

    private void showWithMarker(IEditorPart editor, IFile file, int offset, int length) throws PartInitException {
        try {
            IMarker marker = file.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
            attributes.put("charStart", new Integer(offset));
            attributes.put("charEnd", new Integer(offset + length));
            marker.setAttributes(attributes);
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            marker.delete();
        }
        catch (CoreException e) {
            throw new PartInitException(PHPUIMessages.getString("PHPSearchResultPage_error_marker"), (Throwable)e);
        }
    }

    private void initGroupingActions() {
        this.fGroupProjectAction = new GroupAction(PHPUIMessages.getString("PHPSearchResultPage_groupby_project"), PHPUIMessages.getString("PHPSearchResultPage_groupby_project_tooltip"), this, 0);
        PHPPluginImages.setLocalImageDescriptors((IAction)this.fGroupProjectAction, "group_by_project.gif");
        this.fGroupFileAction = new GroupAction(PHPUIMessages.getString("PHPSearchResultPage_groupby_file"), PHPUIMessages.getString("PHPSearchResultPage_groupby_file_tooltip"), this, 1);
        PHPPluginImages.setLocalImageDescriptors((IAction)this.fGroupFileAction, "group_by_file.gif");
        this.fGroupTypeAction = new GroupAction(PHPUIMessages.getString("PHPSearchResultPage_groupby_type"), PHPUIMessages.getString("PHPSearchResultPage_groupby_type_tooltip"), this, 2);
        PHPPluginImages.setLocalImageDescriptors((IAction)this.fGroupTypeAction, "group_by_type.gif");
    }

    protected StructuredViewer getViewer() {
        return super.getViewer();
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        this.fContentProvider = new PHPSearchTreeContentProvider(this, this.fCurrentGrouping);
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new PostfixLabelProvider(this, 18));
        viewer.setSorter((ViewerSorter)new PHPElementSorter());
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        this.fContentProvider = new PHPSearchTableContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new PostfixLabelProvider(this, 18));
        viewer.setSorter((ViewerSorter)new PHPElementSorter());
    }
}

