/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.outline.PHPOutlineContentProvider;
import org.eclipse.php.internal.ui.outline.PHPOutlineLabelProvider;
import org.eclipse.php.internal.ui.text.AbstractInformationControl;
import org.eclipse.php.internal.ui.util.StringMatcher;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.SWTKeySupport;

public class PHPOutlineInformationControl
extends AbstractInformationControl {
    private KeyAdapter fKeyAdapter;
    private OutlineContentProvider fOutlineContentProvider;
    private PHPCodeData fInput = null;
    private OutlineLabelProvider fInnerLabelProvider;
    private String fPattern;

    public PHPOutlineInformationControl(Shell parent, int shellStyle, int treeStyle, String commandId) {
        super(parent, shellStyle, treeStyle, commandId, true);
    }

    protected Text createFilterText(Composite parent) {
        Text text = super.createFilterText(parent);
        text.addKeyListener((KeyListener)this.getKeyAdapter());
        return text;
    }

    protected TreeViewer createTreeViewer(Composite parent, int style) {
        Tree tree = new Tree(parent, 4 | style & 0xFFFFFFFD);
        GridData gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gd);
        OutlineTreeViewer treeViewer = new OutlineTreeViewer(tree);
        treeViewer.addFilter(new AbstractInformationControl.NamePatternFilter());
        this.fInnerLabelProvider = new OutlineLabelProvider();
        PlatformUI.getWorkbench().getDecoratorManager();
        treeViewer.setLabelProvider((IBaseLabelProvider)this.fInnerLabelProvider);
        this.fOutlineContentProvider = new OutlineContentProvider(treeViewer, this.fInnerLabelProvider);
        treeViewer.setContentProvider((IContentProvider)this.fOutlineContentProvider);
        treeViewer.setAutoExpandLevel(-1);
        treeViewer.getTree().addKeyListener((KeyListener)this.getKeyAdapter());
        return treeViewer;
    }

    protected String getStatusFieldText() {
        KeySequence[] sequences = this.getInvokingCommandKeySequences();
        if (sequences == null || sequences.length == 0) {
            return "";
        }
        sequences[0].format();
        return "";
    }

    protected String getId() {
        return "org.eclipse.php.internal.ui.text.QuickOutline";
    }

    public void setInput(Object information) {
        if (information == null || information instanceof String) {
            this.inputChanged(null, null);
            return;
        }
        this.fInput = (PHPCodeData)information;
        this.inputChanged(this.fInput, information);
    }

    private KeyAdapter getKeyAdapter() {
        if (this.fKeyAdapter == null) {
            this.fKeyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                    KeySequence[] sequences = PHPOutlineInformationControl.this.getInvokingCommandKeySequences();
                    if (sequences == null) {
                        return;
                    }
                    int i = 0;
                    while (i < sequences.length) {
                        if (sequences[i].equals((Object)keySequence)) {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            };
        }
        return this.fKeyAdapter;
    }

    protected void fillViewMenu(IMenuManager viewMenu) {
        super.fillViewMenu(viewMenu);
    }

    protected void setMatcherString(String pattern, boolean update) {
        this.fPattern = pattern;
        if (pattern.length() == 0) {
            super.setMatcherString(pattern, update);
            return;
        }
        boolean ignoreCase = pattern.toLowerCase().equals(pattern);
        String pattern2 = "*" + pattern;
        this.fStringMatcher = new OrStringMatcher(pattern, pattern2, ignoreCase, false);
        if (update) {
            this.stringMatcherUpdated();
        }
    }

    private IProgressMonitor getProgressMonitor() {
        IWorkbenchPage wbPage = PHPUiPlugin.getActivePage();
        if (wbPage == null) {
            return null;
        }
        IEditorPart editor = wbPage.getActiveEditor();
        if (editor == null) {
            return null;
        }
        return editor.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
    }

    private static class OrStringMatcher
    extends StringMatcher {
        private StringMatcher fMatcher1;
        private StringMatcher fMatcher2;

        private OrStringMatcher(String pattern1, String pattern2, boolean ignoreCase, boolean foo) {
            super("", false, false);
            this.fMatcher1 = new StringMatcher(pattern1, ignoreCase, false);
            this.fMatcher2 = new StringMatcher(pattern2, ignoreCase, false);
        }

        public boolean match(String text) {
            return this.fMatcher2.match(text) || this.fMatcher1.match(text);
        }
    }

    private class OutlineContentProvider
    extends PHPOutlineContentProvider {
        public OutlineContentProvider(TreeViewer viewer, PHPOutlineLabelProvider labelProvider) {
            super(viewer, labelProvider);
        }
    }

    private class OutlineLabelProvider
    extends PHPOutlineLabelProvider {
        private OutlineLabelProvider() {
        }
    }

    private class OutlineTreeViewer
    extends TreeViewer {
        public OutlineTreeViewer(Tree tree) {
            super(tree);
        }
    }
}

