/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.treecontent;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.IncludePathModelListener;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.IPhpProjectOptionChangeListener;
import org.eclipse.php.internal.ui.treecontent.IncludeModelPathRootConverter;
import org.eclipse.php.internal.ui.treecontent.IncludePathTreeContent;
import org.eclipse.php.internal.ui.treecontent.PHPTreeNode;
import org.eclipse.swt.graphics.Image;

public class IncludesNode
extends PHPTreeNode
implements IPhpProjectOptionChangeListener,
ModelListener,
IncludePathModelListener {
    private IncludePathTreeContent provider;

    IncludesNode(String text, Image image, String id, IProject project, IncludePathTreeContent provider) {
        super(text, image, id, project, null);
        this.provider = provider;
    }

    public void notifyOptionChanged(Object oldOption, Object newOption) {
        List<IIncludePathEntry> oldEntriesList = Arrays.asList((IIncludePathEntry[])oldOption);
        List<IIncludePathEntry> newEntriesList = Arrays.asList((IIncludePathEntry[])newOption);
        boolean hasChanges = false;
        for (IIncludePathEntry newEntry : newEntriesList) {
            if (oldEntriesList.contains(newEntry)) continue;
            hasChanges = true;
        }
        for (IIncludePathEntry oldEntry : oldEntriesList) {
            if (newEntriesList.contains(oldEntry)) continue;
            hasChanges = true;
        }
        if (hasChanges) {
            IncludePathTreeContent.includePathTree.getDataTree().empty();
            this.refresh();
        }
    }

    public void fileDataChanged(PHPFileData fileData) {
        this.refreshFile(fileData, false);
    }

    public void fileDataAdded(PHPFileData fileData) {
        this.refreshFile(fileData, false);
    }

    public void fileDataRemoved(PHPFileData fileData) {
        this.refreshFile(fileData, true);
    }

    public void dataCleared() {
        this.refresh();
    }

    public void refresh() {
        this.refresh(this);
    }

    private void refresh(final Object obj) {
        if (this.provider.getTreeViewer() != null && !this.provider.getTreeViewer().getControl().isDisposed()) {
            this.provider.getTreeViewer().getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (IncludesNode.this.provider.getTreeViewer() != null && !IncludesNode.this.provider.getTreeViewer().getControl().isDisposed()) {
                        IncludesNode.this.provider.getTreeViewer().refresh(obj);
                    }
                }
            });
        }
    }

    private void refreshFile(PHPFileData fileData, boolean deleted) {
        IPhpModel model = IncludePathTreeContent.findModel(fileData);
        if (model == null) {
            return;
        }
        Path fileLocation = new Path(fileData.getName());
        IPath includeModelLocation = PHPModelUtil.getIncludeModelLocation((IPhpModel)model);
        IPath modelPath = IncludePathTreeContent.INCLUDE_PATHS_ROOT_PATH.append(IncludeModelPathRootConverter.toString(model));
        IPath fileTreeLocation = modelPath.append(fileLocation.removeFirstSegments(includeModelLocation.segmentCount()));
        if (IncludePathTreeContent.includePathTree.includes(fileTreeLocation)) {
            this.refreshExistingFileNode(fileTreeLocation, deleted);
            if (!deleted) {
                IncludePathTreeContent.includePathTree.createElement(fileTreeLocation, (Object)fileData);
            }
        } else {
            this.refreshMissingFileNode(fileTreeLocation, deleted);
        }
    }

    private void refreshExistingFileNode(IPath fileTreeLocation, boolean deleted) {
        if (deleted) {
            IPath elementToRefresh = fileTreeLocation;
            while (IncludePathTreeContent.includePathTree.getChildCount(elementToRefresh) < 1 && elementToRefresh.segmentCount() > 1) {
                if (IncludePathTreeContent.includePathTree.includes(elementToRefresh)) {
                    IncludePathTreeContent.includePathTree.deleteElement(elementToRefresh);
                }
                elementToRefresh = elementToRefresh.removeLastSegments(1);
            }
            this.refresh(IncludePathTreeContent.includePathTree.getElementData(elementToRefresh));
        } else {
            this.refresh(IncludePathTreeContent.includePathTree.getElementData(fileTreeLocation));
        }
    }

    private void refreshMissingFileNode(IPath fileTreeLocation, boolean deleted) {
        IPath elementToRefresh = fileTreeLocation;
        while (!IncludePathTreeContent.includePathTree.includes(elementToRefresh) && elementToRefresh.segmentCount() > 1) {
            if (deleted && IncludePathTreeContent.includePathTree.includes(elementToRefresh) && IncludePathTreeContent.includePathTree.getChildCount(elementToRefresh) < 1) {
                IncludePathTreeContent.includePathTree.deleteElement(elementToRefresh);
            }
            elementToRefresh = elementToRefresh.removeLastSegments(1);
        }
        this.refresh(IncludePathTreeContent.includePathTree.getElementData(elementToRefresh));
    }

    public void includeModelAdded(IPhpModel model) {
        IncludePathTreeContent.getIncludeModelChildren(model);
        this.refresh();
    }

    public void includeModelRemoved(IPhpModel model) {
        this.refresh();
    }
}

