/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.internal.core.containers.LocalFileStorage;
import org.eclipse.php.internal.core.containers.ZipEntryStorage;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.containers.LocalFileStorageEditorInput;
import org.eclipse.php.internal.ui.containers.ZipEntryStorageEditorInput;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.php.internal.ui.util.PHPOpenExternalFileAction;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class EditorUtility {
    private static String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return MessageFormat.format(PHPUIMessages.getString("EditorUtility_concatModifierStrings"), modifierString, newModifierString);
    }

    private static ZipEntryStorageEditorInput createZipEntryStorageEditorInput(ZipFile zipFile, PHPCodeData element, IProject project) {
        ZipEntry ze;
        block5: {
            ZipInputStream is = null;
            ze = null;
            File f = new File(zipFile.getName());
            is = new ZipInputStream(new FileInputStream(f));
            ze = is.getNextEntry();
            PHPFileData fileData = null;
            fileData = element instanceof PHPFileData ? (PHPFileData)element : PHPModelUtil.getPHPFileContainer((PHPCodeData)element);
            String phpFileName = fileData.getName();
            phpFileName = phpFileName.substring(phpFileName.indexOf(File.separatorChar) + 1);
            while (ze != null && !ze.getName().equals(phpFileName)) {
                ze = is.getNextEntry();
            }
            if (ze != null) break block5;
            return null;
        }
        try {
            ZipEntryStorage zipEntryStorage = new ZipEntryStorage(zipFile, ze);
            zipEntryStorage.setProject(project);
            return new ZipEntryStorageEditorInput(zipEntryStorage);
        }
        catch (FileNotFoundException e) {
            Logger.logException(e);
            return null;
        }
        catch (IOException io) {
            Logger.logException(io);
            return null;
        }
    }

    public static int findLocalizedModifier(String modifierName) {
        if (modifierName == null) {
            return 0;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static PHPCodeData getActiveEditorPHPInput() {
        IEditorInput editorInput;
        IEditorPart part;
        IWorkbenchPage page = PHPUiPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null && (editorInput = part.getEditorInput()) != null) {
            return (PHPCodeData)editorInput.getAdapter(PHPCodeData.class);
        }
        return null;
    }

    private static IContentType getContentType(File file) {
        if (file == null) {
            return null;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor((InputStream)stream, file.getName());
            return iContentType;
        }
        catch (IOException x) {
            Logger.logException(x);
            return null;
        }
        finally {
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException x) {
                Logger.logException(x);
            }
        }
    }

    private static String getEditorId(File file) {
        IWorkbench workbench = PHPUiPlugin.getDefault().getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName(), EditorUtility.getContentType(file));
        if (descriptor != null) {
            return descriptor.getId();
        }
        return null;
    }

    public static String getEditorID(IEditorInput input) {
        IEditorDescriptor editorDescriptor;
        try {
            String id;
            File file;
            LocalFileStorageEditorInput localFileInput;
            LocalFileStorage fileStorage;
            if (input instanceof LocalFileStorageEditorInput && (fileStorage = (LocalFileStorage)(localFileInput = (LocalFileStorageEditorInput)input).getStorage()) != null && (file = fileStorage.getFile()) != null && (id = EditorUtility.getEditorId(file)) != null) {
                return id;
            }
            editorDescriptor = IDE.getEditorDescriptor((String)input.getName());
        }
        catch (PartInitException partInitException) {
            return null;
        }
        if (editorDescriptor != null) {
            return editorDescriptor.getId();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) {
        if (input instanceof TreeItem) {
            IProject project = EditorUtility.getProject((TreeItem)input);
            String incDir = EditorUtility.getIncludeDirectory((TreeItem)input);
            return EditorUtility.getEditorInput((PHPCodeData)((TreeItem)input).getData(), project, incDir);
        }
        if (input instanceof PHPCodeData) {
            return EditorUtility.getEditorInput((PHPCodeData)input, null, null);
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        if (input instanceof IEditorInput) {
            return (IEditorInput)input;
        }
        return null;
    }

    private static IEditorInput getEditorInput(PHPCodeData element, IProject project, String incDir) {
        IResource resource = PHPModelUtil.getResource((Object)element);
        if (resource == null || !resource.exists()) {
            Object source = PHPModelUtil.getExternalResource((Object)element, (IProject)project);
            if (source instanceof File) {
                File externalSource = (File)source;
                Path path = new Path(externalSource.getPath());
                if (ExternalFilesRegistry.getInstance().isEntryExist(path.toOSString())) {
                    if (path.segmentCount() > 1 && path.segment(path.segmentCount() - 2).equals("Untitled_Documents")) {
                        return new NonExistingPHPFileEditorInput((IPath)path);
                    }
                    return new FileStoreEditorInput((IFileStore)new LocalFile(externalSource));
                }
                LocalFileStorage fileStorage = new LocalFileStorage((File)source);
                fileStorage.setProject(project);
                fileStorage.setIncBaseDirName(incDir);
                return new LocalFileStorageEditorInput(fileStorage);
            }
            if (source instanceof ZipFile) {
                return EditorUtility.createZipEntryStorageEditorInput((ZipFile)source, element, project);
            }
        }
        if (resource instanceof ExternalFileWrapper) {
            File untitledDocumentDummyFile = resource.getFullPath().toFile();
            if (untitledDocumentDummyFile.exists()) {
                return null;
            }
            return new NonExistingPHPFileEditorInput(resource.getFullPath());
        }
        if (resource instanceof IFile) {
            return new FileEditorInput((IFile)resource);
        }
        return null;
    }

    private static String getIncludeDirectory(TreeItem input) {
        if (!(input.getData() instanceof PHPCodeData)) {
            return null;
        }
        PHPCodeData codeData = (PHPCodeData)input.getData();
        while (codeData != null && !(codeData instanceof PHPFileData)) {
            codeData = codeData.getContainer();
            input = input.getParentItem();
        }
        while (input != null && !(input.getData() instanceof PHPIncludePathModel)) {
            input = input.getParentItem();
        }
        if (input == null) {
            return null;
        }
        PHPIncludePathModel includePathModel = (PHPIncludePathModel)input.getData();
        if (includePathModel.getType() == PHPIncludePathModel.IncludePathModelType.VARIABLE) {
            IPath includePath = IncludePathVariableManager.instance().getIncludePathVariable(includePathModel.getID());
            return includePath.toOSString();
        }
        return new Path(includePathModel.getID()).toOSString();
    }

    public static String getModifierString(int stateMask) {
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = EditorUtility.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = EditorUtility.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = EditorUtility.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = EditorUtility.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }

    public static PHPProjectModel getPHPProject(IEditorInput input) {
        IProject project;
        if (input instanceof IFileEditorInput && (project = ((IFileEditorInput)input).getFile().getProject()) != null) {
            return PHPWorkspaceModelManager.getInstance().getModelForProject(project);
        }
        return null;
    }

    private static IProject getProject(TreeItem input) {
        if (!(input.getData() instanceof PHPCodeData)) {
            return null;
        }
        PHPCodeData codeData = (PHPCodeData)input.getData();
        while (codeData != null && !(codeData instanceof PHPFileData)) {
            codeData = codeData.getContainer();
            input = input.getParentItem();
        }
        while (input != null && !(input.getData() instanceof IProject)) {
            input = input.getParentItem();
        }
        if (input == null) {
            return null;
        }
        return (IProject)input.getData();
    }

    private static void initializeHighlightRange(IEditorPart editorPart) {
        if (editorPart instanceof ITextEditor) {
            IAction toggleAction = editorPart.getEditorSite().getActionBars().getGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly");
            boolean enable = toggleAction != null;
            boolean bl = enable = enable && toggleAction.isEnabled() && toggleAction.isChecked();
            if (enable) {
                if (toggleAction instanceof TextEditorAction) {
                    ((TextEditorAction)toggleAction).setEditor(null);
                    ((TextEditorAction)toggleAction).setEditor((ITextEditor)editorPart);
                } else {
                    toggleAction.run();
                    toggleAction.run();
                }
            }
        }
    }

    public static boolean isEditorInput(Object element, IEditorPart editor) {
        if (editor != null) {
            return editor.getEditorInput().equals(EditorUtility.getEditorInput(element));
        }
        return false;
    }

    public static IEditorPart isOpenInEditor(Object inputElement) {
        IEditorInput input = null;
        input = EditorUtility.getEditorInput(inputElement);
        return EditorUtility.getEditor(input);
    }

    public static IEditorPart getEditor(IEditorInput input) {
        IWorkbenchPage p;
        if (input != null && (p = PHPUiPlugin.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    public static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (input != null && (p = PHPUiPlugin.getActivePage()) != null) {
            IEditorPart editorPart = p.openEditor(input, editorID, activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    public static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file != null && (p = PHPUiPlugin.getActivePage()) != null) {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    public static IEditorPart openInEditor(Object inputElement) throws PartInitException {
        return EditorUtility.openInEditor(inputElement, true);
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws PartInitException {
        if (inputElement instanceof IFile) {
            return EditorUtility.openInEditor((IFile)inputElement, activate);
        }
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            return EditorUtility.openInEditor(fileInput.getFile(), activate);
        }
        if (input != null) {
            if (input instanceof NonExistingPHPFileEditorInput) {
                return EditorUtility.openInEditor(input, "org.eclipse.php.untitledPhpEditor", activate);
            }
            return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input), activate);
        }
        return null;
    }

    public static IEditorPart revealInEditor(IEditorPart part, int lineNumber) {
        if (lineNumber > 0 && part instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)part;
            try {
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                textEditor.selectAndReveal(document.getLineOffset(--lineNumber), document.getLineLength(lineNumber));
            }
            catch (BadLocationException badLocationException) {}
        }
        return part;
    }

    public static IEditorPart openInEditor(String fileName, int lineNumber) throws CoreException {
        File localFile;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        try {
            Path errorFilePath = new Path(fileName);
            if (errorFilePath.segmentCount() > 1 && errorFilePath.segment(errorFilePath.segmentCount() - 2).equalsIgnoreCase("Untitled_Documents")) {
                IEditorPart editor = EditorUtility.openInEditor(new NonExistingPHPFileEditorInput((IPath)errorFilePath), "org.eclipse.php.untitledPhpEditor", true);
                return EditorUtility.revealInEditor(editor, lineNumber);
            }
        }
        catch (RuntimeException runtimeException) {}
        Path path = new Path(fileName);
        IFile file = root.getFileForLocation((IPath)path);
        if (file == null) {
            if (path.segmentCount() < 2) {
                return null;
            }
            file = root.getFile((IPath)path);
            if (file == null) {
                IProject[] projects = root.getProjects();
                int i = 0;
                while (i < projects.length) {
                    if (projects[i].isOpen() && (file = projects[i].getFile((IPath)path)) != null) break;
                    ++i;
                }
            }
        }
        if (file == null) {
            return null;
        }
        if (!file.exists() && (localFile = new File(fileName)).exists()) {
            IFile localIFile;
            Object editorInput = null;
            if (!ExternalFilesRegistry.getInstance().isEntryExist(path.toOSString()) && !(localIFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path)).exists()) {
                IFile externalFile = ExternalFileWrapper.createFile((String)fileName);
                ExternalFilesRegistry.getInstance().addFileEntry(fileName, externalFile);
            }
            if (ExternalFilesRegistry.getInstance().isEntryExist(path.toOSString())) {
                editorInput = new FileStoreEditorInput((IFileStore)new LocalFile(localFile));
            } else {
                LocalFileStorage fileStorage = new LocalFileStorage(localFile);
                fileStorage.setProject(file.getProject());
                editorInput = new LocalFileStorageEditorInput(fileStorage);
            }
            if (editorInput != null) {
                IWorkbenchPage p = PHPUiPlugin.getActivePage();
                if (p != null) {
                    IEditorPart part = EditorUtility.openInEditor((IEditorInput)editorInput, EditorUtility.getEditorID((IEditorInput)editorInput), true);
                    return EditorUtility.revealInEditor(part, lineNumber);
                }
                return null;
            }
        }
        if (!file.exists()) {
            return null;
        }
        IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
        marker.setAttribute("lineNumber", lineNumber);
        IWorkbenchPage p = PHPUiPlugin.getActivePage();
        IEditorPart editor = null;
        if (p != null) {
            editor = IDE.openEditor((IWorkbenchPage)p, (IMarker)marker);
        }
        marker.delete();
        return editor;
    }

    public static void revealInEditor(IEditorPart editor, final int offset, final int length) {
        if (editor instanceof ITextEditor) {
            ((ITextEditor)editor).selectAndReveal(offset, length);
            return;
        }
        if (editor instanceof IGotoMarker) {
            final IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                final IGotoMarker gotoMarkerTarget = (IGotoMarker)editor;
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        IMarker marker = null;
                        try {
                            marker = ((IFileEditorInput)input).getFile().createMarker("org.eclipse.core.resources.textmarker");
                            marker.setAttribute("charStart", offset);
                            marker.setAttribute("charEnd", offset + length);
                            gotoMarkerTarget.gotoMarker(marker);
                        }
                        finally {
                            if (marker != null) {
                                marker.delete();
                            }
                        }
                    }
                };
                try {
                    op.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    Assert.isTrue((boolean)false, (String)"this operation can not be canceled");
                }
            }
            return;
        }
        if (editor != null && editor.getEditorSite().getSelectionProvider() != null) {
            IEditorSite site = editor.getEditorSite();
            if (site == null) {
                return;
            }
            ISelectionProvider provider = editor.getEditorSite().getSelectionProvider();
            if (provider == null) {
                return;
            }
            provider.setSelection((ISelection)new TextSelection(offset, length));
        }
    }

    public static void revealInEditor(IEditorPart part, IRegion region) {
        if (part != null && region != null) {
            EditorUtility.revealInEditor(part, region.getOffset(), region.getLength());
        }
    }

    public static void revealInEditor(IEditorPart part, PHPCodeData element) {
        if (element == null) {
            return;
        }
        PHPStructuredEditor phpEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)part);
        if (phpEditor != null) {
            phpEditor.setSelection(element, true);
            return;
        }
        int offset = -1;
        int length = 0;
        UserData userData = element.getUserData();
        if (userData != null) {
            offset = userData.getStartPosition();
            length = userData.getEndPosition() - userData.getStartPosition() + 1;
        }
        if (offset >= 0) {
            EditorUtility.revealInEditor(part, offset, length);
        }
    }

    public static final PHPStructuredEditor getPHPStructuredEditor(IWorkbenchPart editor) {
        return editor != null ? (PHPStructuredEditor)((Object)editor.getAdapter(PHPStructuredEditor.class)) : null;
    }

    public static final PHPStructuredEditor getPHPStructuredEditor(ITextViewer textViewer) {
        PHPStructuredEditor phpStructuredEditor;
        IWorkbenchPage workbenchpage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart activeEditorPart = workbenchpage.getActiveEditor();
        if (activeEditorPart instanceof PHPStructuredEditor && (phpStructuredEditor = (PHPStructuredEditor)activeEditorPart).getTextViewer().getDocument() == textViewer.getDocument()) {
            return phpStructuredEditor;
        }
        IEditorReference[] editorReferences = workbenchpage.getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            PHPStructuredEditor phpStructuredEditor2;
            IEditorReference editorReference = editorReferences[i];
            IEditorPart editorpart = editorReference.getEditor(false);
            if (editorpart instanceof PHPStructuredEditor && (phpStructuredEditor2 = (PHPStructuredEditor)editorpart).getTextViewer().getDocument() == textViewer.getDocument()) {
                return phpStructuredEditor2;
            }
            ++i;
        }
        return null;
    }

    public static void openFilesInEditor(List filesToOpen, IWorkbenchWindow window) {
        PHPOpenExternalFileAction action = new PHPOpenExternalFileAction();
        action.init(window);
        action.run(filesToOpen);
    }

    public static void openFilesInEditor(List filesToOpen) {
        EditorUtility.openFilesInEditor(filesToOpen, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public static void openFileInEditor(String filePath, int lineNumber, IWorkbenchWindow window) {
        PHPOpenExternalFileAction action = new PHPOpenExternalFileAction();
        action.init(window);
        action.run(filePath, lineNumber);
    }

    public static void openFileInEditor(String filePath, int lineNumber) {
        EditorUtility.openFileInEditor(filePath, lineNumber, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public static IResource getResourceFromEditorInput(IEditorInput input) {
        IFile resource = null;
        IPath externalPath = null;
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            resource = fileInput.getFile();
        } else if (input instanceof IStorageEditorInput) {
            IStorageEditorInput editorInput = (IStorageEditorInput)input;
            IStorage storage = null;
            try {
                storage = editorInput.getStorage();
            }
            catch (CoreException e) {
                Logger.logException(e);
                return null;
            }
            if (storage instanceof ZipEntryStorage) {
                resource = ((ZipEntryStorage)storage).getProject();
            } else if (!(storage instanceof LocalFileStorage)) {
                externalPath = storage.getFullPath();
                resource = ExternalFileWrapper.createFile((String)externalPath.toOSString());
            }
        } else if (input instanceof IURIEditorInput || input instanceof NonExistingPHPFileEditorInput) {
            externalPath = input instanceof NonExistingPHPFileEditorInput ? ((NonExistingPHPFileEditorInput)input).getPath() : URIUtil.toPath((URI)((IURIEditorInput)input).getURI());
            resource = ExternalFileWrapper.createFile((String)externalPath.toOSString());
        }
        return resource;
    }
}

