/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.io.File;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;

public class PHPCodeDataHTMLDescriptionUtilities {
    private static Pattern dolar_pattern = Pattern.compile("\\$");
    private static Pattern unknown_type_pattern = Pattern.compile("unknown_type\\ ");
    private static StringBuffer descriptionText = new StringBuffer();
    private static StringBuffer helpBuffer = new StringBuffer();

    public static final String createFunctionDescriptionText(PHPCodeData phpCodeData, PHPProjectModel projectModel) {
        boolean isClassFunction;
        descriptionText.delete(0, descriptionText.length());
        String desc = phpCodeData.getDescription();
        PHPCodeData container = phpCodeData.getContainer();
        String fileName = phpCodeData.isUserCode() ? phpCodeData.getUserData().getFileName() : null;
        boolean bl = isClassFunction = container != null && container instanceof PHPClassData;
        if (fileName != null) {
            File file = new File(fileName);
            Path path = new Path(fileName);
            if (path.getDevice() != null && !file.exists()) {
                fileName = new Path(fileName).lastSegment();
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(fileName));
            } else {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(fileName));
            }
        }
        if (isClassFunction) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getClassNameTableRow(container.getName(), projectModel));
        }
        if (desc.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(desc));
        }
        if (phpCodeData.getDocBlock() != null) {
            Iterator it = phpCodeData.getDocBlock().getTags(7);
            if (it.hasNext()) {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getParamTagTableRows(it));
            }
            if ((it = phpCodeData.getDocBlock().getTags(6)).hasNext()) {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getReturnTagTableRows(it));
            }
            if ((it = phpCodeData.getDocBlock().getTags(29)).hasNext()) {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getThrowTagTableRows(it));
            }
            if ((it = phpCodeData.getDocBlock().getTags(8)).hasNext()) {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getSeeAlsoTagTableRows(it, projectModel, phpCodeData));
            }
            if ((it = phpCodeData.getDocBlock().getTags(2)).hasNext()) {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDeprecatedTagTableRow(it));
            }
        }
        return descriptionText.toString();
    }

    public static String createClassDescriptionText(PHPClassData classData, PHPProjectModel projectModel) {
        descriptionText.delete(0, descriptionText.length());
        PHPFileData cfr_ignored_0 = (PHPFileData)classData.getContainer();
        PHPClassData.PHPSuperClassNameData superClass = classData.getSuperClassData();
        PHPClassData.PHPInterfaceNameData[] implementData = classData.getInterfacesNamesData();
        String fileName = null;
        String superClassName = null;
        String[] implement = null;
        String desc = classData.getDescription();
        String string = fileName = classData.isUserCode() ? classData.getUserData().getFileName() : null;
        if (fileName != null) {
            File file = new File(fileName);
            Path path = new Path(fileName);
            if (path.getDevice() != null && !file.exists()) {
                fileName = new Path(fileName).lastSegment();
            }
        }
        if (superClass != null) {
            superClassName = superClass.getName();
        }
        if (implementData != null && implementData.length > 0) {
            implement = new String[implementData.length];
            int i = 0;
            while (i < implementData.length) {
                PHPClassData.PHPInterfaceNameData phpInterfaceNameData = implementData[i];
                implement[i] = phpInterfaceNameData.getName();
                ++i;
            }
        }
        if (fileName != null) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(fileName));
        }
        if (superClassName != null) {
            descriptionText.append("<br><dt>Extends</dt>");
            descriptionText.append("<dd>");
            descriptionText.append(superClassName);
            descriptionText.append("</dd>");
        }
        if (implement != null) {
            descriptionText.append("<br><dt>Implements</dt>");
            String[] stringArray = implement;
            int n = implement.length;
            int n2 = 0;
            while (n2 < n) {
                String interfaceName = stringArray[n2];
                descriptionText.append("<dd>");
                descriptionText.append(interfaceName);
                descriptionText.append("</dd>");
                ++n2;
            }
        }
        if (desc.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(desc));
        }
        return descriptionText.toString();
    }

    public static String createVariableDescriptionText(PHPVariableData variableData) {
        descriptionText.delete(0, descriptionText.length());
        String desc = variableData.getDescription();
        if (desc.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(desc));
        }
        return descriptionText.toString();
    }

    public static String createClassVariableDescriptionText(PHPClassVarData variableData, PHPProjectModel projectModel) {
        String fileName;
        descriptionText.delete(0, descriptionText.length());
        String desc = variableData.getDescription();
        PHPCodeData containerClass = variableData.getContainer();
        String className = containerClass != null ? containerClass.getName() : null;
        String string = fileName = containerClass != null ? variableData.getUserData().getFileName() : null;
        if (fileName != null) {
            File file = new File(fileName);
            Path path = new Path(fileName);
            if (path.getDevice() != null && !file.exists()) {
                fileName = new Path(fileName).lastSegment();
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(fileName));
            } else {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(fileName));
            }
        }
        if (className != null) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getClassNameTableRow(className, projectModel));
        }
        if (desc.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(desc));
        }
        return descriptionText.toString();
    }

    public static String createPHPConstantDescriptionText(PHPConstantData codeData) {
        descriptionText.delete(0, descriptionText.length());
        String desc = codeData.getDescription();
        String fileName = codeData.getUserData() != null ? codeData.getUserData().getFileName() : null;
        String value = codeData.getValue();
        if (fileName != null) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(fileName));
        }
        if (value != null && value.length() > 0) {
            descriptionText.append("<br><dt>Value</dt>");
            descriptionText.append("<dd>");
            descriptionText.append(value);
            descriptionText.append("</dd>");
        }
        if (desc.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(desc));
        }
        return descriptionText.toString();
    }

    public static String createPHPClassConstDescriptionText(PHPClassConstData codeData, PHPProjectModel projectModel) {
        descriptionText.delete(0, descriptionText.length());
        String desc = codeData.getDescription();
        String className = codeData.getContainer().getName();
        String fileName = codeData.getUserData() != null ? codeData.getUserData().getFileName() : null;
        String value = codeData.getValue();
        if (fileName != null) {
            File file = new File(fileName);
            Path path = new Path(fileName);
            if (path.getDevice() != null && !file.exists()) {
                fileName = new Path(fileName).lastSegment();
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(fileName));
            } else {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(fileName));
            }
        }
        if (className != null) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getClassNameTableRow(className, projectModel));
        }
        if (value != null && value.length() > 0) {
            descriptionText.append("<br><dt>Value</dt>");
            descriptionText.append("<dd>");
            descriptionText.append(value);
            descriptionText.append("</dd>");
        }
        if (desc.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(desc));
        }
        return descriptionText.toString();
    }

    private static String getLocationTableRow(String fileName) {
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>Location</dt> ");
        helpBuffer.append("<dd>");
        helpBuffer.append(fileName);
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getSeeAlsoTagTableRows(Iterator it, PHPProjectModel projectModel, PHPCodeData phpCodeData) {
        String[] args;
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>See Also</dt>");
        helpBuffer.append("<dd>");
        UserData userData = phpCodeData.getUserData();
        String fileName = userData != null ? userData.getFileName() : null;
        PHPDocTag see = (PHPDocTag)it.next();
        String arg = see.getValue();
        String[] stringArray = args = arg.split(",");
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String ref = stringArray[n2];
            if (projectModel.getFileData(ref) != null) {
                helpBuffer.append(ref);
                break;
            }
            if (projectModel.getClass(ref).length > 0) {
                helpBuffer.append(ref);
                break;
            }
            if (projectModel.getConstant(ref).length > 0) {
                helpBuffer.append(ref);
                break;
            }
            boolean shouldBreak = false;
            if (phpCodeData instanceof PHPFunctionData && phpCodeData.getContainer() != null && phpCodeData.getContainer() instanceof PHPClassData) {
                if (ref.indexOf(40) != -1) {
                    ref = ref.substring(0, ref.indexOf(40));
                }
                if (fileName != null && projectModel.getClassFunctionData(fileName, phpCodeData.getContainer().getName(), ref) != null) {
                    helpBuffer.append(ref);
                    break;
                }
                if (fileName != null) {
                    CodeData[] data;
                    PHPCodeContext context = ModelSupport.createContext((CodeData)phpCodeData);
                    if (ref.startsWith("$")) {
                        ref = ref.substring(1);
                    }
                    CodeData[] codeDataArray = data = projectModel.getVariables(fileName, context, ref, true);
                    int n3 = data.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        CodeData codeData = codeDataArray[n4];
                        if (((PHPCodeData)codeData).getName().equals(ref)) {
                            helpBuffer.append(ref);
                            shouldBreak = true;
                            break;
                        }
                        ++n4;
                    }
                }
                if (shouldBreak) break;
                if (projectModel.getFunction(ref) != null && projectModel.getFunction(ref).length > 0) {
                    helpBuffer.append(ref);
                    break;
                }
            }
            helpBuffer.append(ref);
            ++n2;
        }
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getDeprecatedTagTableRow(Iterator it) {
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>Deprecated</dt>");
        helpBuffer.append("<dd>");
        PHPDocTag deprecated = (PHPDocTag)it.next();
        helpBuffer.append(deprecated.getValue());
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getReturnTagTableRows(Iterator it) {
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>Returns</dt>");
        PHPDocTag returns = (PHPDocTag)it.next();
        String arg = returns.getValue();
        helpBuffer.append("<dd>");
        helpBuffer.append(arg);
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getThrowTagTableRows(Iterator it) {
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>Throws</dt>");
        PHPDocTag throwTag = (PHPDocTag)it.next();
        String arg = throwTag.getValue();
        helpBuffer.append("<dd>");
        helpBuffer.append(arg);
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getParamTagTableRows(Iterator it) {
        helpBuffer.delete(0, helpBuffer.length());
        while (it.hasNext()) {
            PHPDocTag param = (PHPDocTag)it.next();
            String arg = param.getValue();
            arg = dolar_pattern.matcher(arg).replaceAll("");
            if ((arg = unknown_type_pattern.matcher(arg).replaceAll("")).split(" ").length <= 1) continue;
            helpBuffer.append("<dd>");
            helpBuffer.append(arg);
            helpBuffer.append("</dd>");
        }
        if (helpBuffer.toString().length() > 0) {
            String prefix = "<br><dt>Parameters</dt>";
            helpBuffer = helpBuffer.insert(0, prefix.toCharArray(), 0, prefix.length());
        }
        return helpBuffer.toString();
    }

    private static String getDescriptionTableRow(String description) {
        helpBuffer.delete(0, helpBuffer.length());
        description = description.replaceAll("\\n", "<br>");
        helpBuffer.append("<br><dt>Description</dt>");
        helpBuffer.append("<dd>");
        helpBuffer.append(description);
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getClassNameTableRow(String className, PHPProjectModel projectModel) {
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>Class</dt>");
        helpBuffer.append("<dd>");
        helpBuffer.append(className);
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    public static String getHTMLHyperlinkDescriptionText(CodeData codeData, PHPProjectModel projectModel) {
        if (!(codeData instanceof PHPCodeData)) {
            return "";
        }
        if (codeData instanceof PHPFunctionData) {
            return PHPCodeDataHTMLDescriptionUtilities.createFunctionDescriptionText((PHPCodeData)codeData, projectModel);
        }
        if (codeData instanceof PHPClassData) {
            return PHPCodeDataHTMLDescriptionUtilities.createClassDescriptionText((PHPClassData)codeData, projectModel);
        }
        if (codeData instanceof PHPClassVarData) {
            return PHPCodeDataHTMLDescriptionUtilities.createClassVariableDescriptionText((PHPClassVarData)codeData, projectModel);
        }
        if (codeData instanceof PHPVariableData) {
            return PHPCodeDataHTMLDescriptionUtilities.createVariableDescriptionText((PHPVariableData)codeData);
        }
        if (codeData instanceof PHPConstantData) {
            return PHPCodeDataHTMLDescriptionUtilities.createPHPConstantDescriptionText((PHPConstantData)codeData);
        }
        if (codeData instanceof PHPClassConstData) {
            return PHPCodeDataHTMLDescriptionUtilities.createPHPClassConstDescriptionText((PHPClassConstData)codeData, projectModel);
        }
        return "";
    }
}

