/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.text.Collator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.outline.PHPOutlineContentProvider;
import org.eclipse.php.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.php.internal.ui.projectOutline.ProjectOutlineContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.w3c.dom.Node;

public class PHPElementSorter
extends ViewerSorter {
    int flags;
    boolean usingCategories = true;
    boolean usingLocation = false;
    private static final int PROJECTS = 1;
    private static final int RESOURCEFOLDERS = 4;
    private static final int COMPILATIONUNITS = 5;
    private static final int RESOURCES = 8;
    private static final int STORAGE = 9;
    private static final int MEMBERSOFFSET = 16;
    private static final int OUTLINE_NODES = 15;
    private static final int DOM_NODES = 17;
    protected static final int OTHERS = 51;
    protected MembersOrderPreferenceCache fMemberOrderCache = PHPUiPlugin.getDefault().getMemberOrderPreferenceCache();

    public PHPElementSorter() {
        super(null);
    }

    public boolean isSorterProperty(Object element, Object property) {
        return true;
    }

    public int category(Object element) {
        if (element instanceof PHPCodeData) {
            if (element instanceof PHPFunctionData) {
                PHPFunctionData function = (PHPFunctionData)element;
                if (function.getContainer() instanceof PHPClassData && ("__construct".equals(function.getName()) || "__destruct".equals(function.getName()))) {
                    return this.getMemberCategory(3);
                }
                if (PHPModifier.isStatic((int)((PHPFunctionData)element).getModifiers())) {
                    return this.getMemberCategory(4);
                }
                return this.getMemberCategory(5);
            }
            if (element instanceof PHPClassData) {
                return this.getMemberCategory(6);
            }
            if (element instanceof PHPConstantData || element instanceof PHPClassConstData) {
                return this.getMemberCategory(1);
            }
            if (element instanceof PHPIncludeFileData) {
                return this.getMemberCategory(0);
            }
            if (element instanceof PHPClassVarData) {
                if (PHPModifier.isStatic((int)((PHPClassVarData)element).getModifiers())) {
                    return this.getMemberCategory(2);
                }
                return this.getMemberCategory(7);
            }
            if (element instanceof PHPClassData.PHPSuperClassNameData) {
                return 16;
            }
        }
        if (element instanceof PHPProjectModel) {
            return 1;
        }
        if (element instanceof PHPFileData) {
            return 5;
        }
        if (element instanceof IFile) {
            return 8;
        }
        if (element instanceof IProject) {
            return 1;
        }
        if (element instanceof IContainer) {
            return 4;
        }
        if (element instanceof IStorage) {
            return 9;
        }
        if (element instanceof ProjectOutlineContentProvider.OutlineNode || element instanceof PHPOutlineContentProvider.GroupNode) {
            return 15;
        }
        if (element instanceof Node) {
            return 17;
        }
        return 51;
    }

    protected int getMemberCategory(int kind) {
        int offset = this.fMemberOrderCache.getCategoryIndex(kind);
        return offset + 16;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat1 = this.category(e1);
        int cat2 = this.category(e2);
        if (this.usingCategories && cat1 != cat2) {
            return cat1 - cat2;
        }
        if (cat1 == 17) {
            return -1;
        }
        if (cat1 == 1 || cat1 == 8 || cat1 == 4 || cat1 == 9 || cat1 == 51) {
            String name2;
            String name1 = this.getNonPHPElementLabel(viewer, e1);
            if (name1 == (name2 = this.getNonPHPElementLabel(viewer, e2))) {
                return 0;
            }
            if (name1 != null) {
                return this.getCollator().compare(name1, name2);
            }
            return -1;
        }
        if (cat1 == 15 && cat2 == 15) {
            return ((Comparable)e1).compareTo(e2);
        }
        int vis = 0;
        if (e1 instanceof PHPCodeData && this.fMemberOrderCache.isSortByVisibility()) {
            int flags1 = this.getVisibilityCode(e1);
            int flags2 = this.getVisibilityCode(e2);
            vis = this.fMemberOrderCache.getVisibilityIndex(flags1) - this.fMemberOrderCache.getVisibilityIndex(flags2);
            if (this.usingCategories && vis != 0) {
                return vis;
            }
        }
        boolean currentUsingLocation = false;
        UserData userData1 = null;
        UserData userData2 = null;
        if (this.usingLocation && e1 instanceof PHPCodeData && e2 instanceof PHPCodeData) {
            currentUsingLocation = true;
            PHPCodeData code1 = (PHPCodeData)e1;
            PHPCodeData code2 = (PHPCodeData)e2;
            if (PHPModelUtil.getPHPFileContainer((PHPCodeData)code1) != PHPModelUtil.getPHPFileContainer((PHPCodeData)code2)) {
                currentUsingLocation = false;
            } else {
                userData1 = code1.getUserData();
                userData2 = code2.getUserData();
                if (userData1 == null || userData2 == null) {
                    currentUsingLocation = false;
                }
            }
        }
        if (currentUsingLocation) {
            return userData1.getStartPosition() - userData2.getStartPosition();
        }
        if (e1 instanceof PHPClassData.PHPSuperClassNameData) {
            if (!(e1 instanceof PHPClassData.PHPSuperClassNameData)) {
                return -1;
            }
        } else if (e2 instanceof PHPClassData.PHPSuperClassNameData) {
            return 1;
        }
        String name1 = this.getElementName(e1);
        String name2 = this.getElementName(e2);
        int cmp = this.getCollator().compare(name1, name2);
        if (cmp != 0) {
            return cmp;
        }
        if (e1 instanceof PHPFunctionData && e2 instanceof PHPFunctionData) {
            PHPFunctionData.PHPFunctionParameter[] params1 = ((PHPFunctionData)e1).getParameters();
            PHPFunctionData.PHPFunctionParameter[] params2 = ((PHPFunctionData)e2).getParameters();
            int len = Math.min(params1.length, params2.length);
            int i = 0;
            while (i < len) {
                String classType1 = params1[i].getClassType();
                String classType2 = params2[i].getClassType();
                if (classType1 == null) {
                    if (classType2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (classType2 == null) {
                    return -1;
                }
                ++i;
            }
            return params1.length - params2.length;
        }
        if (!this.usingCategories) {
            if (cat1 != cat2) {
                return cat1 - cat2;
            }
            return vis;
        }
        return 0;
    }

    private int getVisibilityCode(Object e) {
        if (e instanceof PHPClassData) {
            PHPClassData cls = (PHPClassData)e;
            return cls.getModifiers();
        }
        if (e instanceof PHPFunctionData) {
            PHPFunctionData function = (PHPFunctionData)e;
            return function.getModifiers();
        }
        if (e instanceof PHPClassVarData) {
            PHPClassVarData var = (PHPClassVarData)e;
            return var.getModifiers();
        }
        return 0;
    }

    private String getNonPHPElementLabel(Viewer viewer, Object element) {
        IBaseLabelProvider prov;
        IWorkbenchAdapter adapter;
        if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
            return adapter.getLabel(element);
        }
        if (viewer instanceof ContentViewer && (prov = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            return ((ILabelProvider)prov).getText(element);
        }
        return null;
    }

    public final Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance();
        }
        return this.collator;
    }

    private String getElementName(Object element) {
        if (element instanceof PHPCodeData) {
            return ((PHPCodeData)element).getName();
        }
        return element.toString();
    }

    public boolean isUsingCategories() {
        return this.usingCategories;
    }

    public void setUsingCategories(boolean usingCategories) {
        this.usingCategories = usingCategories;
    }

    public boolean isUsingLocation() {
        return this.usingLocation;
    }

    public void setUsingLocation(boolean usingLocation) {
        this.usingLocation = usingLocation;
    }
}

