/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.PHPManualSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPManual {
    private static final String BROWSER_ID = "PHPManual.browser";
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("http://[^\\s]*");
    private static int browserCount = 0;
    private PHPManualSite site;
    private static Map<String, String> phpEntityPathMap;

    public PHPManual(PHPManualSite site) {
        this.site = site;
    }

    public PHPManualSite getSite() {
        return this.site;
    }

    public void setSite(PHPManualSite site) {
        this.site = site;
    }

    private synchronized Map<String, String> getPHPEntityPathMap() {
        if (phpEntityPathMap == null) {
            phpEntityPathMap = new HashMap<String, String>();
            URL url = FileLocator.find((Bundle)Platform.getBundle((String)PHPUiPlugin.getPluginId()), (IPath)new Path("phpdoc.mapping"), null);
            if (url != null) {
                try {
                    String line;
                    BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
                    while ((line = r.readLine()) != null) {
                        int sepIdx = line.indexOf(61);
                        if (sepIdx == -1) continue;
                        phpEntityPathMap.put(line.substring(0, sepIdx).toLowerCase(), line.substring(sepIdx + 1));
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return phpEntityPathMap;
    }

    private String buildPathForMethod(String className, String methodName) {
        StringBuffer buf = new StringBuffer();
        buf.append("function.");
        if (className != null) {
            buf.append(className);
            buf.append("-");
        }
        buf.append(Pattern.compile("([A-Z])").matcher(methodName).replaceAll("-$1").replaceAll("_", "-"));
        return buf.toString().toLowerCase().replaceAll("-+", "-");
    }

    public String getURLForManual(PHPCodeData codeData) {
        if (codeData == null) {
            throw new IllegalArgumentException();
        }
        String path = null;
        PHPDocBlock docBlock = codeData.getDocBlock();
        if (docBlock != null) {
            Iterator i = docBlock.getTags(23);
            while (i.hasNext()) {
                PHPDocTag docTag = (PHPDocTag)i.next();
                Matcher m = HTTP_URL_PATTERN.matcher(docTag.getValue().trim());
                if (!m.find()) continue;
                try {
                    URL url = new URL(m.group());
                    path = new File(url.getFile()).getName();
                    int extIdx = path.lastIndexOf(46);
                    if (extIdx <= 0) break;
                    path = path.substring(0, extIdx);
                    break;
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        if (path == null) {
            if (codeData instanceof PHPFunctionData) {
                PHPFunctionData funcData = (PHPFunctionData)codeData;
                PHPCodeData container = funcData.getContainer();
                if (container instanceof PHPClassData) {
                    String functionName = String.valueOf(container.getName()) + "::" + funcData.getName();
                    path = this.getPHPEntityPathMap().get(functionName.toLowerCase());
                    if (path == null) {
                        path = this.buildPathForMethod(container.getName(), funcData.getName());
                    }
                } else {
                    path = this.getPHPEntityPathMap().get(funcData.getName().toLowerCase());
                    if (path == null) {
                        path = this.buildPathForMethod(null, funcData.getName());
                    }
                }
            } else if (codeData instanceof PHPKeywordData) {
                path = this.getPHPEntityPathMap().get(codeData.getName().toLowerCase());
            }
        }
        if (path == null) {
            return null;
        }
        StringBuffer url = new StringBuffer();
        url.append(this.site.getUrl());
        if (!this.site.getUrl().endsWith("/")) {
            url.append("/");
        }
        url.append(path);
        url.append(".");
        url.append(this.site.getExtension());
        return url.toString();
    }

    public void showFunctionHelp(String url) {
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
            IWebBrowser browser = store.getBoolean("phpManualOpenInNewBrowser") ? browserSupport.createBrowser(BROWSER_ID + ++browserCount) : browserSupport.createBrowser(BROWSER_ID);
            if (url.startsWith("mk:")) {
                browser.openURL(new URL(null, url, new MkHandler()));
            } else {
                browser.openURL(new URL(url));
            }
        }
        catch (PartInitException e) {
            Logger.logException(e);
        }
        catch (MalformedURLException e) {
            Logger.logException(e);
        }
    }

    private class MkHandler
    extends URLStreamHandler {
        private MkHandler() {
        }

        protected URLConnection openConnection(URL arg0) throws IOException {
            return null;
        }
    }
}

