/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.util.CollectionUtils;

public class ParentChecker {
    private IResource[] fResources;
    private PHPCodeData[] fPHPElements;

    public ParentChecker(IResource[] resources, PHPCodeData[] phpElements) {
        this.fResources = resources;
        this.fPHPElements = phpElements;
    }

    public boolean haveCommonParent() {
        return this.getCommonParent() != null;
    }

    public Object getCommonParent() {
        if (this.fPHPElements.length == 0 && this.fResources.length == 0) {
            return null;
        }
        if (!this.resourcesHaveCommonParent() || !this.phpElementsHaveCommonParent()) {
            return null;
        }
        if (this.fPHPElements.length == 0) {
            IResource commonResourceParent = this.getCommonResourceParent();
            PHPCodeData convertedToPHP = ParentChecker.getPHPCodeData(commonResourceParent);
            if (convertedToPHP != null) {
                return convertedToPHP;
            }
            return commonResourceParent;
        }
        if (this.fResources.length == 0) {
            return this.getCommonPHPElementParent();
        }
        IResource commonResourceParent = this.getCommonResourceParent();
        PHPCodeData commonPHPElementParent = this.getCommonPHPElementParent();
        PHPCodeData convertedToPHP = ParentChecker.getPHPCodeData(commonResourceParent);
        if (convertedToPHP == null || !commonPHPElementParent.equals(convertedToPHP)) {
            return null;
        }
        return commonPHPElementParent;
    }

    private static PHPCodeData getPHPCodeData(IResource resource) {
        return PHPWorkspaceModelManager.getInstance().getModelForFile((IFile)resource, false);
    }

    private PHPCodeData getCommonPHPElementParent() {
        return this.fPHPElements[0].getContainer();
    }

    private IResource getCommonResourceParent() {
        return this.fResources[0].getParent();
    }

    private boolean phpElementsHaveCommonParent() {
        if (this.fPHPElements.length == 0) {
            return true;
        }
        PHPCodeData firstParent = this.fPHPElements[0].getContainer();
        int i = 1;
        while (i < this.fPHPElements.length) {
            if (!firstParent.equals(this.fPHPElements[i].getContainer())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean resourcesHaveCommonParent() {
        if (this.fResources.length == 0) {
            return true;
        }
        IContainer firstParent = this.fResources[0].getParent();
        int i = 1;
        while (i < this.fResources.length) {
            if (!firstParent.equals((Object)this.fResources[i].getParent())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IResource[] getResources() {
        return this.fResources;
    }

    public PHPCodeData[] getPHPElements() {
        return this.fPHPElements;
    }

    public void removeElementsWithAncestorsOnList(boolean removeOnlyPHPElements) {
        if (!removeOnlyPHPElements) {
            this.removeResourcesDescendantsOfResources();
            this.removeResourcesDescendantsOfPHPElements();
        }
        this.removePHPElementsDescendantsOfPHPElements();
    }

    private void removeResourcesDescendantsOfPHPElements() {
        ArrayList<IResource> subResources = new ArrayList<IResource>(3);
        int i = 0;
        while (i < this.fResources.length) {
            IResource subResource = this.fResources[i];
            int j = 0;
            while (j < this.fPHPElements.length) {
                PHPCodeData superElements = this.fPHPElements[j];
                if (ParentChecker.isDescendantOf(subResource, superElements)) {
                    subResources.add(subResource);
                }
                ++j;
            }
            ++i;
        }
        this.removeFromSetToDelete(subResources.toArray(new IResource[subResources.size()]));
    }

    private void removePHPElementsDescendantsOfPHPElements() {
        ArrayList<PHPCodeData> subElements = new ArrayList<PHPCodeData>(3);
        int i = 0;
        while (i < this.fPHPElements.length) {
            PHPCodeData subElement = this.fPHPElements[i];
            int j = 0;
            while (j < this.fPHPElements.length) {
                PHPCodeData superElement = this.fPHPElements[j];
                if (ParentChecker.isDescendantOf(subElement, superElement)) {
                    subElements.add(subElement);
                }
                ++j;
            }
            ++i;
        }
        this.removeFromSetToDelete(subElements.toArray(new PHPCodeData[subElements.size()]));
    }

    private void removeResourcesDescendantsOfResources() {
        ArrayList<IResource> subResources = new ArrayList<IResource>(3);
        int i = 0;
        while (i < this.fResources.length) {
            IResource subResource = this.fResources[i];
            int j = 0;
            while (j < this.fResources.length) {
                IResource superResource = this.fResources[j];
                if (ParentChecker.isDescendantOf(subResource, superResource)) {
                    subResources.add(subResource);
                }
                ++j;
            }
            ++i;
        }
        this.removeFromSetToDelete(subResources.toArray(new IResource[subResources.size()]));
    }

    public static boolean isDescendantOf(IResource subResource, PHPCodeData superElement) {
        IContainer parent = subResource.getParent();
        while (parent != null) {
            PHPCodeData el = ParentChecker.getPHPCodeData((IResource)parent);
            if (el != null && el.equals(superElement)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isDescendantOf(PHPCodeData subElement, PHPCodeData superElement) {
        if (subElement.equals(superElement)) {
            return false;
        }
        PHPCodeData parent = subElement.getContainer();
        while (parent != null) {
            if (parent.equals(superElement)) {
                return true;
            }
            parent = parent.getContainer();
        }
        return false;
    }

    public static boolean isDescendantOf(IResource subResource, IResource superResource) {
        return !subResource.equals((Object)superResource) && superResource.getFullPath().isPrefixOf(subResource.getFullPath());
    }

    private void removeFromSetToDelete(IResource[] resourcesToNotDelete) {
        this.fResources = CollectionUtils.setMinus(this.fResources, resourcesToNotDelete);
    }

    private void removeFromSetToDelete(PHPCodeData[] elementsToNotDelete) {
        this.fPHPElements = CollectionUtils.setMinus(this.fPHPElements, elementsToNotDelete);
    }
}

