/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.IProblemChangedListener;
import org.eclipse.php.internal.ui.util.PHPPluginImages;

public class ProblemsLabelDecorator
implements ILightweightLabelDecorator {
    private static final int ERRORTICK_WARNING = 32;
    private static final int ERRORTICK_ERROR = 64;
    private IProblemChangedListener fProblemChangedListener;
    private Collection fListeners;

    protected int computeAdornmentFlags(Object obj) {
        try {
            if (obj instanceof PHPProjectModel) {
                obj = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)obj);
            }
            if (obj instanceof PHPCodeData) {
                IResource resource = PHPModelUtil.getResource((Object)obj);
                return this.getErrorTicksFromMarkers(resource, 1, (PHPCodeData)obj);
            }
            if (obj instanceof IResource) {
                return this.getErrorTicksFromMarkers((IResource)obj, 2, null);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 376) {
                return 0;
            }
            PHPUiPlugin.log(e);
        }
        return 0;
    }

    private int getErrorTicksFromMarkers(IResource res, int depth, PHPCodeData sourceElement) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return 0;
        }
        int info = 0;
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        if (markers != null) {
            int i = 0;
            while (i < markers.length && info != 64) {
                IMarker curr = markers[i];
                if (sourceElement == null || this.isMarkerInRange(curr, sourceElement)) {
                    int priority = curr.getAttribute("severity", -1);
                    if (priority == 1) {
                        info = 32;
                    } else if (priority == 2) {
                        info = 64;
                    }
                }
                ++i;
            }
        }
        return info;
    }

    private boolean isMarkerInRange(IMarker marker, PHPCodeData sourceElement) throws CoreException {
        if (marker.isSubtypeOf("org.eclipse.core.resources.textmarker")) {
            int pos = marker.getAttribute("charStart", -1);
            return this.isInside(pos, sourceElement);
        }
        return false;
    }

    protected boolean isInside(int pos, PHPCodeData sourceElement) throws CoreException {
        UserData userdata = sourceElement.getUserData();
        if (userdata != null) {
            int rangeOffset = userdata.getStartPosition();
            return rangeOffset <= pos && userdata.getStopPosition() > pos;
        }
        return false;
    }

    public void dispose() {
        if (this.fProblemChangedListener != null) {
            PHPUiPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
            this.fProblemChangedListener = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList();
        }
        this.fListeners.add(listener);
        if (this.fProblemChangedListener == null) {
            this.fProblemChangedListener = new IProblemChangedListener(){

                public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
                    ProblemsLabelDecorator.this.fireProblemsChanged(changedResources, isMarkerChange);
                }
            };
            PHPUiPlugin.getDefault().getProblemMarkerManager().addListener(this.fProblemChangedListener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove(listener);
            if (this.fListeners.isEmpty() && this.fProblemChangedListener != null) {
                PHPUiPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
                this.fProblemChangedListener = null;
            }
        }
    }

    private void fireProblemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            ProblemsLabelChangedEvent event = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, changedResources, isMarkerChange);
            Object[] listeners = this.fListeners.toArray();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged((LabelProviderChangedEvent)event);
                ++i;
            }
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags == 64) {
            decoration.addOverlay(PHPPluginImages.DESC_OVR_ERROR);
        } else if (adornmentFlags == 32) {
            decoration.addOverlay(PHPPluginImages.DESC_OVR_WARNING);
        }
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider source, IResource[] changedResource, boolean isMarkerChange) {
            super(source, (Object[])changedResource);
            this.fMarkerChange = isMarkerChange;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

