/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.util.PHPElementLabels;

public class StatusBarUpdater
implements ISelectionChangedListener {
    private final long LABEL_FLAGS = 1090519051L;
    private IStatusLineManager fStatusLineManager;

    public StatusBarUpdater(IStatusLineManager statusLineManager) {
        this.fStatusLineManager = statusLineManager;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        String statusBarMessage = this.formatMessage(event.getSelection());
        this.fStatusLineManager.setMessage(statusBarMessage);
    }

    protected String formatMessage(ISelection sel) {
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            int nElements = selection.size();
            if (nElements > 1) {
                return MessageFormat.format(PHPUIMessages.getString("StatusBarUpdater_num_elements_selected"), String.valueOf(nElements));
            }
            Object elem = selection.getFirstElement();
            if (elem instanceof PHPCodeData || elem instanceof PHPWorkspaceModelManager || elem instanceof PHPProjectModel) {
                return this.formatPHPElementMessage(elem);
            }
            if (elem instanceof IResource) {
                return this.formatResourceMessage((IResource)elem);
            }
        }
        return "";
    }

    private String formatPHPElementMessage(Object element) {
        PHPCodeData codeData;
        UserData userData;
        String postfix = "";
        if (element instanceof PHPCodeData && (userData = (codeData = (PHPCodeData)element).getUserData()) != null) {
            postfix = " (" + userData.getFileName() + ")";
        }
        String text = PHPElementLabels.getElementLabel(element, 1090519051L);
        return String.valueOf(text) + postfix;
    }

    private String formatResourceMessage(IResource element) {
        IContainer parent = element.getParent();
        if (parent != null && parent.getType() != 8) {
            return String.valueOf(element.getName()) + " - " + parent.getFullPath().makeRelative().toString();
        }
        return element.getName();
    }
}

