/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.PHPVersionConfigurationBlock;
import org.eclipse.php.internal.ui.wizards.IEnablementToggleGroup;
import org.eclipse.php.internal.ui.wizards.PHPProjectWizardBasePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class PHPVersionGroup
implements SelectionListener,
IEnablementToggleGroup {
    private final Group fGroup;
    private final Link fPreferenceLink;
    private final PHPProjectWizardBasePage fPage;
    protected Button fEnableProjectSettings;
    protected PHPVersionConfigurationBlock fConfigurationBlock;
    private String fDisabledTooptipText = "";

    public PHPVersionGroup(Composite composite, PHPProjectWizardBasePage projectWizardBasePage) {
        this.fPage = projectWizardBasePage;
        this.fGroup = new Group(composite, 0);
        this.fGroup.setFont(composite.getFont());
        GridLayout layout = new GridLayout();
        this.fGroup.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.fGroup.setLayoutData((Object)data);
        this.fGroup.setText(PHPUIMessages.getString("PHPVersionGroup_OptionBlockTitle"));
        Composite checkLinkComposite = new Composite((Composite)this.fGroup, 0);
        checkLinkComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        checkLinkComposite.setLayout((Layout)new GridLayout(2, false));
        this.fEnableProjectSettings = new Button(checkLinkComposite, 131104);
        this.fEnableProjectSettings.setText(PHPUIMessages.getString("PHPVersionGroup_EnableProjectSettings"));
        this.fEnableProjectSettings.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fEnableProjectSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPVersionGroup.this.updateEnableState();
            }
        });
        this.fPreferenceLink = new Link(checkLinkComposite, 0);
        this.fPreferenceLink.setFont(this.fGroup.getFont());
        this.fPreferenceLink.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        this.fPreferenceLink.setText(PHPUIMessages.getString("PHPVersionGroup_ConfigWorkspaceSettings"));
        this.fPreferenceLink.addSelectionListener((SelectionListener)this);
        Composite versionComposite = new Composite((Composite)this.fGroup, 0);
        versionComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        versionComposite.setLayout((Layout)new GridLayout(2, false));
        this.fConfigurationBlock = this.createConfigurationBlock(this.getNewStatusChangedListener(), this.getProject(), null);
        this.fConfigurationBlock.createContents(versionComposite);
        this.fConfigurationBlock.setEnabled(false);
    }

    private void updateEnableState() {
        if (this.fEnableProjectSettings.getSelection()) {
            this.fConfigurationBlock.setEnabled(true);
        } else {
            this.fConfigurationBlock.performRevert();
            this.fConfigurationBlock.setEnabled(false);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        this.widgetDefaultSelected(e);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        String prefID = "org.eclipse.php.ui.preferences.PHPInterpreterPreferencePage";
        Object data = null;
        PreferencesUtil.createPreferenceDialogOn((Shell)this.fPage.getShell(), (String)prefID, (String[])new String[]{prefID}, data).open();
        if (!this.fEnableProjectSettings.getSelection()) {
            this.fConfigurationBlock.performRevert();
        }
    }

    protected IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject("DUMMY______________Project");
    }

    protected IStatusChangeListener getNewStatusChangedListener() {
        return new IStatusChangeListener(){

            public void statusChanged(IStatus status) {
            }
        };
    }

    public void setPropertiesInDataModel(IDataModel dataModel) {
        if (this.fEnableProjectSettings.getSelection()) {
            String version = this.fConfigurationBlock.getPHPVersionValue();
            boolean useASPTags = this.fConfigurationBlock.getUseAspTagsValue();
            dataModel.setBooleanProperty("use_asp_tags_as_php", useASPTags);
            dataModel.setStringProperty("phpVersion", version);
        }
    }

    protected PHPVersionConfigurationBlock createConfigurationBlock(IStatusChangeListener listener, IProject project, IWorkbenchPreferenceContainer container) {
        return new PHPVersionConfigurationBlock(listener, project, container);
    }

    public PHPVersionConfigurationBlock getVersionBlock() {
        return this.fConfigurationBlock;
    }

    public void setVisible(boolean visible) {
        this.fGroup.setVisible(visible);
    }

    public void setEnabled(boolean enabled) {
        this.fGroup.setEnabled(enabled);
        this.fConfigurationBlock.setEnabled(enabled);
        this.fPreferenceLink.setEnabled(enabled);
    }

    public void setToolTipText(String disableTooltip) {
        this.fGroup.setToolTipText(disableTooltip);
        this.fConfigurationBlock.setToolTipText(disableTooltip);
    }
}

