/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.PHPNature;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.internal.core.project.properties.handlers.UseAspTagsHandler;
import org.eclipse.php.internal.ui.wizards.WizardPageFactory;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.IProjectCreationPropertiesNew;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.web.core.internal.project.JsWebNature;

public class PHPModelCreationOperation
extends AbstractDataModelOperation
implements IProjectCreationPropertiesNew {
    private List wizardPageFactories = new ArrayList();

    public PHPModelCreationOperation(IDataModel dataModel, List wizardPageFactories) {
        super(dataModel);
        this.wizardPageFactories = wizardPageFactories;
    }

    public PHPModelCreationOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        block8: {
            try {
                try {
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, -1);
                    final IProjectDescription desc = (IProjectDescription)this.model.getProperty("IProjectCreationPropertiesNew.PROJECT_DESCRIPTION");
                    final IProject project = (IProject)this.model.getProperty("IProjectCreationPropertiesNew.PROJECT");
                    if (!project.exists()) {
                        project.create(desc, (IProgressMonitor)subMonitor);
                    }
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    subMonitor = new SubProgressMonitor(monitor, -1);
                    project.open((IProgressMonitor)subMonitor);
                    WorkspaceJob job = new WorkspaceJob("Saving project options"){

                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                            PHPNature nature;
                            boolean addJavaScript;
                            for (WizardPageFactory pageFactory : PHPModelCreationOperation.this.wizardPageFactories) {
                                pageFactory.execute();
                            }
                            String[] natureIds = (String[])PHPModelCreationOperation.this.model.getProperty("IProjectCreationPropertiesNew.PROJECT_NATURES");
                            if (natureIds != null) {
                                desc.setNatureIds(natureIds);
                                project.setDescription(desc, monitor);
                            }
                            if (addJavaScript = PHPModelCreationOperation.this.model.getBooleanProperty("org.eclipse.php.core.addJsNature")) {
                                nature = new JsWebNature(project, null);
                                nature.configure();
                            }
                            nature = (PHPNature)project.getNature("org.eclipse.php.core.PHPNature");
                            PHPProjectOptions options = nature.getOptions();
                            String defaultEncodeing = PHPModelCreationOperation.this.model.getStringProperty("org.eclipse.php.core.defaultEncoding");
                            options.setOption("org.eclipse.php.core.defaultEncoding", (Object)defaultEncodeing);
                            String context = PHPModelCreationOperation.this.model.getStringProperty("org.eclipse.php.core.contextRoot");
                            options.setOption("org.eclipse.php.core.contextRoot", (Object)context);
                            IIncludePathEntry[] includePath = (IIncludePathEntry[])PHPModelCreationOperation.this.model.getProperty("org.eclipse.php.core.includePath");
                            options.setRawIncludePath(includePath, new SubProgressMonitor(monitor, includePath.length));
                            if (PHPModelCreationOperation.this.model.isPropertySet("phpVersion")) {
                                String version = PHPModelCreationOperation.this.model.getStringProperty("phpVersion");
                                PhpVersionProjectPropertyHandler.setVersion((String)version, (IProject)project);
                                boolean useASPTags = PHPModelCreationOperation.this.model.getBooleanProperty("use_asp_tags_as_php");
                                UseAspTagsHandler.setUseAspTagsAsPhp((boolean)useASPTags, (IProject)project);
                            }
                            if (addJavaScript) {
                                IJavaScriptProject scriptProject = JavaScriptCore.create((IProject)project);
                                org.eclipse.wst.jsdt.core.IIncludePathEntry[] rawIncludepath = scriptProject.getRawIncludepath();
                                scriptProject.setRawIncludepath(PHPModelCreationOperation.this.getTrimmedIncludePath(rawIncludepath), (IProgressMonitor)new NullProgressMonitor());
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setRule((ISchedulingRule)project.getWorkspace().getRoot());
                    job.schedule();
                }
                catch (CoreException e) {
                    Logger.logException((Throwable)e);
                    monitor.done();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return OK_STATUS;
    }

    private org.eclipse.wst.jsdt.core.IIncludePathEntry[] getTrimmedIncludePath(org.eclipse.wst.jsdt.core.IIncludePathEntry[] rawIncludepath) {
        ArrayList<org.eclipse.wst.jsdt.core.IIncludePathEntry> newIncludePath = new ArrayList<org.eclipse.wst.jsdt.core.IIncludePathEntry>();
        int i = 0;
        while (i < rawIncludepath.length) {
            org.eclipse.wst.jsdt.core.IIncludePathEntry includePathEntry = rawIncludepath[i];
            if (includePathEntry.getEntryKind() != 3) {
                newIncludePath.add(includePathEntry);
            }
            ++i;
        }
        return newIncludePath.toArray(new org.eclipse.wst.jsdt.core.IIncludePathEntry[newIncludePath.size()]);
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }
}

