/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;

public class PHPWorkingSetUpdater
implements IWorkingSetUpdater,
ModelListener {
    public static final String ID = "org.eclipse.php.ui.workingset.PHPWorkingSetPage";
    private List fWorkingSets = new ArrayList();
    static final int ADD = 1;
    static final int CHANGE = 2;
    static final int REMOVE = 3;

    public PHPWorkingSetUpdater() {
        PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IWorkingSet workingSet) {
        this.checkElementExistence(workingSet);
        List list = this.fWorkingSets;
        synchronized (list) {
            this.fWorkingSets.add(workingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IWorkingSet workingSet) {
        boolean result;
        List list = this.fWorkingSets;
        synchronized (list) {
            result = this.fWorkingSets.remove(workingSet);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(IWorkingSet workingSet) {
        List list = this.fWorkingSets;
        synchronized (list) {
            return this.fWorkingSets.contains(workingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List list = this.fWorkingSets;
        synchronized (list) {
            this.fWorkingSets.clear();
        }
        PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elementChanged(PHPFileData fileData, int type) {
        IWorkingSet[] workingSets;
        List list = this.fWorkingSets;
        synchronized (list) {
            workingSets = this.fWorkingSets.toArray(new IWorkingSet[this.fWorkingSets.size()]);
        }
        int w = 0;
        while (w < workingSets.length) {
            WorkingSetDelta workingSetDelta = new WorkingSetDelta(workingSets[w]);
            this.processPHPChange(workingSetDelta, fileData, type);
            workingSetDelta.process();
            ++w;
        }
    }

    private void processPHPChange(WorkingSetDelta result, PHPFileData fileData, int type) {
        int index = result.indexOf(fileData);
        if (index != -1 && type == 3) {
            result.remove(index);
        }
    }

    private void processResourceDelta(WorkingSetDelta result, IResourceDelta delta) {
        IResource resource = delta.getResource();
        int type = resource.getType();
        int index = result.indexOf(resource);
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (kind == 4 && type == 4 && index != -1 && (flags & 0x4000) != 0) {
            result.set(index, resource);
        }
        if (index != -1 && kind == 2) {
            if ((flags & 0x2000) != 0) {
                result.set(index, ResourcesPlugin.getWorkspace().getRoot().findMember(delta.getMovedToPath()));
            } else {
                result.remove(index);
            }
        }
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processResourceDelta(result, children[i]);
            ++i;
        }
    }

    private void checkElementExistence(IWorkingSet workingSet) {
        ArrayList elements = new ArrayList(Arrays.asList(workingSet.getElements()));
        boolean changed = false;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            IAdaptable element = (IAdaptable)iter.next();
            boolean remove = false;
            if (element instanceof PHPCodeData) {
                PHPCodeData phpElement = (PHPCodeData)element;
                IResource resource = PHPModelUtil.getResource((Object)phpElement);
                IProject project = resource.getProject();
                remove = (project == null || project.isOpen()) && !resource.exists();
            } else if (element instanceof IResource) {
                IResource resource = (IResource)element;
                IProject project = resource.getProject();
                boolean bl = remove = (project == null || project.isOpen()) && !resource.exists();
            }
            if (!remove) continue;
            iter.remove();
            changed = true;
        }
        if (changed) {
            workingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }
    }

    public void fileDataChanged(PHPFileData fileData) {
        this.elementChanged(fileData, 2);
    }

    public void fileDataAdded(PHPFileData fileData) {
        this.elementChanged(fileData, 1);
    }

    public void fileDataRemoved(PHPFileData fileData) {
        this.elementChanged(fileData, 3);
    }

    public void dataCleared() {
    }

    private static class WorkingSetDelta {
        private IWorkingSet fWorkingSet;
        private List fElements;
        private boolean fChanged;

        public WorkingSetDelta(IWorkingSet workingSet) {
            this.fWorkingSet = workingSet;
            this.fElements = new ArrayList(Arrays.asList(workingSet.getElements()));
        }

        public int indexOf(Object element) {
            return this.fElements.indexOf(element);
        }

        public void set(int index, Object element) {
            this.fElements.set(index, element);
            this.fChanged = true;
        }

        public void remove(int index) {
            if (this.fElements.remove(index) != null) {
                this.fChanged = true;
            }
        }

        public void process() {
            if (this.fChanged) {
                this.fWorkingSet.setElements(this.fElements.toArray(new IAdaptable[this.fElements.size()]));
            }
        }
    }
}

