/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetFilter
extends ViewerFilter {
    private IWorkingSet fWorkingSet = null;
    private IAdaptable[] fCachedWorkingSet = null;

    public IWorkingSet getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.fWorkingSet = workingSet;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fWorkingSet == null) {
            return true;
        }
        if (element instanceof PHPCodeData) {
            return this.isEnclosing((PHPCodeData)element);
        }
        if (element instanceof IResource) {
            return this.isEnclosing(((IResource)element).getFullPath());
        }
        if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            PHPCodeData je = (PHPCodeData)adaptable.getAdapter(PHPCodeData.class);
            if (je != null) {
                return this.isEnclosing(je);
            }
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource != null) {
                return this.isEnclosing(resource.getFullPath());
            }
        }
        return true;
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        Object[] result = null;
        if (this.fWorkingSet != null) {
            this.fCachedWorkingSet = this.fWorkingSet.getElements();
        }
        try {
            result = super.filter(viewer, parent, elements);
        }
        finally {
            this.fCachedWorkingSet = null;
        }
        return result;
    }

    private boolean isEnclosing(IPath elementPath) {
        if (elementPath == null) {
            return false;
        }
        IAdaptable[] cachedWorkingSet = this.fCachedWorkingSet;
        if (cachedWorkingSet == null) {
            cachedWorkingSet = this.fWorkingSet.getElements();
        }
        int length = cachedWorkingSet.length;
        int i = 0;
        while (i < length) {
            if (this.isEnclosing(cachedWorkingSet[i], elementPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isEnclosing(PHPCodeData element) {
        IAdaptable[] cachedWorkingSet = this.fCachedWorkingSet;
        if (cachedWorkingSet == null) {
            cachedWorkingSet = this.fWorkingSet.getElements();
        }
        boolean isElementPathComputed = false;
        IPath elementPath = null;
        int length = cachedWorkingSet.length;
        int i = 0;
        while (i < length) {
            PHPCodeData scopeElement = (PHPCodeData)cachedWorkingSet[i].getAdapter(PHPCodeData.class);
            if (scopeElement != null) {
                PHPCodeData searchedElement = element;
                while (scopeElement != null && searchedElement != null) {
                    if (searchedElement.equals(scopeElement)) {
                        return true;
                    }
                    searchedElement = searchedElement.getContainer();
                }
                while (scopeElement != null && element != null) {
                    if (element.equals(scopeElement)) {
                        return true;
                    }
                    scopeElement = scopeElement.getContainer();
                }
            } else {
                if (!isElementPathComputed) {
                    elementPath = PHPModelUtil.getResource((Object)element).getFullPath();
                }
                if (this.isEnclosing(cachedWorkingSet[i], elementPath)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isEnclosing(IAdaptable element, IPath path) {
        PHPCodeData phpElement;
        if (path == null) {
            return false;
        }
        IPath elementPath = null;
        IResource elementResource = (IResource)element.getAdapter(IResource.class);
        if (elementResource != null) {
            elementPath = elementResource.getFullPath();
        }
        if (elementPath == null && (phpElement = (PHPCodeData)element.getAdapter(PHPCodeData.class)) != null) {
            elementPath = PHPModelUtil.getResource((Object)phpElement).getFullPath();
        }
        if (elementPath == null && element instanceof IStorage) {
            elementPath = ((IStorage)element).getFullPath();
        }
        if (elementPath == null) {
            return false;
        }
        if (elementPath.isPrefixOf(path)) {
            return true;
        }
        return path.isPrefixOf(elementPath);
    }
}

