/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.console;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.debug.core.IPHPConsoleEventListener;
import org.eclipse.php.internal.debug.core.launching.DebugConsoleMonitor;
import org.eclipse.php.internal.debug.core.launching.PHPHyperLink;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugError;
import org.eclipse.php.internal.debug.ui.console.PHPFileLink;
import org.eclipse.ui.console.IHyperlink;

public class PHPConsoleListener
implements IPHPConsoleEventListener {
    protected ILaunch fLaunch;
    protected DebugConsoleMonitor fConsoleMonitor;
    protected PHPHyperLink fPHPHyperLink;

    public void init(ILaunch launch, DebugConsoleMonitor consoleMonitor, PHPHyperLink link) {
        this.fLaunch = launch;
        this.fConsoleMonitor = consoleMonitor;
        this.fPHPHyperLink = link;
    }

    public void handleEvent(DebugError debugError) {
        IHyperlink link = this.createLink(debugError);
        String message = debugError.toString().trim();
        this.fPHPHyperLink.addLink(link, message, message.length() - debugError.getErrorTextLength());
        this.fConsoleMonitor.append(String.valueOf(debugError.toString()) + '\n');
    }

    protected IHyperlink createLink(DebugError debugError) {
        PHPFileLink fileLink = null;
        String fileName = debugError.getFullPathName();
        int lineNumber = debugError.getLineNumber();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
        if (file == null) {
            Object fileObject = null;
            if (ExternalFilesRegistry.getInstance().isEntryExist(new Path(fileName).toOSString())) {
                fileObject = ExternalFilesRegistry.getInstance().getFileEntry(new Path(fileName).toOSString());
            } else {
                file = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(fileName);
                if (file != null) {
                    fileObject = file;
                } else {
                    File externalFile;
                    PHPFileData fileData = null;
                    try {
                        fileData = PHPWorkspaceModelManager.getInstance().getModelForFile(fileName);
                    }
                    catch (Exception exception) {}
                    fileObject = fileData != null ? fileData : ((externalFile = new File(fileName)).exists() ? externalFile : ExternalFileWrapper.createFile((String)fileName));
                }
            }
            if (fileObject != null) {
                fileLink = new PHPFileLink(fileObject, -1, -1, lineNumber);
            }
        } else {
            fileLink = new PHPFileLink(file, -1, -1, lineNumber);
        }
        return fileLink;
    }
}

