/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

public class ExtendedWorkbenchContentProvider
extends BaseWorkbenchContentProvider {
    private boolean isProvidingExternals;

    public ExtendedWorkbenchContentProvider() {
        this.isProvidingExternals = true;
    }

    public ExtendedWorkbenchContentProvider(boolean provideExternalFiles) {
        this.isProvidingExternals = provideExternalFiles;
    }

    public void setProvideExternalFiles(boolean shouldProvide) {
        this.isProvidingExternals = shouldProvide;
    }

    public boolean isProvidingExternalFiles() {
        return this.isProvidingExternals;
    }

    public Object[] getChildren(Object element) {
        Object[] children = super.getChildren(element);
        if (this.isProvidingExternals && element instanceof IWorkspaceRoot) {
            Object[] externalFiles = ExternalFilesRegistry.getInstance().getAllAsIFiles();
            if ((externalFiles = this.filterNonExistingFiles((IFile[])externalFiles)).length > 0) {
                if (children.length == 0) {
                    return externalFiles;
                }
                Object[] combinedChildren = new Object[children.length + externalFiles.length];
                System.arraycopy(children, 0, combinedChildren, 0, children.length);
                System.arraycopy(externalFiles, 0, combinedChildren, children.length, externalFiles.length);
                return combinedChildren;
            }
        }
        return children;
    }

    private IFile[] filterNonExistingFiles(IFile[] files) {
        ArrayList<IFile> existingFiles = new ArrayList<IFile>(files.length);
        int i = 0;
        while (i < files.length) {
            if (files[i].getFullPath().toFile().exists()) {
                existingFiles.add(files[i]);
            }
            ++i;
        }
        IFile[] existing = new IFile[existingFiles.size()];
        existingFiles.toArray(existing);
        return existing;
    }
}

