/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.binding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.php.internal.core.ast.binding.ArrayAttribute;
import org.eclipse.php.internal.core.ast.binding.Attribute;
import org.eclipse.php.internal.core.ast.binding.AttributeType;
import org.eclipse.php.internal.core.ast.binding.GlobalScope;
import org.eclipse.php.internal.core.ast.binding.Scope;
import org.eclipse.php.internal.core.ast.binding.ScopeType;
import org.eclipse.php.internal.core.ast.binding.TypeResolver;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.BackTickExpression;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.AbstractVisitor;

public class ProgramScope
extends AbstractVisitor
implements Scope {
    private GlobalScope rootGlobalScope;
    private final Map classScopes = new HashMap();
    private final Map functionScopes = new HashMap();
    private GlobalScope currentGlobalScope;

    public ProgramScope(Program program) {
        this.currentGlobalScope = this.rootGlobalScope = GlobalScope.createRootScope(program.getStart(), this);
        program.accept(this);
    }

    private void attachAttributes(int start, ListVariable list, Attribute attribute) {
        VariableBase[] variables = list.getVariables();
        Attribute[] attributes = new Attribute[variables.length];
        if (attribute.getType() == AttributeType.ARRAY_ATTRIBUTE) {
            ArrayAttribute arrayAttribute = (ArrayAttribute)attribute;
            int i = 0;
            Iterator iter = arrayAttribute.getAttrributes().iterator();
            while (iter.hasNext()) {
                Attribute element;
                attributes[i] = element = (Attribute)iter.next();
                ++i;
            }
        } else {
            attributes[0] = attribute;
        }
        int i = 0;
        while (i < variables.length) {
            VariableBase variable = variables[i];
            this.attachVariableBase(start, variable, attributes[i]);
            ++i;
        }
    }

    private void attachIndexedVariable(int start, Attribute attribute, ArrayAccess variable) {
        Expression variableName = variable.getVariableName();
        if (variableName.getType() == 33) {
            String identifier = ((Identifier)variableName).getName();
            ArrayAttribute arrayAttribute = new ArrayAttribute();
            arrayAttribute.addAttribute(attribute);
            this.updateScope(start, identifier, arrayAttribute);
        }
    }

    private void attachVariable(int start, Attribute attribute, Variable variable) {
        Expression variableName = variable.getVariableName();
        if (variableName.getType() == 33) {
            String identifier = ((Identifier)variableName).getName();
            this.updateScope(start, identifier, attribute);
        }
    }

    private void attachVariableBase(int start, VariableBase variable, Attribute attribute) {
        if (attribute == null) {
            attribute = Attribute.NULL_ATTRIBUTE;
        }
        switch (variable.getType()) {
            case 41: {
                this.attachAttributes(start, (ListVariable)variable, attribute);
                break;
            }
            case 43: {
                break;
            }
            case 24: {
                break;
            }
            case 0: {
                this.attachIndexedVariable(start, attribute, (ArrayAccess)variable);
                break;
            }
            case 49: {
                break;
            }
            case 52: {
                break;
            }
            case 60: {
                this.attachVariable(start, attribute, (Variable)variable);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad assignment");
            }
        }
    }

    public Scope getChild() {
        return null;
    }

    public int getLength() {
        return Integer.MAX_VALUE;
    }

    public Scope getParent() {
        return null;
    }

    public Scope getScope(int offset) {
        return null;
    }

    public ScopeType getScopeType() {
        return null;
    }

    public int getStart() {
        return 0;
    }

    public Attribute lookup(StaticConstantAccess classConstant) {
        return Attribute.NULL_ATTRIBUTE;
    }

    public Attribute lookup(String identifier) {
        return null;
    }

    public Attribute lookup(VariableBase variable) {
        return null;
    }

    public Attribute probe(String identifier) {
        return null;
    }

    private Attribute resolveAttribute(Expression value) {
        return TypeResolver.resolve(this.currentGlobalScope, value);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(buffer, "");
        return buffer.toString();
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ProgramScope>\n");
        buffer.append("\t").append(tab).append("<RootGlobalScope>\n");
        this.rootGlobalScope.toString(buffer, "\t\t" + tab);
        buffer.append("\t").append(tab).append("</RootGlobalScope>\n");
        buffer.append("\t").append(tab).append("<ClassScopes>\n");
        for (Scope scope : this.classScopes.values()) {
            scope.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</ClassScopes>\n");
        buffer.append("\t").append(tab).append("<FunctionScopes>\n");
        for (Scope scope : this.functionScopes.values()) {
            scope.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</FunctionScopes>\n");
        buffer.append(tab).append("</ProgramScope>");
    }

    private void updateScope(int start, String identifier, Attribute attribute) {
        Attribute found = this.currentGlobalScope.lookup(identifier);
        if (!(found != null && found.equals(attribute) || start == this.currentGlobalScope.start)) {
            this.currentGlobalScope = this.currentGlobalScope.enterScope(start);
        }
        this.currentGlobalScope.insertIdentifier(identifier, attribute);
    }

    public void visit(Assignment assignment) {
        Attribute attribute = this.resolveAttribute(assignment.getValue());
        this.attachVariableBase(assignment.getStart(), assignment.getVariable(), attribute);
    }

    public void visit(BackTickExpression expression) {
    }

    public void visit(Program program) {
        super.visit(program);
    }

    public void visit(StaticMethodInvocation invocation) {
    }
}

