/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.binding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.php.internal.core.ast.binding.Attribute;
import org.eclipse.php.internal.core.ast.binding.ProgramScope;
import org.eclipse.php.internal.core.ast.binding.Scope;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;

public abstract class ScopeBase
implements Scope {
    public final int start;
    public int length;
    public final ProgramScope programScope;
    public final Map entryMap = new HashMap(1);

    public ScopeBase(int start, ProgramScope programScope) {
        assert (programScope != null);
        this.start = start;
        this.programScope = programScope;
    }

    public Attribute probe(String identifier) {
        assert (identifier != null);
        return (Attribute)this.entryMap.get(identifier);
    }

    public Attribute lookup(VariableBase varBase) {
        assert (varBase != null);
        return Attribute.NULL_ATTRIBUTE;
    }

    public void insertIdentifier(String id, Attribute attribute) {
        assert (id != null && attribute != null);
        if (this.entryMap.containsKey(id)) {
            throw new IllegalArgumentException();
        }
        this.entryMap.put(id, attribute);
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(buffer, "");
        return buffer.toString();
    }

    protected void appendInterval(StringBuffer buffer) {
        buffer.append(" start='").append(this.start).append("' length='").append(this.length).append("'");
    }

    public void toString(StringBuffer buffer, String tab) {
        Iterator iter = this.entryMap.entrySet().iterator();
        while (iter.hasNext()) {
            buffer.append("\n").append("\t").append(tab).append("<Entry");
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            Attribute attribute = (Attribute)entry.getValue();
            buffer.append(" key='").append(name).append("' value='").append(attribute.toString()).append("'");
            buffer.append("/>");
        }
    }
}

