/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.binding;

import org.eclipse.php.internal.core.ast.binding.ArrayAttribute;
import org.eclipse.php.internal.core.ast.binding.Attribute;
import org.eclipse.php.internal.core.ast.binding.AttributeType;
import org.eclipse.php.internal.core.ast.binding.ClassAttribute;
import org.eclipse.php.internal.core.ast.binding.CompositeAttribute;
import org.eclipse.php.internal.core.ast.binding.ScopeBase;
import org.eclipse.php.internal.core.ast.nodes.ASTError;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.ArrayCreation;
import org.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.BackTickExpression;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.BreakStatement;
import org.eclipse.php.internal.core.ast.nodes.CastExpression;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.ClassConstantDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.CloneExpression;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import org.eclipse.php.internal.core.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.ast.nodes.ContinueStatement;
import org.eclipse.php.internal.core.ast.nodes.DeclareStatement;
import org.eclipse.php.internal.core.ast.nodes.Dispatch;
import org.eclipse.php.internal.core.ast.nodes.DoStatement;
import org.eclipse.php.internal.core.ast.nodes.EchoStatement;
import org.eclipse.php.internal.core.ast.nodes.EmptyStatement;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.ast.nodes.IgnoreError;
import org.eclipse.php.internal.core.ast.nodes.InLineHtml;
import org.eclipse.php.internal.core.ast.nodes.Include;
import org.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.ast.nodes.InstanceOfExpression;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.PostfixExpression;
import org.eclipse.php.internal.core.ast.nodes.PrefixExpression;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Quote;
import org.eclipse.php.internal.core.ast.nodes.Reference;
import org.eclipse.php.internal.core.ast.nodes.ReflectionVariable;
import org.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.StaticStatement;
import org.eclipse.php.internal.core.ast.nodes.SwitchCase;
import org.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org.eclipse.php.internal.core.ast.nodes.ThrowStatement;
import org.eclipse.php.internal.core.ast.nodes.TryStatement;
import org.eclipse.php.internal.core.ast.nodes.UnaryOperation;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.ast.visitor.AbstractVisitor;

public class TypeResolver
extends AbstractVisitor {
    public Attribute evaluatedAttribute;
    private final ScopeBase scope;

    public static final Attribute resolve(ScopeBase scope, Expression expression) {
        TypeResolver typeResolver = new TypeResolver(scope);
        expression.accept(typeResolver);
        return typeResolver.evaluatedAttribute;
    }

    protected TypeResolver(ScopeBase scope) {
        this.scope = scope;
    }

    private void resolveFixOperations() {
        if (this.evaluatedAttribute == Attribute.NULL_ATTRIBUTE) {
            this.evaluatedAttribute = Attribute.INT_ATTRIBUTE;
        } else if (this.evaluatedAttribute == Attribute.STRING_ATTRIBUTE) {
            CompositeAttribute compositeAttribute = new CompositeAttribute();
            compositeAttribute.addAttribute(Attribute.STRING_ATTRIBUTE);
            compositeAttribute.addAttribute(Attribute.INT_ATTRIBUTE);
            this.evaluatedAttribute = compositeAttribute;
        }
    }

    private void throwException(ASTNode node) {
        throw new UnsupportedOperationException("cannot resolve: " + node.getStart() + ", type: " + node.getType());
    }

    public void visit(ArrayAccess indexedVariable) {
        this.scope.lookup(indexedVariable);
    }

    public void visit(ArrayCreation arrayExpressionon) {
        ArrayAttribute attribute = new ArrayAttribute();
        ArrayElement[] elements = arrayExpressionon.getElements();
        int i = 0;
        while (i < elements.length) {
            ArrayElement element = elements[i];
            element.getValue().accept(this);
            attribute.addAttribute(this.evaluatedAttribute);
            ++i;
        }
        this.evaluatedAttribute = attribute;
    }

    public void visit(ArrayElement arrayElement) {
        this.throwException(arrayElement);
    }

    public void visit(Assignment assignment) {
        assignment.getValue().accept(this);
    }

    public void visit(ASTError astError) {
        this.evaluatedAttribute = Attribute.NULL_ATTRIBUTE;
    }

    public void visit(BackTickExpression expression) {
    }

    public void visit(Block blockStatement) {
        this.throwException(blockStatement);
    }

    public void visit(BreakStatement breakStatement) {
        this.throwException(breakStatement);
    }

    public void visit(CastExpression castExpression) {
        castExpression.getExpr().accept(this);
    }

    public void visit(CatchClause catchStatement) {
        this.throwException(catchStatement);
    }

    public void visit(StaticConstantAccess classConstant) {
        this.evaluatedAttribute = this.scope.programScope.lookup(classConstant);
    }

    public void visit(ClassConstantDeclaration classConstantDeclaratio) {
        this.throwException(classConstantDeclaratio);
    }

    public void visit(ClassDeclaration classDeclaration) {
        this.throwException(classDeclaration);
    }

    public void visit(ClassInstanceCreation classInstanceCreation) {
        classInstanceCreation.getClassName().accept(this);
    }

    public void visit(ClassName className) {
        if (className.getClassName().getType() == 33) {
            Identifier id = (Identifier)className.getClassName();
            this.evaluatedAttribute = new ClassAttribute(id.getName());
        } else {
            this.evaluatedAttribute = Attribute.NULL_ATTRIBUTE;
        }
    }

    public void visit(CloneExpression cloneExpression) {
        cloneExpression.getExpr().accept(this);
    }

    public void visit(Comment comment) {
        this.throwException(comment);
    }

    public void visit(ConditionalExpression conditionalExpression) {
        conditionalExpression.getIfFalse().accept(this);
        Attribute falseExpression = this.evaluatedAttribute;
        conditionalExpression.getIfTrue().accept(this);
        Attribute trueExpression = this.evaluatedAttribute;
        if (!falseExpression.equals(trueExpression)) {
            CompositeAttribute compositeAttribute = new CompositeAttribute();
            compositeAttribute.addAttribute(falseExpression);
            compositeAttribute.addAttribute(trueExpression);
            this.evaluatedAttribute = compositeAttribute;
        }
    }

    public void visit(ContinueStatement continueStatement) {
        this.throwException(continueStatement);
    }

    public void visit(DeclareStatement declareStatement) {
        this.throwException(declareStatement);
    }

    public void visit(Dispatch dispatch) {
        this.evaluatedAttribute = this.scope.lookup(dispatch);
    }

    public void visit(DoStatement doStatement) {
        this.throwException(doStatement);
    }

    public void visit(EchoStatement echoStatement) {
        this.throwException(echoStatement);
    }

    public void visit(EmptyStatement emptyStatement) {
        this.throwException(emptyStatement);
    }

    public void visit(ExpressionStatement expressionStatement) {
        this.throwException(expressionStatement);
    }

    public void visit(FieldsDeclaration classVariableDeclaratio) {
        this.throwException(classVariableDeclaratio);
    }

    public void visit(ForEachStatement forEachStatement) {
        this.throwException(forEachStatement);
    }

    public void visit(FormalParameter formalParameter) {
        this.throwException(formalParameter);
    }

    public void visit(ForStatement forStatement) {
        this.throwException(forStatement);
    }

    public void visit(FunctionDeclaration functionDeclaration) {
        this.throwException(functionDeclaration);
    }

    public void visit(FunctionInvocation functionInvocation) {
        this.scope.lookup(functionInvocation);
    }

    public void visit(FunctionName functionName) {
        this.throwException(functionName);
    }

    public void visit(GlobalStatement globalStatement) {
        this.throwException(globalStatement);
    }

    public void visit(Identifier identifier) {
        this.scope.lookup(identifier.getName());
    }

    public void visit(IfStatement ifStatement) {
        this.throwException(ifStatement);
    }

    public void visit(IgnoreError ignoreError) {
        super.visit(ignoreError);
    }

    public void visit(Include include) {
        this.evaluatedAttribute = Attribute.NULL_ATTRIBUTE;
    }

    public void visit(InfixExpression infixExpression) {
        Attribute leftAttr = null;
        Attribute rightAttr = null;
        switch (infixExpression.getOperator()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.evaluatedAttribute = Attribute.BOOL_ATTRIBUTE;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                infixExpression.getLeft().accept(this);
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                infixExpression.getLeft().accept(this);
                leftAttr = this.evaluatedAttribute;
                if (leftAttr != Attribute.STRING_ATTRIBUTE) {
                    this.evaluatedAttribute = Attribute.INT_ATTRIBUTE;
                    break;
                }
                infixExpression.getRight().accept(this);
                rightAttr = this.evaluatedAttribute;
                if (rightAttr == Attribute.STRING_ATTRIBUTE) {
                    this.evaluatedAttribute = Attribute.STRING_ATTRIBUTE;
                    break;
                }
                this.evaluatedAttribute = Attribute.INT_ATTRIBUTE;
                break;
            }
            case 16: {
                this.evaluatedAttribute = Attribute.STRING_ATTRIBUTE;
                break;
            }
            case 17: 
            case 18: {
                infixExpression.getLeft().accept(this);
                leftAttr = this.evaluatedAttribute;
                infixExpression.getRight().accept(this);
                rightAttr = this.evaluatedAttribute;
                if (leftAttr.getType() == AttributeType.STRING_ATTRIBUTE || rightAttr.getType() == AttributeType.STRING_ATTRIBUTE) {
                    CompositeAttribute attr = new CompositeAttribute();
                    attr.addAttribute(Attribute.INT_ATTRIBUTE);
                    attr.addAttribute(Attribute.REAL_ATTRIBUTE);
                    this.evaluatedAttribute = attr;
                }
                if (leftAttr == Attribute.REAL_ATTRIBUTE || rightAttr == Attribute.REAL_ATTRIBUTE) {
                    this.evaluatedAttribute = Attribute.REAL_ATTRIBUTE;
                    break;
                }
                this.evaluatedAttribute = Attribute.INT_ATTRIBUTE;
                break;
            }
            case 19: 
            case 20: {
                infixExpression.getLeft().accept(this);
                leftAttr = this.evaluatedAttribute;
                infixExpression.getRight().accept(this);
                rightAttr = this.evaluatedAttribute;
                if (leftAttr.getType() == AttributeType.ARRAY_ATTRIBUTE || leftAttr.getType() == AttributeType.CLASS_ATTRIBUTE || rightAttr.getType() == AttributeType.STRING_ATTRIBUTE || rightAttr.getType() == AttributeType.CLASS_ATTRIBUTE) {
                    this.evaluatedAttribute = Attribute.BOOL_ATTRIBUTE;
                }
                CompositeAttribute attr = new CompositeAttribute();
                attr.addAttribute(Attribute.INT_ATTRIBUTE);
                attr.addAttribute(Attribute.REAL_ATTRIBUTE);
                this.evaluatedAttribute = attr;
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                this.evaluatedAttribute = Attribute.INT_ATTRIBUTE;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void visit(InLineHtml inLineHtml) {
        this.throwException(inLineHtml);
    }

    public void visit(InstanceOfExpression instanceOfExpression) {
        this.evaluatedAttribute = Attribute.BOOL_ATTRIBUTE;
    }

    public void visit(InterfaceDeclaration interfaceDeclaration) {
        this.throwException(interfaceDeclaration);
    }

    public void visit(ListVariable listVariable) {
        this.scope.lookup(listVariable);
    }

    public void visit(MethodDeclaration classMethodDeclaration) {
        this.throwException(classMethodDeclaration);
    }

    public void visit(PostfixExpression postfixExpressions) {
        super.visit(postfixExpressions);
        this.resolveFixOperations();
    }

    public void visit(PrefixExpression prefixExpression) {
        super.visit(prefixExpression);
        this.resolveFixOperations();
    }

    public void visit(Program program) {
        this.throwException(program);
    }

    public void visit(Quote quote) {
        this.evaluatedAttribute = Attribute.STRING_ATTRIBUTE;
    }

    public void visit(Reference reference) {
        reference.getExpression().accept(this);
    }

    public void visit(ReflectionVariable reflectionVariable) {
        this.scope.lookup(reflectionVariable);
    }

    public void visit(ReturnStatement returnStatement) {
        this.throwException(returnStatement);
    }

    public void visit(Scalar scalar) {
        switch (scalar.getScalarType()) {
            case 0: {
                this.evaluatedAttribute = Attribute.INT_ATTRIBUTE;
                break;
            }
            case 1: {
                this.evaluatedAttribute = Attribute.REAL_ATTRIBUTE;
                break;
            }
            case 2: {
                if ("true".equals(scalar.getStringValue()) || "false".equals(scalar.getStringValue())) {
                    this.evaluatedAttribute = Attribute.BOOL_ATTRIBUTE;
                    break;
                }
                this.evaluatedAttribute = Attribute.STRING_ATTRIBUTE;
                break;
            }
            case 4: {
                if ("__LINE__".endsWith(scalar.getStringValue())) {
                    this.evaluatedAttribute = Attribute.INT_ATTRIBUTE;
                    break;
                }
                this.evaluatedAttribute = Attribute.STRING_ATTRIBUTE;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void visit(StaticFieldAccess staticMember) {
        this.scope.lookup(staticMember);
    }

    public void visit(StaticMethodInvocation staticMethodInvocation) {
    }

    public void visit(StaticStatement staticStatement) {
        this.throwException(staticStatement);
    }

    public void visit(SwitchCase caseStatement) {
        this.throwException(caseStatement);
    }

    public void visit(SwitchStatement switchStatement) {
        this.throwException(switchStatement);
    }

    public void visit(ThrowStatement throwStatement) {
        this.throwException(throwStatement);
    }

    public void visit(TryStatement tryStatement) {
        this.throwException(tryStatement);
    }

    public void visit(UnaryOperation unaryOperation) {
        super.visit(unaryOperation);
        switch (unaryOperation.getOperator()) {
            case 0: 
            case 1: {
                if (this.evaluatedAttribute == Attribute.REAL_ATTRIBUTE) break;
                this.evaluatedAttribute = Attribute.INT_ATTRIBUTE;
                break;
            }
            case 2: {
                this.evaluatedAttribute = Attribute.BOOL_ATTRIBUTE;
                break;
            }
            case 3: {
                if (this.evaluatedAttribute == Attribute.REAL_ATTRIBUTE || this.evaluatedAttribute == Attribute.INT_ATTRIBUTE || this.evaluatedAttribute == Attribute.STRING_ATTRIBUTE) break;
                this.evaluatedAttribute = Attribute.NULL_ATTRIBUTE;
                break;
            }
            default: {
                this.throwException(unaryOperation);
            }
        }
    }

    public void visit(Variable variable) {
        this.scope.lookup(variable);
    }

    public void visit(WhileStatement whileStatement) {
        this.throwException(whileStatement);
    }
}

