/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ArrayElement
extends ASTNode {
    private final Expression key;
    private final Expression value;

    public ArrayElement(int start, int end, Expression key, Expression value) {
        super(start, end);
        assert (value != null);
        this.key = key;
        this.value = value;
        if (key != null) {
            key.setParent(this);
        }
        value.setParent(this);
    }

    public ArrayElement(int start, int end, Expression value) {
        this(start, end, null, value);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        if (this.key != null) {
            this.key.accept(visitor);
        }
        this.value.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        if (this.key != null) {
            this.key.traverseTopDown(visitor);
        }
        this.value.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        if (this.key != null) {
            this.key.traverseBottomUp(visitor);
        }
        this.value.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ArrayElement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Key>\n");
        if (this.key != null) {
            this.key.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Key>\n");
        buffer.append("\t").append(tab).append("<Value>\n");
        this.value.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Value>\n");
        buffer.append(tab).append("</ArrayElement>");
    }

    public int getType() {
        return 2;
    }

    public Expression getKey() {
        return this.key;
    }

    public Expression getValue() {
        return this.value;
    }
}

