/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class DeclareStatement
extends Statement {
    private final Identifier[] directiveNames;
    private final Expression[] directiveValues;
    private final Statement action;

    private DeclareStatement(int start, int end, Identifier[] directiveNames, Expression[] directiveValues, Statement action) {
        super(start, end);
        assert (directiveNames != null && directiveValues != null && directiveNames.length == directiveValues.length);
        this.directiveNames = directiveNames;
        this.directiveValues = directiveValues;
        this.action = action;
        int i = 0;
        while (i < directiveNames.length) {
            directiveNames[i].setParent(this);
            directiveValues[i].setParent(this);
            ++i;
        }
        action.setParent(this);
    }

    public DeclareStatement(int start, int end, List directiveNames, List directiveValues, Statement action) {
        this(start, end, directiveNames == null ? null : directiveNames.toArray(new Identifier[directiveNames.size()]), directiveValues == null ? null : directiveValues.toArray(new Expression[directiveValues.size()]), action);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int i = 0;
        while (i < this.directiveNames.length) {
            this.directiveNames[i].accept(visitor);
            this.directiveValues[i].accept(visitor);
            ++i;
        }
        this.action.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int i = 0;
        while (i < this.directiveNames.length) {
            this.directiveNames[i].traverseTopDown(visitor);
            this.directiveValues[i].traverseTopDown(visitor);
            ++i;
        }
        this.action.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        int i = 0;
        while (i < this.directiveNames.length) {
            this.directiveNames[i].traverseBottomUp(visitor);
            this.directiveValues[i].traverseBottomUp(visitor);
            ++i;
        }
        this.action.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<DeclareStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append(tab).append("\t").append("<Directives>\n");
        int i = 0;
        while (i < this.directiveNames.length) {
            buffer.append(tab).append("\t").append("\t").append("<Name>\n");
            this.directiveNames[i].toString(buffer, "\t\t\t" + tab);
            buffer.append("\n");
            buffer.append(tab).append("\t").append("\t").append("</Name>\n");
            buffer.append(tab).append("\t").append("\t").append("<Value>\n");
            this.directiveValues[i].toString(buffer, "\t\t\t" + tab);
            buffer.append("\n");
            buffer.append(tab).append("\t").append("\t").append("</Value>\n");
            ++i;
        }
        buffer.append(tab).append("\t").append("</Directives>\n");
        this.action.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</DeclareStatement>");
    }

    public int getType() {
        return 19;
    }

    public Statement getAction() {
        return this.action;
    }

    public Identifier[] getDirectiveNames() {
        return this.directiveNames;
    }

    public Expression[] getDirectiveValues() {
        return this.directiveValues;
    }
}

