/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class GlobalStatement
extends Statement {
    private final Variable[] variables;

    private GlobalStatement(int start, int end, Variable[] variables) {
        super(start, end);
        assert (variables != null);
        this.variables = variables;
        int i = 0;
        while (i < variables.length) {
            variables[i].setParent(this);
            ++i;
        }
    }

    public GlobalStatement(int start, int end, List variables) {
        this(start, end, variables == null ? null : variables.toArray(new Variable[variables.size()]));
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int i = 0;
        while (i < this.variables.length) {
            this.variables[i].accept(visitor);
            ++i;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int i = 0;
        while (i < this.variables.length) {
            this.variables[i].traverseTopDown(visitor);
            ++i;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        int i = 0;
        while (i < this.variables.length) {
            this.variables[i].traverseBottomUp(visitor);
            ++i;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<GlobalStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        int i = 0;
        while (i < this.variables.length) {
            this.variables[i].toString(buffer, "\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append(tab).append("</GlobalStatement>");
    }

    public int getType() {
        return 32;
    }

    public Variable[] getVariables() {
        return this.variables;
    }
}

