/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class IfStatement
extends Statement {
    private final Expression condition;
    private final Statement trueStatement;
    private final Statement falseStatement;

    public IfStatement(int start, int end, Expression condition, Statement trueStatement, Statement falseStatement) {
        super(start, end);
        assert (condition != null && trueStatement != null);
        this.condition = condition;
        this.trueStatement = trueStatement;
        this.falseStatement = falseStatement;
        condition.setParent(this);
        trueStatement.setParent(this);
        if (falseStatement != null) {
            falseStatement.setParent(this);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.condition.accept(visitor);
        this.trueStatement.accept(visitor);
        if (this.falseStatement != null) {
            this.falseStatement.accept(visitor);
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.condition.traverseTopDown(visitor);
        this.trueStatement.traverseTopDown(visitor);
        if (this.falseStatement != null) {
            this.falseStatement.traverseTopDown(visitor);
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        this.condition.traverseBottomUp(visitor);
        this.trueStatement.traverseBottomUp(visitor);
        if (this.falseStatement != null) {
            this.falseStatement.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<IfStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Condition>\n");
        this.condition.toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("</Condition>\n");
        buffer.append("\t").append(tab).append("<TrueStatement>\n");
        this.trueStatement.toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("</TrueStatement>\n");
        buffer.append("\t").append(tab).append("<FalseStatement>\n");
        if (this.falseStatement != null) {
            this.falseStatement.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</FalseStatement>\n");
        buffer.append(tab).append("</IfStatement>");
    }

    public int getType() {
        return 34;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Statement getFalseStatement() {
        return this.falseStatement;
    }

    public Statement getTrueStatement() {
        return this.trueStatement;
    }
}

