/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class Scalar
extends Expression {
    public static final int TYPE_INT = 0;
    public static final int TYPE_REAL = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_UNKNOWN = 3;
    public static final int TYPE_SYSTEM = 4;
    private final String stringValue;
    private final int scalarType;

    public Scalar(int start, int end, String value, int type) {
        super(start, end);
        this.stringValue = value;
        this.scalarType = type;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
    }

    public void traverseBottomUp(Visitor visitor) {
    }

    public void traverseTopDown(Visitor visitor) {
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<Scalar");
        this.appendInterval(buffer);
        buffer.append(" type='").append(Scalar.getType(this.scalarType)).append("'");
        if (this.stringValue != null) {
            buffer.append(" value='").append(Scalar.getXmlStringValue(this.stringValue)).append("'");
        }
        buffer.append("/>");
    }

    public static String getType(int type) {
        switch (type) {
            case 0: {
                return "int";
            }
            case 1: {
                return "real";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "unknown";
            }
            case 4: {
                return "system";
            }
        }
        throw new IllegalArgumentException();
    }

    public int getType() {
        return 51;
    }

    public int getScalarType() {
        return this.scalarType;
    }

    public String getStringValue() {
        return this.stringValue;
    }
}

