/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.StaticDispatch;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class StaticConstantAccess
extends StaticDispatch {
    private final Identifier constant;

    public StaticConstantAccess(int start, int end, Identifier className, Identifier constant) {
        super(start, end, className);
        assert (constant != null);
        this.constant = constant;
        constant.setParent(this);
    }

    public StaticConstantAccess(int start, int end, Identifier name) {
        this(start, end, null, name);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.getClassName().accept(visitor);
        this.constant.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getClassName().traverseTopDown(visitor);
        this.constant.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.getClassName().traverseTopDown(visitor);
        this.constant.traverseTopDown(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<StaticConstantAccess");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<ClassName>\n");
        this.getClassName().toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</ClassName>\n");
        buffer.append("\t").append(tab).append("<Constant>\n");
        this.constant.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Constant>\n");
        buffer.append(tab).append("</StaticConstantAccess>");
    }

    public int getType() {
        return 10;
    }

    public Identifier getConstant() {
        return this.constant;
    }

    public ASTNode getMember() {
        return this.getConstant();
    }
}

