/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.StaticDispatch;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class StaticMethodInvocation
extends StaticDispatch {
    private final FunctionInvocation method;

    public StaticMethodInvocation(int start, int end, Identifier className, FunctionInvocation method) {
        super(start, end, className);
        assert (method != null);
        this.method = method;
        method.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.getClassName().accept(visitor);
        this.method.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getClassName().traverseTopDown(visitor);
        this.method.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.getClassName().traverseBottomUp(visitor);
        this.method.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<StaticMethodInvocation");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<ClassName>\n");
        this.getClassName().toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</ClassName>\n");
        this.method.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</StaticMethodInvocation>");
    }

    public int getType() {
        return 53;
    }

    public FunctionInvocation getMethod() {
        return this.method;
    }

    public ASTNode getMember() {
        return this.getMethod();
    }
}

