/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class StaticStatement
extends Statement {
    private final Expression[] expressions;

    private StaticStatement(int start, int end, Expression[] expressions) {
        super(start, end);
        assert (expressions != null);
        this.expressions = expressions;
        int i = 0;
        while (i < expressions.length) {
            expressions[i].setParent(this);
            ++i;
        }
    }

    public StaticStatement(int start, int end, List expressions) {
        this(start, end, expressions == null ? null : expressions.toArray(new Expression[expressions.size()]));
    }

    public Variable[] getVariables() {
        LinkedList<Expression> vars = new LinkedList<Expression>();
        int i = 0;
        while (i < this.expressions.length) {
            if (this.expressions[i] instanceof Variable) {
                vars.add(this.expressions[i]);
            } else {
                assert (this.expressions[i] instanceof Assignment);
                vars.add(((Assignment)this.expressions[i]).getVariable());
            }
            ++i;
        }
        return vars.toArray(new Variable[vars.size()]);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i].accept(visitor);
            ++i;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i].traverseTopDown(visitor);
            ++i;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i].traverseBottomUp(visitor);
            ++i;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<StaticStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i].toString(buffer, "\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append(tab).append("</StaticStatement>");
    }

    public int getType() {
        return 54;
    }

    public Expression[] getExpressions() {
        return this.expressions;
    }
}

