/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class SwitchCase
extends Statement {
    private final Expression value;
    private final Statement[] actions;
    private final boolean isDefault;

    public SwitchCase(int start, int end, Expression value, Statement[] actions2, boolean isDefault) {
        super(start, end);
        assert (actions2 != null);
        this.value = value;
        this.actions = actions2;
        this.isDefault = isDefault;
        if (value != null) {
            value.setParent(this);
        }
        int i = 0;
        while (i < actions2.length) {
            actions2[i].setParent(this);
            ++i;
        }
    }

    public SwitchCase(int start, int end, Expression value, List actions2, boolean isDefault) {
        this(start, end, value, actions2 == null ? null : actions2.toArray(new Statement[actions2.size()]), isDefault);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        if (this.value != null) {
            this.value.accept(visitor);
        }
        int i = 0;
        while (i < this.actions.length) {
            this.actions[i].accept(visitor);
            ++i;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        if (this.value != null) {
            this.value.traverseTopDown(visitor);
        }
        int i = 0;
        while (i < this.actions.length) {
            this.actions[i].traverseTopDown(visitor);
            ++i;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        if (this.value != null) {
            this.value.traverseBottomUp(visitor);
        }
        int i = 0;
        while (i < this.actions.length) {
            this.actions[i].traverseBottomUp(visitor);
            ++i;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<SwitchCase");
        this.appendInterval(buffer);
        buffer.append(" isDefault='").append(this.isDefault).append("'>\n");
        buffer.append("\t").append(tab).append("<Value>\n");
        if (this.value != null) {
            this.value.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Value>\n");
        int i = 0;
        while (i < this.actions.length) {
            this.actions[i].toString(buffer, "\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append(tab).append("</SwitchCase>");
    }

    public int getType() {
        return 55;
    }

    public Statement[] getActions() {
        return this.actions;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Expression getValue() {
        return this.value;
    }
}

