/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class SwitchStatement
extends Statement {
    private final Expression expr;
    private final Block statement;

    public SwitchStatement(int start, int end, Expression expr, Block statement) {
        super(start, end);
        assert (expr != null && statement != null);
        this.expr = expr;
        this.statement = statement;
        expr.setParent(this);
        statement.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.expr.accept(visitor);
        this.statement.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.expr.traverseTopDown(visitor);
        this.statement.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.expr.traverseBottomUp(visitor);
        this.statement.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<SwitchStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Expression>\n");
        this.expr.toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("</Expression>\n");
        this.statement.toString(buffer, "\t" + tab);
        buffer.append("\n").append(tab).append("</SwitchStatement>");
    }

    public int getType() {
        return 56;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public Block getStatement() {
        return this.statement;
    }
}

