/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.visitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.eclipse.php.internal.core.ast.nodes.ASTError;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.ArrayCreation;
import org.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.BackTickExpression;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.BreakStatement;
import org.eclipse.php.internal.core.ast.nodes.CastExpression;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.ClassConstantDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.CloneExpression;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import org.eclipse.php.internal.core.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.ast.nodes.ContinueStatement;
import org.eclipse.php.internal.core.ast.nodes.DeclareStatement;
import org.eclipse.php.internal.core.ast.nodes.DoStatement;
import org.eclipse.php.internal.core.ast.nodes.EchoStatement;
import org.eclipse.php.internal.core.ast.nodes.EmptyStatement;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.ast.nodes.IgnoreError;
import org.eclipse.php.internal.core.ast.nodes.InLineHtml;
import org.eclipse.php.internal.core.ast.nodes.Include;
import org.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.ast.nodes.InstanceOfExpression;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org.eclipse.php.internal.core.ast.nodes.PostfixExpression;
import org.eclipse.php.internal.core.ast.nodes.PrefixExpression;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Quote;
import org.eclipse.php.internal.core.ast.nodes.Reference;
import org.eclipse.php.internal.core.ast.nodes.ReflectionVariable;
import org.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.StaticStatement;
import org.eclipse.php.internal.core.ast.nodes.SwitchCase;
import org.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org.eclipse.php.internal.core.ast.nodes.ThrowStatement;
import org.eclipse.php.internal.core.ast.nodes.TryStatement;
import org.eclipse.php.internal.core.ast.nodes.UnaryOperation;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class CodeBuilder
implements Visitor {
    public StringBuffer buffer = new StringBuffer();
    private String str;

    public void printOutputfile(String filename) throws IOException {
        FileWriter outFile = new FileWriter(filename, false);
        outFile.write(this.buffer.toString());
        ((Writer)outFile).close();
    }

    public static String readFile(String filename) throws FileNotFoundException, IOException {
        StringBuffer inputBuffer = new StringBuffer();
        FileInputStream fileInputStream = new FileInputStream(new File(filename));
        int read = fileInputStream.read();
        while (read != -1) {
            inputBuffer.append((char)read);
            read = fileInputStream.read();
        }
        fileInputStream.close();
        return inputBuffer.toString();
    }

    private void acceptQuoteExpression(Expression[] expressions) {
        int i = 0;
        while (i < expressions.length) {
            expressions[i].accept(this);
            ++i;
        }
    }

    public void visit(ArrayAccess arrayAccess) {
        arrayAccess.getVariableName().accept(this);
        if (arrayAccess.getIndex() != null) {
            if (arrayAccess.getArrayType() == 1) {
                this.buffer.append("[");
                arrayAccess.getIndex().accept(this);
                this.buffer.append("]");
            } else if (arrayAccess.getArrayType() == 2) {
                this.buffer.append("{");
                arrayAccess.getIndex().accept(this);
                this.buffer.append("}");
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void visit(ArrayCreation arrayCreation) {
        this.buffer.append("array(");
        ArrayElement[] elements = arrayCreation.getElements();
        int i = 0;
        while (i < elements.length) {
            elements[i].accept(this);
            this.buffer.append(",");
            ++i;
        }
        this.buffer.append(")");
    }

    public void visit(ArrayElement arrayElement) {
        if (arrayElement.getKey() != null) {
            arrayElement.getKey().accept(this);
            this.buffer.append("=>");
        }
        arrayElement.getValue().accept(this);
    }

    public void visit(Assignment assignment) {
        assignment.getVariable().accept(this);
        this.buffer.append(Assignment.getOperator(assignment.getOperator()));
        assignment.getValue().accept(this);
    }

    public void visit(ASTError astError) {
        this.buffer.append(this.str.substring(astError.getStart(), astError.getEnd()));
    }

    public void visit(BackTickExpression backTickExpression) {
        this.buffer.append("`");
        Expression[] expressions = backTickExpression.getExpressions();
        int i = 0;
        while (i < expressions.length) {
            expressions[i].accept(this);
            ++i;
        }
        this.buffer.append("`");
    }

    public void visit(Block block) {
        if (block.isCurly()) {
            this.buffer.append("{\n");
        } else {
            this.buffer.append(":\n");
        }
        Statement[] statements = block.getStatements();
        int i = 0;
        while (i < statements.length) {
            statements[i].accept(this);
            ++i;
        }
        if (block.isCurly()) {
            this.buffer.append("\n}\n");
        } else {
            this.buffer.append("end;\n");
        }
    }

    public void visit(BreakStatement breakStatement) {
        this.buffer.append("break ");
        if (breakStatement.getExpr() != null) {
            breakStatement.getExpr().accept(this);
        }
        this.buffer.append(";\n");
    }

    public void visit(CastExpression castExpression) {
        this.buffer.append("(");
        this.buffer.append(CastExpression.getCastType(castExpression.getCastType()));
        this.buffer.append(")");
        castExpression.getExpr().accept(this);
    }

    public void visit(CatchClause catchClause) {
        this.buffer.append("catch (");
        catchClause.getClassName().accept(this);
        this.buffer.append(" ");
        catchClause.getVariable().accept(this);
        this.buffer.append(") ");
        catchClause.getStatement().accept(this);
    }

    public void visit(ClassConstantDeclaration classConstantDeclaration) {
        this.buffer.append("const ");
        boolean isFirst = true;
        Identifier[] variableNames = classConstantDeclaration.getVariableNames();
        Expression[] constantValues = classConstantDeclaration.getConstantValues();
        int i = 0;
        while (i < variableNames.length) {
            if (!isFirst) {
                this.buffer.append(",");
            }
            variableNames[i].accept(this);
            this.buffer.append(" = ");
            constantValues[i].accept(this);
            isFirst = false;
            ++i;
        }
        this.buffer.append(";\n");
    }

    public void visit(ClassDeclaration classDeclaration) {
        Identifier[] interfaces;
        this.buffer.append("class ");
        classDeclaration.getName().accept(this);
        if (classDeclaration.getSuperClass() != null) {
            this.buffer.append(" extends ");
            classDeclaration.getSuperClass().accept(this);
        }
        if ((interfaces = classDeclaration.getInterfaces()) != null && interfaces.length != 0) {
            this.buffer.append(" implements ");
            interfaces[0].accept(this);
            int i = 1;
            while (i < interfaces.length) {
                this.buffer.append(" , ");
                interfaces[i].accept(this);
                ++i;
            }
        }
        classDeclaration.getBody().accept(this);
    }

    public void visit(ClassInstanceCreation classInstanceCreation) {
        this.buffer.append("new ");
        classInstanceCreation.getClassName().accept(this);
        Expression[] ctorParams = classInstanceCreation.getCtorParams();
        if (ctorParams.length != 0) {
            this.buffer.append("(");
            ctorParams[0].accept(this);
            int i = 1;
            while (i < ctorParams.length) {
                this.buffer.append(",");
                ctorParams[i].accept(this);
                ++i;
            }
            this.buffer.append(")");
        }
    }

    public void visit(ClassName className) {
        className.getClassName().accept(this);
    }

    public void visit(CloneExpression cloneExpression) {
        this.buffer.append("clone ");
        cloneExpression.getExpr().accept(this);
    }

    public void visit(Comment comment) {
        this.buffer.append(this.str.substring(comment.getStart(), comment.getEnd()));
    }

    public void visit(ConditionalExpression conditionalExpression) {
        conditionalExpression.getCondition().accept(this);
        this.buffer.append(" ? ");
        conditionalExpression.getIfTrue().accept(this);
        this.buffer.append(" : ");
        conditionalExpression.getIfFalse().accept(this);
    }

    public void visit(ContinueStatement continueStatement) {
        this.buffer.append("continue ");
        if (continueStatement.getExpr() != null) {
            continueStatement.getExpr().accept(this);
        }
        this.buffer.append(";\n");
    }

    public void visit(DeclareStatement declareStatement) {
        this.buffer.append("declare (");
        boolean isFirst = true;
        Identifier[] directiveNames = declareStatement.getDirectiveNames();
        Expression[] directiveValues = declareStatement.getDirectiveValues();
        int i = 0;
        while (i < directiveNames.length) {
            if (!isFirst) {
                this.buffer.append(",");
            }
            directiveNames[i].accept(this);
            this.buffer.append(" = ");
            directiveValues[i].accept(this);
            isFirst = false;
            ++i;
        }
        this.buffer.append(")");
        declareStatement.getAction().accept(this);
    }

    public void visit(DoStatement doStatement) {
        this.buffer.append("do ");
        doStatement.getAction().accept(this);
        this.buffer.append("while (");
        doStatement.getCondition().accept(this);
        this.buffer.append(");\n");
    }

    public void visit(EchoStatement echoStatement) {
        this.buffer.append("echo ");
        Expression[] expressions = echoStatement.getExpressions();
        int i = 0;
        while (i < expressions.length) {
            expressions[i].accept(this);
            ++i;
        }
        this.buffer.append(";\n ");
    }

    public void visit(EmptyStatement emptyStatement) {
        this.buffer.append(";\n");
    }

    public void visit(ExpressionStatement expressionStatement) {
        expressionStatement.getExpr().accept(this);
        this.buffer.append(";\n");
    }

    public void visit(FieldAccess fieldAccess) {
        fieldAccess.getDispatcher().accept(this);
        this.buffer.append("->");
        fieldAccess.getField().accept(this);
    }

    public void visit(FieldsDeclaration fieldsDeclaration) {
        Variable[] variableNames = fieldsDeclaration.getVariableNames();
        Expression[] initialValues = fieldsDeclaration.getInitialValues();
        int i = 0;
        while (i < variableNames.length) {
            this.buffer.append(String.valueOf(fieldsDeclaration.getModifierString()) + " ");
            variableNames[i].accept(this);
            if (initialValues[i] != null) {
                this.buffer.append(" = ");
                initialValues[i].accept(this);
            }
            this.buffer.append(";\n");
            ++i;
        }
    }

    public void visit(ForEachStatement forEachStatement) {
        this.buffer.append("foreach (");
        forEachStatement.getExpression().accept(this);
        this.buffer.append(" as ");
        if (forEachStatement.getKey() != null) {
            forEachStatement.getKey().accept(this);
            this.buffer.append(" => ");
        }
        forEachStatement.getValue().accept(this);
        this.buffer.append(")");
        forEachStatement.getStatement().accept(this);
    }

    public void visit(FormalParameter formalParameter) {
        if (formalParameter.getParameterType() != null) {
            formalParameter.getParameterType().accept(this);
        }
        formalParameter.getParameterName().accept(this);
        if (formalParameter.getDefaultValue() != null) {
            formalParameter.getDefaultValue().accept(this);
        }
    }

    public void visit(ForStatement forStatement) {
        boolean isFirst = true;
        this.buffer.append("for (");
        Expression[] initializations = forStatement.getInitializations();
        Expression[] conditions = forStatement.getConditions();
        Expression[] increasements = forStatement.getIncreasements();
        int i = 0;
        while (i < initializations.length) {
            if (!isFirst) {
                this.buffer.append(",");
            }
            initializations[i].accept(this);
            isFirst = false;
            ++i;
        }
        isFirst = true;
        this.buffer.append(" ; ");
        i = 0;
        while (i < conditions.length) {
            if (!isFirst) {
                this.buffer.append(",");
            }
            conditions[i].accept(this);
            isFirst = false;
            ++i;
        }
        isFirst = true;
        this.buffer.append(" ; ");
        i = 0;
        while (i < increasements.length) {
            if (!isFirst) {
                this.buffer.append(",");
            }
            increasements[i].accept(this);
            isFirst = false;
            ++i;
        }
        this.buffer.append(" ) ");
        forStatement.getAction().accept(this);
    }

    public void visit(FunctionDeclaration functionDeclaration) {
        this.buffer.append(" function ");
        functionDeclaration.getFunctionName().accept(this);
        this.buffer.append("(");
        FormalParameter[] formalParameters = functionDeclaration.getFormalParameters();
        if (formalParameters.length != 0) {
            formalParameters[0].accept(this);
            int i = 1;
            while (i < formalParameters.length) {
                this.buffer.append(",");
                formalParameters[i].accept(this);
                ++i;
            }
        }
        this.buffer.append(")");
        if (functionDeclaration.getBody() != null) {
            functionDeclaration.getBody().accept(this);
        }
    }

    public void visit(FunctionInvocation functionInvocation) {
        functionInvocation.getFunctionName().accept(this);
        this.buffer.append("(");
        Expression[] parameters = functionInvocation.getParameters();
        if (parameters.length != 0) {
            parameters[0].accept(this);
            int i = 1;
            while (i < parameters.length) {
                this.buffer.append(",");
                parameters[i].accept(this);
                ++i;
            }
        }
        this.buffer.append(")");
    }

    public void visit(FunctionName functionName) {
        functionName.getFunctionName().accept(this);
    }

    public void visit(GlobalStatement globalStatement) {
        this.buffer.append("global ");
        boolean isFirst = true;
        Variable[] variables = globalStatement.getVariables();
        int i = 0;
        while (i < variables.length) {
            if (!isFirst) {
                this.buffer.append(", ");
            }
            variables[i].accept(this);
            isFirst = false;
            ++i;
        }
        this.buffer.append(";\n ");
    }

    public void visit(Identifier identifier) {
        this.buffer.append(identifier.getName());
    }

    public void visit(IfStatement ifStatement) {
        this.buffer.append("if(");
        ifStatement.getCondition().accept(this);
        this.buffer.append(")");
        ifStatement.getTrueStatement().accept(this);
        if (ifStatement.getFalseStatement() != null) {
            this.buffer.append("else");
            ifStatement.getFalseStatement().accept(this);
        }
    }

    public void visit(IgnoreError ignoreError) {
        this.buffer.append("@");
        ignoreError.getExpr().accept(this);
    }

    public void visit(Include include) {
        this.buffer.append(Include.getType(include.getIncludeType()));
        this.buffer.append(" (");
        include.getExpr().accept(this);
        this.buffer.append(")");
    }

    public void visit(InfixExpression infixExpression) {
        infixExpression.getLeft().accept(this);
        this.buffer.append(InfixExpression.getOperator(infixExpression.getOperator()));
        infixExpression.getRight().accept(this);
    }

    public void visit(InLineHtml inLineHtml) {
        this.buffer.append(this.str.substring(inLineHtml.getStart(), inLineHtml.getEnd()));
    }

    public void visit(InstanceOfExpression instanceOfExpression) {
        instanceOfExpression.getExpr().accept(this);
        this.buffer.append(" instanceof ");
        instanceOfExpression.getClassName().accept(this);
    }

    public void visit(InterfaceDeclaration interfaceDeclaration) {
        this.buffer.append("interface ");
        interfaceDeclaration.getName().accept(this);
        this.buffer.append(" extends ");
        boolean isFirst = true;
        Identifier[] interfaces = interfaceDeclaration.getInterfaces();
        int i = 0;
        while (interfaces != null && i < interfaces.length) {
            if (!isFirst) {
                this.buffer.append(", ");
            }
            interfaces[i].accept(this);
            isFirst = false;
            ++i;
        }
        interfaceDeclaration.getBody().accept(this);
    }

    public void visit(ListVariable listVariable) {
        this.buffer.append("list(");
        boolean isFirst = true;
        VariableBase[] variables = listVariable.getVariables();
        int i = 0;
        while (i < variables.length) {
            if (!isFirst) {
                this.buffer.append(", ");
            }
            variables[i].accept(this);
            isFirst = false;
            ++i;
        }
        this.buffer.append(")");
    }

    public void visit(MethodDeclaration methodDeclaration) {
        this.buffer.append(methodDeclaration.getModifierString());
        methodDeclaration.getFunction().accept(this);
    }

    public void visit(MethodInvocation methodInvocation) {
        methodInvocation.getDispatcher().accept(this);
        this.buffer.append("->");
        methodInvocation.getMethod().accept(this);
    }

    public void visit(ParenthesisExpression parenthesisExpression) {
        this.buffer.append("(");
        if (parenthesisExpression.getExpr() != null) {
            parenthesisExpression.getExpr().accept(this);
        }
        this.buffer.append(")");
    }

    public void visit(PostfixExpression postfixExpressions) {
        postfixExpressions.getVariable().accept(this);
        this.buffer.append(PostfixExpression.getOperator(postfixExpressions.getOperator()));
    }

    public void visit(PrefixExpression prefixExpression) {
        prefixExpression.getVariable().accept(this);
        this.buffer.append(PrefixExpression.getOperator(prefixExpression.getOperator()));
    }

    public void visit(Program program) {
        boolean isPhpState = false;
        Statement[] statements = program.getStatements();
        int i = 0;
        while (i < statements.length) {
            boolean isHtml = statements[i] instanceof InLineHtml;
            if (!isHtml && !isPhpState) {
                this.buffer.append("<?php\n");
                statements[i].accept(this);
                isPhpState = true;
            } else if (!isHtml && isPhpState) {
                statements[i].accept(this);
                this.buffer.append("\n");
            } else if (isHtml && isPhpState) {
                this.buffer.append("?>\n");
                statements[i].accept(this);
                this.buffer.append("\n");
                isPhpState = false;
            } else {
                statements[i].accept(this);
                this.buffer.append("\n");
            }
            ++i;
        }
        if (isPhpState) {
            this.buffer.append("?>\n");
        }
        Collection comments = program.getComments();
        for (Comment comment : comments) {
            comment.accept(this);
        }
    }

    public void visit(Quote quote) {
        switch (quote.getQuoteType()) {
            case 0: {
                this.buffer.append("\"");
                this.acceptQuoteExpression(quote.getExpressions());
                this.buffer.append("\"");
                break;
            }
            case 1: {
                this.buffer.append("'");
                this.acceptQuoteExpression(quote.getExpressions());
                this.buffer.append("'");
                break;
            }
            case 2: {
                this.buffer.append("<<<Heredoc\n");
                this.acceptQuoteExpression(quote.getExpressions());
                this.buffer.append("\nHeredoc");
            }
        }
    }

    public void visit(Reference reference) {
        this.buffer.append("&");
        reference.getExpression().accept(this);
    }

    public void visit(ReflectionVariable reflectionVariable) {
        this.buffer.append("$");
        reflectionVariable.getVariableName().accept(this);
    }

    public void visit(ReturnStatement returnStatement) {
        this.buffer.append("return ");
        if (returnStatement.getExpr() != null) {
            returnStatement.getExpr().accept(this);
        }
        this.buffer.append(";\n");
    }

    public void visit(Scalar scalar) {
        if (scalar.getScalarType() == 3) {
            this.buffer.append(this.str.substring(scalar.getStart(), scalar.getEnd()));
        } else {
            this.buffer.append(scalar.getStringValue());
        }
    }

    public void visit(StaticConstantAccess staticFieldAccess) {
        staticFieldAccess.getClassName().accept(this);
        this.buffer.append("::");
        staticFieldAccess.getConstant().accept(this);
    }

    public void visit(StaticFieldAccess staticFieldAccess) {
        staticFieldAccess.getClassName().accept(this);
        this.buffer.append("::");
        staticFieldAccess.getField().accept(this);
    }

    public void visit(StaticMethodInvocation staticMethodInvocation) {
        staticMethodInvocation.getClassName().accept(this);
        this.buffer.append("::");
        staticMethodInvocation.getMethod().accept(this);
    }

    public void visit(StaticStatement staticStatement) {
        this.buffer.append("static ");
        boolean isFirst = true;
        Expression[] expressions = staticStatement.getExpressions();
        int i = 0;
        while (i < expressions.length) {
            if (!isFirst) {
                this.buffer.append(", ");
            }
            expressions[i].accept(this);
            isFirst = false;
            ++i;
        }
        this.buffer.append(";\n");
    }

    public void visit(SwitchCase switchCase) {
        if (switchCase.getValue() != null) {
            switchCase.getValue().accept(this);
            this.buffer.append(":\n");
        }
        Statement[] actions2 = switchCase.getActions();
        int i = 0;
        while (i < actions2.length) {
            actions2[i].accept(this);
            ++i;
        }
    }

    public void visit(SwitchStatement switchStatement) {
        this.buffer.append("switch (");
        switchStatement.getExpr().accept(this);
        this.buffer.append(")");
        switchStatement.getStatement().accept(this);
    }

    public void visit(ThrowStatement throwStatement) {
        throwStatement.getExpr().accept(this);
    }

    public void visit(TryStatement tryStatement) {
        this.buffer.append("try ");
        tryStatement.getTryStatement().accept(this);
        CatchClause[] catchClauses = tryStatement.getCatchClauses();
        int i = 0;
        while (i < catchClauses.length) {
            catchClauses[i].accept(this);
            ++i;
        }
    }

    public void visit(UnaryOperation unaryOperation) {
        this.buffer.append(UnaryOperation.getOperator(unaryOperation.getOperator()));
        unaryOperation.getExpr().accept(this);
    }

    public void visit(Variable variable) {
        if (variable.isDollared()) {
            this.buffer.append("$");
        }
        variable.getVariableName().accept(this);
    }

    public void visit(WhileStatement whileStatement) {
        this.buffer.append("while (");
        whileStatement.getCondition().accept(this);
        this.buffer.append(")\n");
        whileStatement.getAction().accept(this);
    }
}

