/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.containers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.PHPCorePlugin;

public class LocalFileStorage
extends PlatformObject
implements IStorage {
    private File fFile;
    private IProject fProject;
    private String fIncBaseDirName;

    public LocalFileStorage(File file) {
        this.setFile(file);
    }

    public InputStream getContents() throws CoreException {
        try {
            return new FileInputStream(this.getFile());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PHPCorePlugin.getPluginId(), 10001, CoreMessages.getString("zipEntryStorage_error"), (Throwable)e));
        }
    }

    public IPath getFullPath() {
        try {
            return new Path(this.getFile().getCanonicalPath());
        }
        catch (IOException e) {
            PHPCorePlugin.log(e);
            return null;
        }
    }

    public String getName() {
        return this.getFile().getName();
    }

    public boolean isReadOnly() {
        return true;
    }

    private void setFile(File file) {
        this.fFile = file;
    }

    public File getFile() {
        return this.fFile;
    }

    public boolean equals(Object object) {
        return object instanceof LocalFileStorage && this.getFile().equals(((LocalFileStorage)((Object)object)).getFile());
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setIncBaseDirName(String incDirName) {
        if (incDirName == null) {
            return;
        }
        try {
            this.fIncBaseDirName = new File(incDirName).getCanonicalPath();
        }
        catch (IOException e) {
            PHPCorePlugin.log(e);
        }
    }

    public String getIncBaseDirName() {
        return this.fIncBaseDirName;
    }
}

