/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.documentModel.dom.DOMDocumentForPHP;
import org.eclipse.php.internal.core.documentModel.dom.PHPDOMModelParser;
import org.eclipse.php.internal.core.documentModel.dom.PHPDOMModelUpdater;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.wst.html.core.internal.document.DOMStyleModelImpl;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.document.XMLModelParser;
import org.eclipse.wst.xml.core.internal.document.XMLModelUpdater;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class DOMModelForPHP
extends DOMStyleModelImpl {
    protected Document internalCreateDocument() {
        DOMDocumentForPHP document = new DOMDocumentForPHP();
        document.setModel((IDOMModel)this);
        return document;
    }

    protected XMLModelParser createModelParser() {
        return new PHPDOMModelParser((DOMModelImpl)this);
    }

    protected XMLModelUpdater createModelUpdater() {
        return new PHPDOMModelUpdater((DOMModelImpl)this);
    }

    public PHPFileData getFileData() {
        return this.getFileData(false);
    }

    public PHPFileData getFileData(boolean forceCreation) {
        PHPProjectModel projectModel;
        PHPFileData fileData = null;
        IFile file = this.getIFile();
        if (file != null && (projectModel = this.getProjectModel()) != null) {
            fileData = projectModel.getFileData(file.getFullPath().toString());
        }
        if (fileData == null) {
            projectModel = this.getProjectModel();
            fileData = this.internalGetFileData(projectModel != null && forceCreation);
        }
        return fileData;
    }

    protected PHPFileData internalGetFileData(boolean forceCreation) {
        IFile file;
        PHPFileData fileData = PHPWorkspaceModelManager.getInstance().getModelForFile(this.getBaseLocation(), forceCreation);
        if (fileData == null && (file = this.getIFile()) != null && ExternalFilesRegistry.getInstance().isEntryExist(file.getFullPath().toOSString())) {
            fileData = PHPWorkspaceModelManager.getInstance().getModelForFile(new Path(this.getBaseLocation()).toOSString());
        }
        return fileData;
    }

    public PHPProjectModel getProjectModel() {
        IFile iFile = this.getIFile();
        if (iFile != null && ExternalFilesRegistry.getInstance().isEntryExist(iFile.getFullPath().toOSString())) {
            return PHPWorkspaceModelManager.getDefaultPHPProjectModel();
        }
        PHPFileData fileData = this.internalGetFileData(false);
        return fileData != null ? PHPModelUtil.getProjectModelForFile(fileData) : null;
    }

    public void updateFileData() {
        IFile file = this.getIFile();
        if (file != null) {
            PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(file.getProject());
            if (projectModel != null && file.exists()) {
                projectModel.fileWasChanged(file, (IDocument)this.getStructuredDocument());
            } else if (ExternalFilesRegistry.getInstance().isEntryExist(file)) {
                projectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel();
                projectModel.fileWasChanged(file, (IDocument)this.getStructuredDocument());
            }
        }
    }

    public IFile getIFile() {
        IWorkspaceRoot root;
        IFile result;
        String id = this.getId();
        if ("org.eclipse.wst.sse.core.IModelManager.UNMANAGED_MODEL".equals(id)) {
            return null;
        }
        String path = this.getBaseLocation();
        if (path == null || path.length() == 0) {
            if (id == null) {
                return null;
            }
            path = id.toString();
        }
        if ((result = (IFile)(root = ResourcesPlugin.getWorkspace().getRoot()).findMember((IPath)new Path(path))) != null) {
            return result;
        }
        if (ExternalFilesRegistry.getInstance().isEntryExist(new Path(path).toOSString())) {
            result = ExternalFilesRegistry.getInstance().getFileEntry(new Path(path).toOSString());
        }
        if (result == null) {
            IPath osPath;
            if (Platform.getOS() != "win32") {
                path = path.replace('\\', '/');
            }
            if ((osPath = Path.fromOSString((String)path)).segmentCount() > 1) {
                result = ResourcesPlugin.getWorkspace().getRoot().getFile(osPath);
            }
        }
        return result;
    }
}

