/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.dom;

import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;

public class Utils {
    public static PHPCodeData getPHPCodeData(NodeImpl node, int offset) {
        String location = node.getModel().getBaseLocation();
        PHPFileData fileData = PHPWorkspaceModelManager.getInstance().getModelForFile(location);
        if (fileData == null) {
            return null;
        }
        return Utils.getCodeData(fileData, offset);
    }

    public static PHPCodeData getCodeData(PHPFileData fileData, int offset) {
        PHPClassData[] classes;
        PHPFunctionData[] functions;
        PHPConstantData[] constants = fileData.getConstants();
        if (constants != null) {
            int i = 0;
            while (i < constants.length) {
                if (Utils.isInside(offset, constants[i])) {
                    return constants[i];
                }
                ++i;
            }
        }
        if ((functions = fileData.getFunctions()) != null) {
            int i = 0;
            while (i < functions.length) {
                if (Utils.isInside(offset, functions[i])) {
                    return functions[i];
                }
                ++i;
            }
        }
        if ((classes = fileData.getClasses()) != null) {
            int i = 0;
            while (i < classes.length) {
                if (Utils.isInside(offset, classes[i])) {
                    PHPClassVarData[] vars = classes[i].getVars();
                    int j = 0;
                    while (j < vars.length) {
                        if (Utils.isInside(offset, vars[j])) {
                            return vars[j];
                        }
                        ++j;
                    }
                    PHPClassConstData[] consts = classes[i].getConsts();
                    int j2 = 0;
                    while (j2 < consts.length) {
                        if (Utils.isInside(offset, consts[j2])) {
                            return consts[j2];
                        }
                        ++j2;
                    }
                    functions = classes[i].getFunctions();
                    j2 = 0;
                    while (j2 < functions.length) {
                        if (Utils.isInside(offset, functions[j2])) {
                            return functions[j2];
                        }
                        ++j2;
                    }
                    return classes[i];
                }
                ++i;
            }
        }
        return fileData;
    }

    public static boolean isInside(int offset, PHPCodeData codeData) {
        UserData userData = codeData.getUserData();
        if (userData == null) {
            return false;
        }
        return offset >= userData.getStartPosition() && offset <= userData.getEndPosition();
    }
}

