/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.php.internal.core.phpModel.parser.CodeDataFilter;
import org.eclipse.php.internal.core.phpModel.parser.ComparableName;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;

public class ModelSupport {
    private static final CodeData[] EMPTY_DATA = new CodeData[0];
    private static final String EMPTY_STRING = "";
    public static final CodeDataFilter STATIC_VARIABLES_FILTER = new StaticVariablesFilter(true);
    public static final CodeDataFilter NOT_STATIC_VARIABLES_FILTER = new StaticVariablesFilter(false);
    public static final CodeDataFilter STATIC_FUNCTIONS_FILTER = new StaticFunctionsFilter(true);
    public static final CodeDataFilter INTERNAL_CODEDATA_FILTER = new InternalPhpCodeData();
    public static final CodeDataFilter NOT_MAGIC_FUNCTION = new MagicFunctionFilter(false);
    public static final CodeDataFilter IS_ABSTRACT_CLASS_FILTER = new CodeDataFilter(){

        public boolean accept(CodeData codeData) {
            if (codeData instanceof PHPClassData) {
                int modifier = ((PHPClassData)codeData).getModifiers();
                return PHPModifier.isAbstract(modifier);
            }
            return true;
        }
    };
    public static final CodeDataFilter PIRVATE_ACCESS_LEVEL_FILTER = new AccessLevelFilter(){

        public boolean verify(int modifier) {
            return true;
        }
    };
    public static final CodeDataFilter PROTECTED_ACCESS_LEVEL_FILTER = new AccessLevelFilter(){

        public boolean verify(int modifier) {
            return !PHPModifier.isPrivate(modifier);
        }
    };
    public static final CodeDataFilter PUBLIC_ACCESS_LEVEL_FILTER = new AccessLevelFilter(){

        public boolean verify(int modifier) {
            return !PHPModifier.isPrivate(modifier) && !PHPModifier.isProtected(modifier);
        }
    };
    public static final CodeDataFilter NOT_FINAL_FILTER = new AccessLevelFilter(){

        public boolean verify(int modifier) {
            return !PHPModifier.isFinal(modifier);
        }
    };
    public static final CodeDataFilter PROTECTED_ACCESS_LEVEL_FILTER_EXCLUDE_VARS_NOT_STATIC = new AccessLevelFilter(){

        public boolean verify(int modifier) {
            return true;
        }

        public boolean accept(CodeData codeData) {
            if (codeData instanceof PHPClassVarData) {
                return PROTECTED_ACCESS_LEVEL_FILTER.accept(codeData) && STATIC_VARIABLES_FILTER.accept(codeData);
            }
            if (codeData instanceof PHPFunctionData) {
                return PROTECTED_ACCESS_LEVEL_FILTER.accept(codeData);
            }
            return true;
        }
    };
    public static final CodeDataFilter PUBLIC_ACCESS_LEVEL_FILTER_EXCLUDE_VARS_NOT_STATIC = new AccessLevelFilter(){

        public boolean verify(int modifier) {
            return true;
        }

        public boolean accept(CodeData codeData) {
            if (codeData instanceof PHPClassVarData) {
                return PUBLIC_ACCESS_LEVEL_FILTER.accept(codeData) && STATIC_VARIABLES_FILTER.accept(codeData);
            }
            if (codeData instanceof PHPFunctionData) {
                return PUBLIC_ACCESS_LEVEL_FILTER.accept(codeData);
            }
            return true;
        }
    };
    private static final int SMALL_ARRAY_SIZE = 12;
    public static final PHPCodeContext EMPTY_CONTEXT = new PHPCodeContextImp("", "", "");

    private ModelSupport() {
    }

    public static CodeData[] getCodeDataStartingWith(CodeData[] sortedArray, String startsWith) {
        return ModelSupport.getCodeDataStartingWith(sortedArray, startsWith, false, false);
    }

    public static CodeData[] getFileDataStartingWith(CodeData[] sortedArray, String startsWith) {
        return ModelSupport.getCodeDataStartingWith(sortedArray, startsWith, true, false);
    }

    public static CodeData[] getCodeDataStartingWithCS(CodeData[] sortedArray, String startsWith) {
        return ModelSupport.getCodeDataStartingWith(sortedArray, startsWith, false, true);
    }

    public static CodeData[] getFileDataStartingWithCS(CodeData[] sortedArray, String startsWith) {
        return ModelSupport.getCodeDataStartingWith(sortedArray, startsWith, true, true);
    }

    private static CodeData[] getCodeDataStartingWith(CodeData[] sortedArray, String startsWith, boolean useComparableName, boolean caseSensitive) {
        if (sortedArray == null) {
            sortedArray = PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
        }
        if (startsWith == null || startsWith.equals(EMPTY_STRING) || sortedArray.length == 0) {
            return sortedArray;
        }
        int start = ModelSupport.getFirstMatch(sortedArray, startsWith, false, useComparableName, caseSensitive);
        if (start < 0) {
            return PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
        }
        int end = sortedArray.length - 1;
        int length = startsWith.length();
        int i = start;
        while (i < sortedArray.length) {
            String name = useComparableName ? ((ComparableName)((Object)sortedArray[i])).getComparableName() : sortedArray[i].getName();
            String string = name = name.length() > length ? name.substring(0, length) : name;
            if (caseSensitive) {
                if (name.compareTo(startsWith) > 0) {
                    end = i - 1;
                    break;
                }
            } else if (name.compareToIgnoreCase(startsWith) != 0) {
                end = i - 1;
                break;
            }
            ++i;
        }
        int arrayLength = end < start ? 0 : end - start + 1;
        CodeData[] rv = new CodeData[arrayLength];
        System.arraycopy(sortedArray, start, rv, 0, rv.length);
        return rv;
    }

    public static int getFirstMatch(CodeData[] sortedArray, String searchName, boolean exactName) {
        return ModelSupport.getFirstMatch(sortedArray, searchName, exactName, false, false);
    }

    public static int getFirstMatchCS(CodeData[] sortedArray, String searchName, boolean exactName) {
        return ModelSupport.getFirstMatch(sortedArray, searchName, exactName, false, true);
    }

    private static int getFirstMatch(CodeData[] sortedArray, String searchName, boolean exactName, boolean useComparableName, boolean caseSensitive) {
        String name;
        int searchNameLength = searchName.length();
        if (searchNameLength == 0) {
            if (exactName) {
                return -1;
            }
            return 0;
        }
        if (sortedArray == null || sortedArray.length == 0) {
            return -1;
        }
        if (sortedArray.length < 12) {
            int i = 0;
            while (i < sortedArray.length) {
                String name2;
                String string = name2 = useComparableName ? ((ComparableName)((Object)sortedArray[i])).getComparableName() : sortedArray[i].getName();
                if (!exactName && name2.length() > searchNameLength) {
                    name2 = name2.substring(0, searchNameLength);
                }
                if (caseSensitive ? searchName.equals(name2) : searchName.equalsIgnoreCase(name2)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        int start = 0;
        int end = sortedArray.length - 1;
        while (start <= end) {
            int compareResult;
            String name3;
            int mid = start + end >> 1;
            String string = name3 = useComparableName ? ((ComparableName)((Object)sortedArray[mid])).getComparableName() : sortedArray[mid].getName();
            if (!exactName && name3.length() > searchNameLength) {
                name3 = name3.substring(0, searchNameLength);
            }
            int n = compareResult = caseSensitive ? name3.compareTo(searchName) : name3.compareToIgnoreCase(searchName);
            if (compareResult == 0) {
                start = mid;
                break;
            }
            if (compareResult < 0) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        if (start < 0 || start >= sortedArray.length) {
            return -1;
        }
        String string = name = useComparableName ? ((ComparableName)((Object)sortedArray[start])).getComparableName() : sortedArray[start].getName();
        if (!exactName && name.length() > searchNameLength) {
            name = name.substring(0, searchNameLength);
        }
        if (caseSensitive ? !name.equals(searchName) : !name.equalsIgnoreCase(searchName)) {
            return -1;
        }
        --start;
        while (start >= 0) {
            String string2 = name = useComparableName ? ((ComparableName)((Object)sortedArray[start])).getComparableName() : sortedArray[start].getName();
            if (!exactName && name.length() > searchNameLength) {
                name = name.substring(0, searchNameLength);
            }
            if (caseSensitive ? !name.equals(searchName) : !name.equalsIgnoreCase(searchName)) break;
            --start;
        }
        return start + 1;
    }

    private static int getFirstMatch(File[] sortedArray, String searchName, boolean caseSensitive) {
        int searchNameLength = searchName.length();
        if (searchNameLength == 0) {
            return 0;
        }
        if (sortedArray == null || sortedArray.length == 0) {
            return -1;
        }
        if (sortedArray.length < 12) {
            int i = 0;
            while (i < sortedArray.length) {
                String name = sortedArray[i].getName();
                if (name.length() > searchNameLength) {
                    name = name.substring(0, searchNameLength);
                }
                if (caseSensitive ? searchName.equals(name) : searchName.equalsIgnoreCase(name)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        int start = 0;
        int end = sortedArray.length - 1;
        while (start <= end) {
            int compareResult;
            int mid = start + end >> 1;
            String name = sortedArray[mid].getName();
            if (name.length() > searchNameLength) {
                name = name.substring(0, searchNameLength);
            }
            int n = compareResult = caseSensitive ? name.compareTo(searchName) : name.compareToIgnoreCase(searchName);
            if (compareResult == 0) {
                start = mid;
                break;
            }
            if (compareResult < 0) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        if (start < 0 || start >= sortedArray.length) {
            return -1;
        }
        String name = sortedArray[start].getName();
        if (name.length() > searchNameLength) {
            name = name.substring(0, searchNameLength);
        }
        if (caseSensitive ? !name.equals(searchName) : !name.equalsIgnoreCase(searchName)) {
            return -1;
        }
        --start;
        while (start >= 0) {
            name = sortedArray[start].getName();
            if (name.length() > searchNameLength) {
                name = name.substring(0, searchNameLength);
            }
            if (caseSensitive ? !name.equals(searchName) : !name.equalsIgnoreCase(searchName)) break;
            --start;
        }
        return start + 1;
    }

    public static CodeData[] removeRepeatedNames(CodeData[] sortedArray) {
        if (sortedArray == null || sortedArray.length < 2) {
            return sortedArray;
        }
        ArrayList<CodeData> newCodeDataList = new ArrayList<CodeData>();
        String baseName = EMPTY_STRING;
        CodeData[] codeDataArray = sortedArray;
        int n = sortedArray.length;
        int n2 = 0;
        while (n2 < n) {
            CodeData element = codeDataArray[n2];
            String curName = element.getName();
            if (!baseName.equals(curName)) {
                newCodeDataList.add(element);
            }
            baseName = curName;
            ++n2;
        }
        CodeData[] rv = new CodeData[newCodeDataList.size()];
        newCodeDataList.toArray(rv);
        return rv;
    }

    public static CodeData[] mergeNoDuplicates(CodeData[] sortedArray1, CodeData[] sortedArray2) {
        if (sortedArray1 == null || sortedArray1.length == 0) {
            if (sortedArray2 == null) {
                return EMPTY_DATA;
            }
            return sortedArray2;
        }
        if (sortedArray2 == null || sortedArray2.length == 0) {
            return sortedArray1;
        }
        ArrayList<CodeData> merged = new ArrayList<CodeData>(sortedArray1.length + sortedArray2.length);
        int pointer1 = 0;
        int pointer2 = 0;
        while (pointer1 != sortedArray1.length || pointer2 != sortedArray2.length) {
            if (pointer1 == sortedArray1.length) {
                merged.add(sortedArray2[pointer2++]);
                continue;
            }
            if (pointer2 == sortedArray2.length) {
                merged.add(sortedArray1[pointer1++]);
                continue;
            }
            int compared = sortedArray1[pointer1].compareTo(sortedArray2[pointer2]);
            if (compared == 0) {
                merged.add(sortedArray1[pointer1++]);
                ++pointer2;
                continue;
            }
            if (compared < 0) {
                merged.add(sortedArray1[pointer1++]);
                continue;
            }
            merged.add(sortedArray2[pointer2++]);
        }
        CodeData[] result = new CodeData[merged.size()];
        merged.toArray(result);
        return result;
    }

    public static CodeData[] merge(CodeData[] sortedArray1, CodeData[] sortedArray2) {
        if (sortedArray1 == null || sortedArray1.length == 0) {
            if (sortedArray2 == null) {
                return EMPTY_DATA;
            }
            return sortedArray2;
        }
        if (sortedArray2 == null || sortedArray2.length == 0) {
            return sortedArray1;
        }
        int size = sortedArray1.length + sortedArray2.length;
        CodeData[] rv = new CodeData[size];
        int pointer1 = 0;
        int pointer2 = 0;
        int i = 0;
        while (i < size) {
            if (pointer1 == sortedArray1.length) {
                System.arraycopy(sortedArray2, pointer2, rv, i, size - i);
                break;
            }
            if (pointer2 == sortedArray2.length) {
                System.arraycopy(sortedArray1, pointer1, rv, i, size - i);
                break;
            }
            rv[i] = sortedArray1[pointer1].compareTo(sortedArray2[pointer2]) < 0 ? sortedArray1[pointer1++] : sortedArray2[pointer2++];
            ++i;
        }
        return rv;
    }

    public static PHPCodeContext createContext(String className, String functionName) {
        if (className == null) {
            className = EMPTY_STRING;
        }
        if (functionName == null) {
            functionName = EMPTY_STRING;
        }
        if (EMPTY_STRING.equals(className) && EMPTY_STRING.equals(functionName)) {
            return EMPTY_CONTEXT;
        }
        return new PHPCodeContextImp(null, className, functionName);
    }

    public static PHPCodeContext createContext(PHPFileData fileData, int offset) {
        return ModelSupport.createContext(PHPFileDataUtilities.getCodeData(fileData, offset));
    }

    public static PHPCodeContext createContext(String fileName, String className, String functionName) {
        return new PHPCodeContextImp(fileName, className, functionName);
    }

    public static PHPCodeContext createContext(CodeData currCodeData) {
        String functionName;
        if (currCodeData == null) {
            return EMPTY_CONTEXT;
        }
        String fileName = currCodeData.getUserData().getFileName();
        String className = EMPTY_STRING;
        if (currCodeData instanceof PHPFunctionData) {
            PHPFunctionData functionCodeData = (PHPFunctionData)currCodeData;
            functionName = functionCodeData.getName();
            PHPCodeData container = functionCodeData.getContainer();
            if (container != null && container instanceof PHPClassData) {
                className = container.getName();
            }
        } else {
            functionName = currCodeData.getName();
        }
        return new PHPCodeContextImp(fileName, className, functionName);
    }

    public static CodeData[] getFilteredCodeData(CodeData[] data, CodeDataFilter codeDataFilter) {
        if (data == null || data.length == 0) {
            return EMPTY_DATA;
        }
        ArrayList<CodeData> listResult = new ArrayList<CodeData>();
        CodeData[] codeDataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            CodeData element = codeDataArray[n2];
            if (codeDataFilter.accept(element)) {
                listResult.add(element);
            }
            ++n2;
        }
        CodeData[] result = new CodeData[listResult.size()];
        listResult.toArray(result);
        return result;
    }

    public static CodeData[] removeFilteredCodeData(CodeData[] data, CodeDataFilter codeDataFilter) {
        if (data == null || data.length == 0) {
            return data;
        }
        ArrayList<CodeData> listResult = new ArrayList<CodeData>();
        int i = 0;
        while (i < data.length) {
            if (!codeDataFilter.accept(data[i])) {
                listResult.add(data[i]);
            }
            ++i;
        }
        CodeData[] result = new CodeData[listResult.size()];
        listResult.toArray(result);
        return result;
    }

    public static File[] getFileSStartingWith(File[] sortedArray, String startsWith, boolean caseSensitive) {
        if (sortedArray == null) {
            sortedArray = new File[]{};
        }
        if (startsWith == null || startsWith.equals(EMPTY_STRING) || sortedArray.length == 0) {
            return sortedArray;
        }
        int start = ModelSupport.getFirstMatch(sortedArray, startsWith, caseSensitive);
        if (start < 0) {
            return new File[0];
        }
        int end = sortedArray.length - 1;
        int length = startsWith.length();
        int i = start;
        while (i < sortedArray.length) {
            String name = sortedArray[i].getName();
            String string = name = name.length() > length ? name.substring(0, length) : name;
            if (caseSensitive) {
                if (name.compareTo(startsWith) > 0) {
                    end = i - 1;
                    break;
                }
            } else if (name.compareToIgnoreCase(startsWith) > 0) {
                end = i - 1;
                break;
            }
            ++i;
        }
        int arrayLength = end < start ? 0 : end - start + 1;
        File[] rv = new File[arrayLength];
        System.arraycopy(sortedArray, start, rv, 0, rv.length);
        return rv;
    }

    private static abstract class AccessLevelFilter
    implements CodeDataFilter {
        private AccessLevelFilter() {
        }

        public boolean accept(CodeData codeData) {
            if (codeData instanceof PHPClassVarData) {
                return this.verify(((PHPClassVarData)codeData).getModifiers());
            }
            if (codeData instanceof PHPFunctionData) {
                return this.verify(((PHPFunctionData)codeData).getModifiers());
            }
            return true;
        }

        public abstract boolean verify(int var1);
    }

    private static final class InternalPhpCodeData
    implements CodeDataFilter {
        private InternalPhpCodeData() {
        }

        public boolean accept(CodeData codeData) {
            if (codeData == null || !(codeData instanceof PHPCodeData)) {
                return false;
            }
            PHPCodeData phpData = (PHPCodeData)codeData;
            PHPDocBlock docBlock = phpData.getDocBlock();
            return docBlock != null && docBlock.hasTagOf(21);
        }
    }

    private static final class MagicFunctionFilter
    implements CodeDataFilter {
        private static String[] magicFunction;
        boolean acceptMagicFunction;

        MagicFunctionFilter(boolean acceptMagicFunction) {
            this.acceptMagicFunction = acceptMagicFunction;
            CodeData[] magics = PHPCodeDataFactory.createMagicMethods(PHPCodeDataFactory.createPHPClassData("dummyClass", 1, null, PHPCodeDataFactory.createUserData(ModelSupport.EMPTY_STRING, 0, 0, 0, 0), null, PHPCodeDataFactory.EMPTY_INTERFACES_DATA_ARRAY, PHPCodeDataFactory.EMPTY_CLASS_VAR_DATA_ARRAY, PHPCodeDataFactory.EMPTY_CLASS_CONST_DATA_ARRAY, PHPCodeDataFactory.EMPTY_FUNCTIONS_DATA_ARRAY), true);
            magicFunction = new String[magics.length + 2];
            MagicFunctionFilter.magicFunction[0] = "__construct";
            MagicFunctionFilter.magicFunction[1] = "__destruct";
            int i = 2;
            while (i < magicFunction.length) {
                MagicFunctionFilter.magicFunction[i] = magics[i - 2].getName();
                ++i;
            }
        }

        public boolean accept(CodeData codeData) {
            if (codeData instanceof PHPFunctionData) {
                PHPClassData classData;
                PHPFunctionData function = (PHPFunctionData)codeData;
                String functionName = function.getName();
                if (this.isMagicFunction(functionName)) {
                    return this.acceptMagicFunction;
                }
                PHPCodeData container = function.getContainer();
                if (container instanceof PHPClassData && (classData = (PHPClassData)container).getName().equals(functionName)) {
                    return this.acceptMagicFunction;
                }
            }
            return !this.acceptMagicFunction;
        }

        private boolean isMagicFunction(String functionName) {
            String[] stringArray = magicFunction;
            int n = magicFunction.length;
            int n2 = 0;
            while (n2 < n) {
                String magicFunctionName = stringArray[n2];
                if (magicFunctionName.equals(functionName)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private static class PHPCodeContextImp
    implements PHPCodeContext,
    Serializable {
        private final String className;
        private final String functionName;
        private int hash;

        PHPCodeContextImp(String fileName, String className, String functionName) {
            this.className = className;
            this.functionName = functionName;
        }

        public final String getContainerClassName() {
            return this.className;
        }

        public final String getContainerFunctionName() {
            return this.functionName;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PHPCodeContextImp)) {
                return false;
            }
            PHPCodeContextImp other = (PHPCodeContextImp)obj;
            return this.className.equals(other.className) && this.functionName.equals(other.functionName);
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                h = this.functionName.hashCode();
                h = 31 * h + this.className.hashCode();
                this.hash = h = 31 * h + this.functionName.hashCode();
            }
            return h;
        }
    }

    private static class StaticFunctionsFilter
    implements CodeDataFilter {
        boolean acceptStatic;

        StaticFunctionsFilter(boolean acceptStatic) {
            this.acceptStatic = acceptStatic;
        }

        public boolean accept(CodeData codeData) {
            if (codeData instanceof PHPFunctionData && PHPModifier.isStatic(((PHPFunctionData)codeData).getModifiers())) {
                return this.acceptStatic;
            }
            return !this.acceptStatic;
        }
    }

    private static class StaticVariablesFilter
    implements CodeDataFilter {
        boolean acceptStatic;

        StaticVariablesFilter(boolean acceptStatic) {
            this.acceptStatic = acceptStatic;
        }

        public boolean accept(CodeData codeData) {
            if (codeData instanceof PHPVariableData && PHPModifier.isStatic(((PHPClassVarData)codeData).getModifiers())) {
                return this.acceptStatic;
            }
            return !this.acceptStatic;
        }
    }
}

