/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.phpModel.parser.ComparableName;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.phpElementData.AbstractCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.BasicPHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlockImp;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPProjectModelVisitor;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableTypeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariablesTypeManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.util.Visitor;

public class PHPCodeDataFactory {
    public static final CodeData[] EMPTY_CODE_DATA_ARRAY = new CodeData[0];
    public static final PHPClassData[] EMPTY_CLASS_DATA_ARRAY = new PHPClassData[0];
    public static final PHPFunctionData[] EMPTY_FUNCTIONS_DATA_ARRAY = new PHPFunctionData[0];
    public static final PHPIncludeFileData[] EMPTY_INCLUDE_DATA_ARRAY = new PHPIncludeFileData[0];
    public static final PHPConstantData[] EMPTY_CONSTANT_DATA_ARRAY = new PHPConstantData[0];
    public static final IPHPMarker[] EMPTY_MARKERS_DATA_ARRAY = new IPHPMarker[0];
    public static final PHPClassVarData[] EMPTY_CLASS_VAR_DATA_ARRAY = new PHPClassVarData[0];
    public static final PHPClassConstData[] EMPTY_CLASS_CONST_DATA_ARRAY = new PHPClassConstData[0];
    public static final PHPClassData.PHPInterfaceNameData[] EMPTY_INTERFACES_DATA_ARRAY = new PHPClassData.PHPInterfaceNameData[0];
    public static final PHPBlock[] EMPTY_PHP_BLOCK_ARRAY = new PHPBlock[0];
    public static final PHPFunctionData.PHPFunctionParameter[] EMPTY_FUNCTION_PARAMETER_DATA_ARRAY = new PHPFunctionData.PHPFunctionParameter[0];
    public static final PHPDocTag[] EMPTY_PHP_DOC_TAG = new PHPDocTag[0];
    public static final EmptyPHPVariablesTypeManager EMPTY_PHP_VARIABLES_TYPE_MANAGER = new EmptyPHPVariablesTypeManager();
    private static final String EMPTY_STRING = "";

    public static PHPFunctionData createPHPFuctionData(String name, int modifier, PHPDocBlock docBlock, UserData userData, PHPFunctionData.PHPFunctionParameter[] parameter, String returnType) {
        return new PHPFunctionDataImp(name, modifier, docBlock, userData, parameter, returnType);
    }

    public static PHPFunctionData.PHPFunctionParameter createPHPFunctionParameter(String name, UserData userData, boolean isReference, boolean isConst, String classType, String defaultValue) {
        return new PHPFunctionParameterImp(name, userData, isReference, isConst, classType, defaultValue);
    }

    public static PHPClassVarData createPHPClassVarData(String name, int modifier, String classType, PHPDocBlock docBlock, UserData userData) {
        return new PHPClassVarDataImp(name, modifier, classType, docBlock, userData);
    }

    public static PHPClassConstData createPHPClassConstData(String name, String value, PHPDocBlock docBlock, UserData userData) {
        return new PHPClassConstDataImp(name, value, docBlock, userData);
    }

    public static PHPIncludeFileData createPHPIncludeFileData(String includingType, String name, PHPDocBlock docBlock, UserData userData) {
        return new PHPIncludeFileDataImp(includingType, name, docBlock, userData);
    }

    public static PHPClassData createPHPClassData(String name, int modifier, PHPDocBlock docBlock, UserData userData, PHPClassData.PHPSuperClassNameData superClass, PHPClassData.PHPInterfaceNameData[] interfaces, PHPClassVarData[] vars, PHPClassConstData[] consts, PHPFunctionData[] functions) {
        return new PHPClassDataImp(name, modifier, docBlock, userData, superClass, interfaces, vars, consts, functions);
    }

    public static PHPKeywordData createPHPKeywordData(String name, String suffix, int suffixOffset) {
        return new PHPKeywordDataImp(name, suffix, suffixOffset);
    }

    public static PHPClassData.PHPSuperClassNameData createPHPSuperClassNameData(String name, UserData userData) {
        return new PHPSuperClassNameDataImp(name, userData);
    }

    public static PHPClassData.PHPInterfaceNameData createPHPInterfaceNameData(String name, UserData userData) {
        return new PHPInterfaceNameDataImp(name, userData);
    }

    public static PHPConstantData createPHPConstantData(String name, String value, UserData userData, PHPDocBlock docBlock) {
        return new PHPConstantDataImp(name, value, userData, docBlock);
    }

    public static PHPVariableData createPHPVariableData(String name, PHPDocBlock docBlock, UserData userData) {
        return new PHPVariableDataImp(name, docBlock, userData);
    }

    public static PHPVariableData createPHPVariableData(String name, boolean isGlobal, PHPDocBlock docBlock, UserData userData) {
        return new PHPVariableDataImp(name, isGlobal, docBlock, userData);
    }

    public static PHPFileData createPHPFileData(String fileName, UserData userData, PHPClassData[] classes, PHPFunctionData[] functions, PHPVariablesTypeManager variablesTypeManager, PHPIncludeFileData[] includeFiles, PHPConstantData[] constans, IPHPMarker[] markers, PHPBlock[] phpBlocks, PHPDocBlock docBlock, long lastModified) {
        return new PHPFileDataImp(fileName, userData, classes, functions, variablesTypeManager, includeFiles, constans, markers, phpBlocks, docBlock, lastModified);
    }

    public static UserData createUserData(String fileName, int startPosition, int endPosition, int stopPosition, int stopLine) {
        return new UserDataImp(fileName, startPosition, endPosition, stopPosition, stopLine);
    }

    public static CodeData[] createMagicMethods(PHPClassData classData, boolean isPHP5) {
        LinkedList<PHPFunctionData> methods = new LinkedList<PHPFunctionData>();
        methods.add(PHPCodeDataFactory.createPHPFuctionData("__get", 1, new PHPDocBlockImp("This magic method is called each time variable is referenced from the object", null, new PHPDocTag[]{new BasicPHPDocTag(7, "string $name variable name"), new BasicPHPDocTag(6, "variable value")}, 2), classData.getUserData(), new PHPFunctionData.PHPFunctionParameter[]{new PHPFunctionParameterImp("name", null, false, false, "string", null)}, "mixed"));
        methods.add(PHPCodeDataFactory.createPHPFuctionData("__set", 1, new PHPDocBlockImp("This magic method is called each time variable is set in the object", null, new PHPDocTag[]{new BasicPHPDocTag(7, "string $name variable name"), new BasicPHPDocTag(7, "mixed $value variable value"), new BasicPHPDocTag(6, "void")}, 2), classData.getUserData(), new PHPFunctionData.PHPFunctionParameter[]{new PHPFunctionParameterImp("name", null, false, false, "string", null), new PHPFunctionParameterImp("value", null, false, false, "string", null)}, "void"));
        methods.add(PHPCodeDataFactory.createPHPFuctionData("__call", 1, new PHPDocBlockImp("This magic method is invoked each time not existing method is called on the object", null, new PHPDocTag[]{new BasicPHPDocTag(7, "string $name method name"), new BasicPHPDocTag(7, "array arguments method arguments"), new BasicPHPDocTag(6, "Return value of non-existent method")}, 2), classData.getUserData(), new PHPFunctionData.PHPFunctionParameter[]{new PHPFunctionParameterImp("name", null, false, false, "string", null), new PHPFunctionParameterImp("arguments", null, false, false, "array", null)}, "mixed"));
        methods.add(PHPCodeDataFactory.createPHPFuctionData("__sleep", 1, new PHPDocBlockImp("This magic method is executed prior to any serialization of the object", null, EMPTY_PHP_DOC_TAG, 2), classData.getUserData(), EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, null));
        methods.add(PHPCodeDataFactory.createPHPFuctionData("__wakeup", 1, new PHPDocBlockImp("This magic method is executed after the object is deserialized", null, EMPTY_PHP_DOC_TAG, 2), classData.getUserData(), EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, null));
        if (isPHP5) {
            methods.add(PHPCodeDataFactory.createPHPFuctionData("__isset", 1, new PHPDocBlockImp("This magic method is invoked each time isset() is called on the object variable", null, new PHPDocTag[]{new BasicPHPDocTag(7, "string $name variable name"), new BasicPHPDocTag(6, "true if the object variable is set, otherwise false")}, 2), classData.getUserData(), new PHPFunctionData.PHPFunctionParameter[]{new PHPFunctionParameterImp("name", null, false, false, "string", null)}, "boolean"));
            methods.add(PHPCodeDataFactory.createPHPFuctionData("__unset", 1, new PHPDocBlockImp("This magic method is invoked each time unset() is called on the object variable", null, new PHPDocTag[]{new BasicPHPDocTag(7, "string $name variable name"), new BasicPHPDocTag(6, "unsets the object variable")}, 2), classData.getUserData(), new PHPFunctionData.PHPFunctionParameter[]{new PHPFunctionParameterImp("name", null, false, false, "string", null)}, "void"));
            methods.add(PHPCodeDataFactory.createPHPFuctionData("__toString", 1, new PHPDocBlockImp("This magic method is used for setting a string value for the object that will be used if the object is used as a string.", null, new PHPDocTag[]{new BasicPHPDocTag(6, "string representing the object")}, 2), classData.getUserData(), new PHPFunctionData.PHPFunctionParameter[0], "string"));
            methods.add(PHPCodeDataFactory.createPHPFuctionData("__set_state", 1, new PHPDocBlockImp("This static method is called for classes exported by var_export() since PHP 5.1.0", null, new PHPDocTag[0], 2), classData.getUserData(), new PHPFunctionData.PHPFunctionParameter[0], "void"));
            methods.add(PHPCodeDataFactory.createPHPFuctionData("__clone", 1, new PHPDocBlockImp("This magic method is invoked each time clone is called on the object variable", null, new PHPDocTag[0], 2), classData.getUserData(), new PHPFunctionData.PHPFunctionParameter[0], "void"));
            methods.add(PHPCodeDataFactory.createPHPFuctionData("__autoload", 1, new PHPDocBlockImp("This magic method is invoked in case you are trying to use a class which hasn't been defined yet", null, new PHPDocTag[]{new BasicPHPDocTag(7, "string $name class name"), new BasicPHPDocTag(6, "new class object")}, 2), classData.getUserData(), new PHPFunctionData.PHPFunctionParameter[]{new PHPFunctionParameterImp("name", null, false, false, "string", null)}, "mixed"));
        }
        return methods.toArray(new CodeData[methods.size()]);
    }

    public static CodeData[] createConstructors(PHPClassData classData, boolean isPHP5) {
        LinkedList<PHPFunctionData> constructors = new LinkedList<PHPFunctionData>();
        constructors.add(PHPCodeDataFactory.createPHPFuctionData(classData.getName(), 1, new PHPDocBlockImp("Constructs this object", null, EMPTY_PHP_DOC_TAG, 2), classData.getUserData(), EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, classData.getName()));
        if (isPHP5) {
            constructors.add(PHPCodeDataFactory.createPHPFuctionData("__construct", 1, new PHPDocBlockImp("Constructs this object", null, EMPTY_PHP_DOC_TAG, 2), classData.getUserData(), EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, classData.getName()));
            constructors.add(PHPCodeDataFactory.createPHPFuctionData("__destruct", 1, new PHPDocBlockImp("Destructs this object", null, EMPTY_PHP_DOC_TAG, 2), classData.getUserData(), EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, "void"));
        }
        return constructors.toArray(new CodeData[constructors.size()]);
    }

    private static class EmptyPHPVariablesTypeManager
    implements PHPVariablesTypeManager {
        private static final Map EMPTY_MAP = new HashMap(0);
        private static final PHPVariableData[] EMPTY_PHP_VARIABLE_DATA_ARRAY = new PHPVariableData[0];

        private EmptyPHPVariablesTypeManager() {
        }

        public Map getContextsToVariables() {
            return EMPTY_MAP;
        }

        public PHPVariableData getVariable(PHPCodeContext context, String variableName) {
            return null;
        }

        public PHPVariableTypeData getVariableTypeData(PHPCodeContext context, String variableName, int line) {
            return null;
        }

        public PHPVariableTypeData getVariableTypeDataByPosition(PHPCodeContext context, String variableName, int position) {
            return null;
        }

        public PHPVariableData[] getVariables(PHPCodeContext context) {
            return EMPTY_PHP_VARIABLE_DATA_ARRAY;
        }

        public Map getVariablesInstansiation() {
            return EMPTY_MAP;
        }
    }

    static class PHPClassConstDataImp
    extends PHPCodeDataImp
    implements PHPClassConstData {
        private String value;

        public PHPClassConstDataImp(String name, String value, PHPDocBlock docBlock, UserData userData) {
            super(name, docBlock, userData);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void accept(Visitor v) {
            ((PHPProjectModelVisitor)v).visit(this);
        }
    }

    public static class PHPClassDataImp
    extends PHPCodeDataImp
    implements PHPClassData {
        private PHPClassVarData[] vars;
        private PHPClassConstData[] consts;
        private PHPFunctionData[] functions;
        private PHPFunctionData constructor;
        private boolean hasConstructor;
        private int modifier;
        private PHPClassData.PHPSuperClassNameData superClass;
        private PHPClassData.PHPInterfaceNameData[] interfaces;

        public PHPClassDataImp(String name, int modifier, PHPDocBlock docBlock, UserData userData, PHPClassData.PHPSuperClassNameData superClass, PHPClassData.PHPInterfaceNameData[] interfaces, PHPClassVarData[] vars, PHPClassConstData[] consts, PHPFunctionData[] functions) {
            super(name, docBlock, userData);
            this.modifier = modifier;
            this.interfaces = interfaces;
            this.vars = vars;
            this.consts = consts;
            this.superClass = superClass;
            if (superClass != null) {
                this.superClass.setContainer(this);
            }
            int i = 0;
            while (i < interfaces.length) {
                this.interfaces[i].setContainer(this);
                ++i;
            }
            this.setVars(vars);
            this.setFunctions(functions);
        }

        public PHPClassData.PHPSuperClassNameData getSuperClassData() {
            return this.superClass;
        }

        public PHPClassData.PHPInterfaceNameData[] getInterfacesNamesData() {
            return this.interfaces;
        }

        public void setVars(PHPClassVarData[] vars) {
            this.vars = vars;
        }

        public PHPClassVarData[] getVars() {
            return this.vars;
        }

        public void setConsts(PHPClassConstData[] consts) {
            this.consts = consts;
        }

        public PHPClassConstData[] getConsts() {
            return this.consts;
        }

        public void setFunctions(PHPFunctionData[] functions) {
            this.functions = functions;
            this.hasConstructor = false;
            PHPFunctionData[] pHPFunctionDataArray = functions;
            int n = functions.length;
            int n2 = 0;
            while (n2 < n) {
                PHPFunctionData element = pHPFunctionDataArray[n2];
                String functionName = element.getName();
                if (functionName.equals("__construct") || functionName.equalsIgnoreCase(this.getName())) {
                    this.constructor = element;
                    this.hasConstructor = true;
                    break;
                }
                ++n2;
            }
            if (!this.hasConstructor) {
                this.constructor = PHPCodeDataFactory.createPHPFuctionData("__construct", 1, null, this.getUserData(), EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, null);
                ((PHPFunctionDataImp)this.constructor).setContainer(this);
            }
        }

        public PHPFunctionData[] getFunctions() {
            return this.functions;
        }

        public boolean hasConstructor() {
            return this.hasConstructor;
        }

        public PHPFunctionData getConstructor() {
            return this.constructor;
        }

        public int getModifiers() {
            return this.modifier;
        }

        public void accept(Visitor v) {
            ((PHPProjectModelVisitor)v).visit(this);
        }
    }

    static class PHPClassVarDataImp
    extends PHPVariableDataImp
    implements PHPClassVarData {
        private int modifier;
        private String classType;

        private PHPClassVarDataImp(String name, int modifier, String classType, PHPDocBlock docBlock, UserData userData) {
            super(name, docBlock, userData);
            this.modifier = modifier;
            this.classType = classType;
        }

        public int getModifiers() {
            return this.modifier;
        }

        public String getClassType() {
            return this.classType;
        }

        public void setClassType(String classType) {
            this.classType = classType;
        }

        public void accept(Visitor v) {
            ((PHPProjectModelVisitor)v).visit(this);
        }
    }

    static abstract class PHPCodeDataImp
    extends AbstractCodeData
    implements PHPCodeData {
        private PHPCodeData container;
        protected PHPDocBlock docBlock;

        public PHPCodeDataImp(String name, PHPDocBlock docBlock, UserData userData) {
            super(name, userData);
            this.docBlock = docBlock;
        }

        public PHPCodeData getContainer() {
            return this.container;
        }

        public void setContainer(PHPCodeData container) {
            this.container = container;
        }

        public PHPDocBlock getDocBlock() {
            return this.docBlock;
        }

        public void setDocBlock(PHPDocBlock block) {
            this.docBlock = block;
        }

        public String getDescription() {
            if (this.getDocBlock() != null) {
                return this.getDocBlock().getShortDescription();
            }
            return PHPCodeDataFactory.EMPTY_STRING;
        }

        public String toString() {
            StringBuffer string = new StringBuffer(this.name);
            this.getContainer();
            if (this.container != null) {
                string.append(" in " + this.container.toString());
            }
            return string.toString();
        }
    }

    static class PHPConstantDataImp
    extends PHPCodeDataImp
    implements PHPConstantData {
        private String value;

        public PHPConstantDataImp(String name, String value, UserData userData, PHPDocBlock docBlock) {
            super(name, docBlock, userData);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public int compareTo(CodeData o) {
            int compared = super.compareTo(o);
            if (compared != 0) {
                return compared;
            }
            if (!(o instanceof PHPConstantDataImp)) {
                return -1;
            }
            PHPConstantDataImp other = (PHPConstantDataImp)o;
            return this.getName().compareTo(other.getName());
        }

        public void accept(Visitor v) {
            ((PHPProjectModelVisitor)v).visit(this);
        }
    }

    public static class PHPFileDataImp
    extends PHPCodeDataImp
    implements PHPFileData {
        private PHPClassData[] classes;
        private PHPFunctionData[] functions;
        private PHPIncludeFileData[] includeFiles;
        private PHPVariablesTypeManager variablesTypeManager;
        private IPHPMarker[] markers;
        private PHPBlock[] phpBlocks;
        private PHPConstantData[] constants;
        private long lastModified;
        private String comparableName;

        public PHPFileDataImp(String fileName, UserData userData, PHPClassData[] classes, PHPFunctionData[] functions, PHPVariablesTypeManager variablesTypeManager, PHPIncludeFileData[] includeFiles, PHPConstantData[] constans, IPHPMarker[] markers, PHPBlock[] phpBlocks, PHPDocBlock docBlock, long lastModified) {
            super(fileName, docBlock, userData);
            this.classes = classes;
            this.functions = functions;
            this.variablesTypeManager = variablesTypeManager;
            this.includeFiles = includeFiles;
            this.markers = markers;
            this.phpBlocks = phpBlocks;
            this.constants = constans;
            this.lastModified = lastModified;
            this.comparableName = new File(this.name).getName();
        }

        public PHPClassData[] getClasses() {
            return this.classes;
        }

        public PHPFunctionData[] getFunctions() {
            return this.functions;
        }

        public PHPVariablesTypeManager getVariableTypeManager() {
            return this.variablesTypeManager;
        }

        public PHPIncludeFileData[] getIncludeFiles() {
            return this.includeFiles;
        }

        public IPHPMarker[] getMarkers() {
            return this.markers;
        }

        public PHPBlock[] getPHPBlocks() {
            return this.phpBlocks;
        }

        public PHPConstantData[] getConstants() {
            return this.constants;
        }

        public void accept(Visitor v) {
            ((PHPProjectModelVisitor)v).visit(this);
        }

        public Object getIdentifier() {
            return this.getName();
        }

        public boolean isValid() {
            long fileLastModified = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getName())).getModificationStamp();
            return this.getCreationTimeLastModified() - fileLastModified >= 0L;
        }

        public long getCreationTimeLastModified() {
            return this.lastModified;
        }

        public String getComparableName() {
            return this.comparableName;
        }

        public int compareTo(CodeData o) {
            return this.comparableName.compareToIgnoreCase(((ComparableName)((Object)o)).getComparableName());
        }
    }

    public static class PHPFunctionDataImp
    extends PHPCodeDataImp
    implements PHPFunctionData {
        private PHPFunctionData.PHPFunctionParameter[] parameter;
        private String returnType = "unknown";
        private int modifier;

        public PHPFunctionDataImp(String name, int modifier, PHPDocBlock docBlock, UserData userData, PHPFunctionData.PHPFunctionParameter[] parameter, String returnType) {
            super(name, docBlock, userData);
            this.modifier = modifier;
            this.parameter = parameter;
            if (returnType != null && returnType.trim().length() != 0) {
                this.returnType = returnType;
            }
        }

        public PHPFunctionData.PHPFunctionParameter[] getParameters() {
            return this.parameter;
        }

        public void setReturnType(String returnType) {
            this.returnType = returnType;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public int getModifiers() {
            return this.modifier;
        }

        public void accept(Visitor v) {
            ((PHPProjectModelVisitor)v).visit(this);
        }
    }

    static class PHPFunctionParameterImp
    extends PHPVariableDataImp
    implements PHPFunctionData.PHPFunctionParameter {
        private boolean isReference;
        private boolean isConst;
        private String classType;
        private String defaultValue;

        private PHPFunctionParameterImp(String name, UserData userData, boolean isReference, boolean isConst, String classType, String defaultValue) {
            super(name, null, userData);
            this.isReference = isReference;
            this.isConst = isConst;
            this.classType = classType;
            this.defaultValue = defaultValue;
        }

        public boolean isReference() {
            return this.isReference;
        }

        public boolean isConst() {
            return this.isConst;
        }

        public String getClassType() {
            return this.classType;
        }

        public void setClassType(String classType) {
            this.classType = classType;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void accept(Visitor v) {
            ((PHPProjectModelVisitor)v).visit(this);
        }
    }

    private static class PHPIncludeFileDataImp
    extends PHPCodeDataImp
    implements PHPIncludeFileData {
        private String includingType;

        private PHPIncludeFileDataImp(String includingType, String name, PHPDocBlock docBlock, UserData userData) {
            super(name, docBlock, userData);
            this.includingType = includingType;
        }

        public void accept(Visitor v) {
            ((PHPProjectModelVisitor)v).visit(this);
        }

        public String getIncludingType() {
            return this.includingType;
        }
    }

    static class PHPInterfaceNameDataImp
    extends PHPCodeDataImp
    implements PHPClassData.PHPInterfaceNameData {
        public PHPInterfaceNameDataImp(String name, UserData userData) {
            super(name, null, userData);
        }

        public void accept(Visitor v) {
            ((PHPProjectModelVisitor)v).visit(this);
        }
    }

    static class PHPKeywordDataImp
    extends PHPCodeDataImp
    implements PHPKeywordData {
        private String suffix;
        private int suffixOffset;

        private PHPKeywordDataImp(String name, String suffix, int suffixOffset) {
            super(name, null, null);
            this.suffix = suffix;
            this.suffixOffset = suffixOffset;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public int getSuffixOffset() {
            return this.suffixOffset;
        }

        public void accept(Visitor v) {
            ((PHPProjectModelVisitor)v).visit(this);
        }
    }

    static class PHPSuperClassNameDataImp
    extends PHPCodeDataImp
    implements PHPClassData.PHPSuperClassNameData {
        public PHPSuperClassNameDataImp(String name, UserData userData) {
            super(name, null, userData);
        }

        public void accept(Visitor v) {
            ((PHPProjectModelVisitor)v).visit(this);
        }
    }

    static class PHPVariableDataImp
    extends PHPCodeDataImp
    implements PHPVariableData {
        private boolean isGlobal;

        public PHPVariableDataImp(String name, PHPDocBlock docBlock, UserData userData) {
            super(name, docBlock, userData);
            this.isGlobal = false;
        }

        public PHPVariableDataImp(String name, boolean isGlobal, PHPDocBlock docBlock, UserData userData) {
            super(name, docBlock, userData);
            this.isGlobal = isGlobal;
        }

        public boolean isGlobal() {
            return this.isGlobal;
        }

        public void accept(Visitor v) {
            ((PHPProjectModelVisitor)v).visit(this);
        }
    }

    static final class UserDataImp
    implements UserData,
    Serializable {
        private String fileName;
        private int startPosition;
        private int endPosition;
        private int stopPosition;
        private int stopLine;

        public UserDataImp(String fileName, int startPosition, int endPosition, int stopPosition, int stopLine) {
            this.fileName = fileName;
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.stopPosition = stopPosition;
            this.stopLine = stopLine;
        }

        public final String getFileName() {
            return this.fileName;
        }

        final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public final int getStartPosition() {
            return this.startPosition;
        }

        final void setStartPosition(int startPosition) {
            this.startPosition = startPosition;
        }

        public final int getEndPosition() {
            return this.endPosition;
        }

        final void setEndPosition(int endPosition) {
            this.endPosition = endPosition;
        }

        public final int getStopPosition() {
            return this.stopPosition;
        }

        final void setStopPosition(int stopPosition) {
            this.stopPosition = stopPosition;
        }

        public final int getStopLine() {
            return this.stopLine;
        }

        final void setStopLine(int stopLine) {
            this.stopLine = stopLine;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UserData)) {
                return false;
            }
            UserData other = (UserData)obj;
            return this.startPosition == other.getStartPosition() && this.endPosition == other.getEndPosition() && this.stopPosition == other.getStopPosition() && this.fileName.equals(other.getFileName());
        }
    }
}

