/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.io.Reader;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.eclipse.php.internal.core.phpModel.parser.PHPParserManager;
import org.eclipse.php.internal.core.phpModel.parser.ParserClient;
import org.eclipse.php.internal.core.phpModel.parser.ParserExecuter;
import org.eclipse.php.internal.core.phpModel.parser.PhpParser;

public class PhpParserSchedulerTask
implements Runnable {
    private volatile boolean threadAlive = true;
    private static final int BUFFER_MAX_SIZE = Integer.MAX_VALUE;
    private final LinkedList<ParserExecuter> buffer = new LinkedList();
    protected static final PhpParserSchedulerTask instance = new PhpParserSchedulerTask();

    private PhpParserSchedulerTask() {
    }

    public static PhpParserSchedulerTask getInstance() {
        return instance;
    }

    public void run() {
        while (this.threadAlive) {
            try {
                ParserExecuter release = this.release();
                assert (release != null);
                Thread.sleep(500L);
                if (this.buffer.size() > 0) {
                    ParserExecuter top = this.buffer.getFirst();
                    if (top.filename.equals(release.filename)) continue;
                }
                release.run();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected synchronized ParserExecuter release() throws InterruptedException {
        while (this.buffer.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ParserExecuter item = this.buffer.removeFirst();
        this.notifyAll();
        return item;
    }

    public synchronized void schedule(PHPParserManager parserManager, PhpParser phpParser, ParserClient client, String filename, Reader reader, Pattern[] tasksPatterns, long lastModified, boolean useAspTagsAsPhp) {
        if (this.buffer.size() > 0) {
            ParserExecuter top = this.buffer.getFirst();
            if (top.filename.equals(filename)) {
                this.buffer.removeFirst();
            }
        }
        while (this.buffer.size() >= Integer.MAX_VALUE) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ParserExecuter parserProperties = new ParserExecuter(parserManager, phpParser, client, filename, reader, tasksPatterns, lastModified, useAspTagsAsPhp);
        this.buffer.addFirst(parserProperties);
        this.notifyAll();
    }
}

