/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableTypeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariablesTypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableContextBuilder {
    private Map<PHPCodeContext, List<PHPVariableData>> contextsToVariables = new HashMap<PHPCodeContext, List<PHPVariableData>>();
    private Map<String, List<PHPVariableTypeData>> variablesInstansiation = new HashMap<String, List<PHPVariableTypeData>>();

    public PHPVariableData addVariable(PHPCodeContext context, String variableName) {
        PHPVariableData variable = this.getVariable(context, variableName = VariableContextBuilder.removeDollar(variableName));
        if (variable != null) {
            return variable;
        }
        List<PHPVariableData> list = this.contextsToVariables.get(context);
        if (list == null) {
            list = new LinkedList<PHPVariableData>();
            this.contextsToVariables.put(context, list);
        }
        variable = PHPCodeDataFactory.createPHPVariableData(variableName, null, null);
        list.add(variable);
        return variable;
    }

    public void addVariable(PHPCodeContext context, PHPVariableData variable) {
        if (this.getVariable(context, variable.getName()) != null) {
            return;
        }
        List<PHPVariableData> list = this.contextsToVariables.get(context);
        if (list == null) {
            list = new LinkedList<PHPVariableData>();
            this.contextsToVariables.put(context, list);
        }
        list.add(variable);
    }

    public void addObjectInstantiation(PHPCodeContext context, String variableName, String objectType, boolean isUserDocumentation, int lineNumber, int position) {
        String variableContext = VariableContextBuilder.createVariableContext(variableName = VariableContextBuilder.removeDollar(variableName), context);
        List<PHPVariableTypeData> list = this.variablesInstansiation.get(variableContext);
        if (list == null) {
            list = new LinkedList<PHPVariableTypeData>();
            this.variablesInstansiation.put(variableContext, list);
        }
        list.add(new VariableTypeDataImp(objectType, lineNumber, position, isUserDocumentation));
    }

    public PHPVariablesTypeManager getPHPVariablesTypeManager() {
        HashMap<PHPCodeContext, Object[]> vars = new HashMap<PHPCodeContext, Object[]>(this.contextsToVariables.size());
        for (Map.Entry<PHPCodeContext, List<PHPVariableData>> next : this.contextsToVariables.entrySet()) {
            PHPCodeContext key = next.getKey();
            List<PHPVariableData> contextList = next.getValue();
            Object[] contextVars = contextList.toArray(new PHPVariableData[contextList.size()]);
            Arrays.sort(contextVars);
            vars.put(key, contextVars);
        }
        return new PHPVariablesTypeManagerImp(vars, this.variablesInstansiation);
    }

    private PHPVariableData getVariable(PHPCodeContext context, String variableName) {
        variableName = VariableContextBuilder.removeDollar(variableName);
        List<PHPVariableData> list = this.contextsToVariables.get(context);
        if (list == null) {
            return null;
        }
        for (PHPVariableData curr : list) {
            if (!curr.getName().equals(variableName)) continue;
            return curr;
        }
        return null;
    }

    public static String createVariableContext(String variabletName, PHPCodeContext context) {
        StringBuilder buffer = new StringBuilder(16);
        buffer.append(variabletName);
        buffer.append(';');
        buffer.append(context.getContainerClassName());
        buffer.append(';');
        buffer.append(context.getContainerFunctionName());
        return buffer.toString();
    }

    private static String removeDollar(String variableName) {
        if (variableName.length() > 0 && variableName.charAt(0) == '$') {
            variableName = variableName.substring(1);
        }
        return variableName;
    }

    public static VariableTypeDataImp createVariableTypeData(String type, int line, int position, boolean isUserDocumentation) {
        return new VariableTypeDataImp(type, line, position, isUserDocumentation);
    }

    public static PHPVariablesTypeManagerImp createPHPVariablesTypeManager(Map<PHPCodeContext, PHPVariableData[]> contextsToVariables, Map<String, List<PHPVariableTypeData>> variablesInstansiation) {
        return new PHPVariablesTypeManagerImp(contextsToVariables, variablesInstansiation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PHPVariablesTypeManagerImp
    implements PHPVariablesTypeManager,
    Serializable {
        private Map<PHPCodeContext, PHPVariableData[]> contextsToVariables;
        private Map<String, List<PHPVariableTypeData>> variablesInstansiation;

        private PHPVariablesTypeManagerImp(Map<PHPCodeContext, PHPVariableData[]> contextsToVariables, Map<String, List<PHPVariableTypeData>> variablesInstansiation) {
            this.contextsToVariables = contextsToVariables;
            this.variablesInstansiation = variablesInstansiation;
        }

        @Override
        public PHPVariableData[] getVariables(PHPCodeContext context) {
            return this.contextsToVariables.get(context);
        }

        @Override
        public PHPVariableData getVariable(PHPCodeContext context, String variableName) {
            variableName = VariableContextBuilder.removeDollar(variableName);
            PHPVariableData[] variables = this.contextsToVariables.get(context);
            if (variables == null) {
                return null;
            }
            PHPVariableData[] pHPVariableDataArray = variables;
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                PHPVariableData variable = pHPVariableDataArray[n2];
                if (variable.getName().equalsIgnoreCase(variableName)) {
                    return variable;
                }
                ++n2;
            }
            return null;
        }

        @Override
        public Map<PHPCodeContext, PHPVariableData[]> getContextsToVariables() {
            return this.contextsToVariables;
        }

        @Override
        public Map<String, List<PHPVariableTypeData>> getVariablesInstansiation() {
            return this.variablesInstansiation;
        }

        @Override
        public PHPVariableTypeData getVariableTypeData(PHPCodeContext context, String variableName, int line) {
            String variablrContext = VariableContextBuilder.createVariableContext(variableName = VariableContextBuilder.removeDollar(variableName), context);
            List<PHPVariableTypeData> list = this.variablesInstansiation.get(variablrContext);
            if (list == null) {
                return null;
            }
            PHPVariableTypeData lastKnowenData = null;
            for (PHPVariableTypeData curr : list) {
                if (curr.getLine() > line) continue;
                if (lastKnowenData == null) {
                    if (curr.getType() != null) {
                        return curr;
                    }
                    lastKnowenData = curr;
                    continue;
                }
                if (curr.getType() == null) continue;
                if (curr.isUserDocumentation()) {
                    return curr;
                }
                return lastKnowenData;
            }
            return lastKnowenData;
        }

        @Override
        public PHPVariableTypeData getVariableTypeDataByPosition(PHPCodeContext context, String variableName, int position) {
            String variablrContext = VariableContextBuilder.createVariableContext(variableName = VariableContextBuilder.removeDollar(variableName), context);
            List<PHPVariableTypeData> list = this.variablesInstansiation.get(variablrContext);
            if (list == null) {
                return null;
            }
            PHPVariableTypeData lastKnowenData = null;
            for (PHPVariableTypeData curr : list) {
                if (curr.getPosition() > position) continue;
                if (lastKnowenData == null) {
                    if (curr.getType() != null) {
                        return curr;
                    }
                    lastKnowenData = curr;
                    continue;
                }
                if (curr.getType() == null) continue;
                if (curr.isUserDocumentation()) {
                    return curr;
                }
                return lastKnowenData;
            }
            return lastKnowenData;
        }
    }

    private static final class VariableTypeDataImp
    implements PHPVariableTypeData {
        private String type;
        private int line;
        private int position;
        private boolean isUserDocumentation;

        VariableTypeDataImp(String type, int line, int position, boolean isUserDocumentation) {
            this.type = type;
            this.line = line;
            this.position = position;
            this.isUserDocumentation = isUserDocumentation;
        }

        public String getType() {
            return this.type;
        }

        public int getLine() {
            return this.line;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean isUserDocumentation() {
            return this.isUserDocumentation;
        }
    }
}

