/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser.management;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.parser.IParserClientFactory;
import org.eclipse.php.internal.core.phpModel.parser.IProjectModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManagerProvider;
import org.eclipse.php.internal.core.phpModel.parser.PHPParserManager;
import org.eclipse.php.internal.core.phpModel.parser.ParserClient;
import org.eclipse.php.internal.core.phpModel.parser.ParserClientComposite;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.TaskPatternsProvider;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionChangedHandler;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.internal.core.project.properties.handlers.UseAspTagsHandler;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;

class ProjectParsingManager
implements IProjectModelListener {
    private Collection parserClientFactoryCollection = new HashSet();
    private PHPParserManager parserManager;
    private IProject project;
    private PhpVersionListener phpVersionListener;

    ProjectParsingManager(IProject project) {
        this.project = project;
        String phpVersion = PhpVersionProjectPropertyHandler.getVersion(project);
        this.setPHPVersion(phpVersion);
        this.phpVersionListener = new PhpVersionListener();
        PhpVersionChangedHandler.getInstance().addPhpVersionChangedListener(this.phpVersionListener);
    }

    private void setPHPVersion(String phpVersion) {
        PHPLanguageManager languageManager = PHPLanguageManagerProvider.instance().getPHPLanguageManager(phpVersion);
        this.parserManager = languageManager.createPHPParserManager();
    }

    public void fileAdded(IFile file) {
        InputStreamReader inputStreamReader;
        File ioFile;
        if (!file.exists() && !(ioFile = new File(file.getFullPath().toOSString())).exists()) {
            return;
        }
        ParserClient parserClient = this.buildParserClient(file, 1);
        if (parserClient == null) {
            return;
        }
        try {
            InputStream is = null;
            if (!file.exists()) {
                try {
                    is = new FileInputStream(file.getFullPath().toOSString());
                }
                catch (IOException iOException) {}
            } else {
                is = file.getContents();
            }
            inputStreamReader = new InputStreamReader(is, file.getCharset());
        }
        catch (CoreException e) {
            PHPCorePlugin.log(e);
            return;
        }
        catch (RuntimeException e) {
            PHPCorePlugin.log(e);
            return;
        }
        catch (UnsupportedEncodingException e) {
            PHPCorePlugin.log(e);
            return;
        }
        Pattern[] tasksPatterns = TaskPatternsProvider.getInstance().getPatternsForProject(file.getProject());
        String fileNameToParse = file.getFullPath().toString();
        if (new File(fileNameToParse).exists()) {
            fileNameToParse = file.getFullPath().toOSString();
        }
        try {
            this.parserManager.parseNow(inputStreamReader, fileNameToParse, file.getModificationStamp(), parserClient, tasksPatterns, UseAspTagsHandler.useAspTagsAsPhp(this.project));
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
            return;
        }
    }

    private ParserClient buildParserClient(IFile file, int fileAdded) {
        ParserClientComposite parserClientComposite = new ParserClientComposite();
        for (IParserClientFactory parserClientFactory : this.parserClientFactoryCollection) {
            if (!parserClientFactory.isParsable(file.getFullPath().toString(), fileAdded)) continue;
            ParserClient parserClient = parserClientFactory.create();
            parserClientComposite.add(parserClient);
        }
        if (parserClientComposite.isEmpty()) {
            return null;
        }
        return parserClientComposite;
    }

    public void fileRemoved(IFile file) {
    }

    public void fileChanged(IFile file, IDocument sDocument) {
        ParserClient parserClient = this.buildParserClient(file, 2);
        if (parserClient == null) {
            return;
        }
        try {
            DocumentReader reader = new DocumentReader(sDocument);
            IProject project = null;
            if (file.exists()) {
                project = file.getProject();
            } else if (ExternalFilesRegistry.getInstance().isEntryExist(file)) {
                project = ExternalFilesRegistry.getInstance().getExternalFilesProject();
            }
            if (project == null) {
                return;
            }
            Pattern[] tasksPatterns = TaskPatternsProvider.getInstance().getPatternsForProject(project);
            String fileToParseName = file.getFullPath().toString();
            if (new File(fileToParseName).exists()) {
                fileToParseName = file.getFullPath().toOSString();
            }
            this.parserManager.parseNow((Reader)reader, fileToParseName, file.getModificationStamp(), parserClient, tasksPatterns, UseAspTagsHandler.useAspTagsAsPhp(project));
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
            return;
        }
    }

    public void addParserClient(IParserClientFactory parserClientFactory) {
        this.parserClientFactoryCollection.add(parserClientFactory);
    }

    public void removeParserClient(IParserClientFactory parserClientFactory) {
        this.parserClientFactoryCollection.remove(parserClientFactory);
    }

    public IProject getProject() {
        return this.project;
    }

    public void dispose() {
        this.parserClientFactoryCollection.clear();
        this.parserClientFactoryCollection = null;
        this.parserManager = null;
        PhpVersionChangedHandler.getInstance().removePhpVersionChangedListener(this.phpVersionListener);
        this.phpVersionListener = null;
        this.project = null;
    }

    private class PhpVersionListener
    implements IPreferencesPropagatorListener {
        private PhpVersionListener() {
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            String newVersion = (String)event.getNewValue();
            ProjectParsingManager.this.setPHPVersion(newVersion);
        }

        public IProject getProject() {
            return ProjectParsingManager.this.project;
        }
    }
}

