/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser.management;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.phpModel.parser.IParserClientFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManagerProvider;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModelManager;
import org.eclipse.php.internal.core.phpModel.parser.ParserClient;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionChangedHandler;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.internal.core.util.project.observer.IProjectClosedObserver;
import org.eclipse.php.internal.core.util.project.observer.ProjectRemovedObserversAttacher;

public class UserModelParserClientFactoryVersionDependent
implements IParserClientFactory {
    private String phpVersion;
    private PhpVersionListener phpVersionListener;
    private Map version2ParserClientMap = new HashMap();
    private PHPUserModelManager userModelManager;
    private IProjectClosedObserver projectChangeObserver;

    public void dispose() {
        Iterator i = this.version2ParserClientMap.values().iterator();
        while (i.hasNext()) {
            ((ParserClient)i.next()).dispose();
        }
    }

    public UserModelParserClientFactoryVersionDependent(PHPUserModelManager userModelManager) {
        this.userModelManager = userModelManager;
        this.phpVersion = PhpVersionProjectPropertyHandler.getVersion(userModelManager.getProject());
        this.initVersionChangeListener();
    }

    private void initVersionChangeListener() {
        this.phpVersionListener = new PhpVersionListener();
        PhpVersionChangedHandler.getInstance().addPhpVersionChangedListener(this.phpVersionListener);
        this.projectChangeObserver = new IProjectClosedObserver(){

            public void closed() {
                PhpVersionChangedHandler.getInstance().removePhpVersionChangedListener(UserModelParserClientFactoryVersionDependent.this.phpVersionListener);
            }
        };
        ProjectRemovedObserversAttacher.getInstance().addProjectClosedObserver(this.userModelManager.getProject(), this.projectChangeObserver);
    }

    public ParserClient create() {
        Object object = this.version2ParserClientMap.get(this.phpVersion);
        if (object == null) {
            PHPLanguageManager languageManager = PHPLanguageManagerProvider.instance().getPHPLanguageManager(this.phpVersion);
            ParserClient parserClient = languageManager.createParserClient(this.userModelManager.getUserModel(), this.userModelManager.getProject());
            this.version2ParserClientMap.put(this.phpVersion, parserClient);
            return parserClient;
        }
        return (ParserClient)object;
    }

    public boolean isParsable(String fileName, int parsingReason) {
        return true;
    }

    private class PhpVersionListener
    implements IPreferencesPropagatorListener {
        private PhpVersionListener() {
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            UserModelParserClientFactoryVersionDependent.this.phpVersion = (String)event.getNewValue();
        }

        public IProject getProject() {
            return UserModelParserClientFactoryVersionDependent.this.userModelManager.getProject();
        }
    }
}

