/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.documentModel.markers.MarkerContributor;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;

public class FullPhpProjectBuildVisitor
implements IResourceVisitor {
    private IProgressMonitor monitor;
    private MarkerContributor validator = MarkerContributor.getInstance();

    public FullPhpProjectBuildVisitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public boolean visit(IResource resource) {
        if (this.monitor.isCanceled()) {
            return false;
        }
        if (resource.getType() == 1) {
            this.handle((IFile)resource);
            return false;
        }
        if (resource.getType() == 4) {
            return this.handle((IProject)resource);
        }
        return true;
    }

    private boolean handle(IProject project) {
        if (PHPWorkspaceModelManager.getInstance().getModelForProject(project, true) == null) {
            return false;
        }
        PHPProjectOptions projectOptions = PHPProjectOptions.forProject(project);
        projectOptions.validateIncludePath();
        return true;
    }

    private void handle(IFile file) {
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!PHPModelUtil.isPhpFile(file)) {
            this.monitor.worked(1);
            return;
        }
        this.monitor.subTask(NLS.bind((String)CoreMessages.getString("FullPhpProjectBuildVisitor_0"), (Object)file.getFullPath().toPortableString()));
        PHPWorkspaceModelManager.getInstance().addFileToModel(file);
        this.validator.markFile(file);
        this.monitor.worked(1);
    }
}

