/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.php.core.project.build.IPHPBuilderExtension;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.project.build.PHPBuilderExtensionsRegistry;
import org.eclipse.php.internal.core.project.build.RSEFolderReporter;

public class PHPIncrementalProjectBuilder
extends IncrementalProjectBuilder {
    private IPHPBuilderExtension[] extensions = PHPBuilderExtensionsRegistry.getInstance().getExtensions();

    protected IProject[] build(final int kind, final Map args, IProgressMonitor monitor) throws CoreException {
        final IProject project = this.getProject();
        final IResourceDelta delta = this.getDelta(project);
        if (kind == 9) {
            RSEFolderReporter visitor = new RSEFolderReporter();
            try {
                delta.accept((IResourceDeltaVisitor)visitor);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
            if (visitor.isNewJobNeeded()) {
                WorkspaceJob j = new WorkspaceJob("Building PHP projects"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        PHPIncrementalProjectBuilder.this.internalBuild(project, delta, kind, args, monitor);
                        return Status.OK_STATUS;
                    }
                };
                j.setPriority(30);
                j.setUser(false);
                j.schedule();
                return null;
            }
        }
        return this.internalBuild(project, delta, kind, args, monitor);
    }

    private IProject[] internalBuild(IProject project, IResourceDelta delta, int kind, Map args, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CoreMessages.getString("PHPIncrementalProjectBuilder_0"), this.extensions.length);
        int numOfFiles = 1;
        if (delta != null) {
            FileCounter fc = new FileCounter();
            delta.accept((IResourceDeltaVisitor)fc);
            numOfFiles = fc.numOfFiles;
        }
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].isEnabled()) {
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                subMonitor.beginTask(project.getName(), numOfFiles);
                this.extensions[i].build(project, delta, kind, args, (IProgressMonitor)subMonitor);
            }
            ++i;
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].isEnabled()) {
                this.extensions[i].clean(this.getProject(), monitor);
            }
            ++i;
        }
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
        int i = 0;
        while (i < this.extensions.length) {
            this.extensions[i].startupOnInitialize(this);
            ++i;
        }
    }

    class FileCounter
    implements IResourceDeltaVisitor {
        public int numOfFiles = 0;

        FileCounter() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta.getResource().getType() == 1) {
                ++this.numOfFiles;
                return false;
            }
            return true;
        }
    }
}

