/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.project.build.RSEFolderReporter;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.InternalValidatorManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.EnabledIncrementalValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.EnabledValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.ValidationBuilder;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class ValidationManagerWrapper
extends ValidationBuilder {
    public IProject[] build(final int kind, final Map args, IProgressMonitor monitor) {
        if (kind == 9) {
            final IResourceDelta delta = this.getDelta(this.getProject());
            RSEFolderReporter visitor = new RSEFolderReporter();
            try {
                delta.accept((IResourceDeltaVisitor)visitor);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
            if (visitor.isNewJobNeeded()) {
                WorkspaceJob j = new WorkspaceJob("Validating"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        ValidationManagerWrapper.this.innerBuild(kind, args, monitor, delta);
                        return Status.OK_STATUS;
                    }
                };
                j.setPriority(30);
                j.setUser(false);
                j.schedule();
                return null;
            }
        }
        return super.build(kind, args, monitor);
    }

    private IProject[] innerBuild(int kind, Map parameters, IProgressMonitor monitor, IResourceDelta delta) {
        System.currentTimeMillis();
        int executionMap = 0;
        IProject project = this.getProject();
        IProject[] referenced = this.getAllReferencedProjects(project, null);
        try {
            boolean doFullBuild;
            if (ValidatorManager.getManager().isSuspended(project)) {
                executionMap |= 1;
                IProject[] iProjectArray = referenced;
                return iProjectArray;
            }
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            boolean bl = doFullBuild = kind == 6;
            if (!doFullBuild && delta == null) {
                if (this.isReferencedProjectInDelta(referenced)) {
                    this.performFullBuildForReferencedProjectChanged(monitor, prjp);
                } else {
                    String[] msgParms = new String[]{project.getName()};
                    monitor.subTask(ResourceHandler.getExternalizedMessage((String)"VBF_STATUS_NULL_DELTA", (String[])msgParms));
                    executionMap |= 4;
                }
                IProject[] iProjectArray = referenced;
                return iProjectArray;
            }
            if (doFullBuild) {
                this.performFullBuild(monitor, prjp);
            } else {
                if (delta.getAffectedChildren().length == 0) {
                    if (this.isReferencedProjectInDelta(referenced)) {
                        this.performFullBuildForReferencedProjectChanged(monitor, prjp);
                    } else {
                        executionMap |= 0x10;
                    }
                    IProject[] iProjectArray = referenced;
                    return iProjectArray;
                }
                EnabledIncrementalValidatorsOperation operation = new EnabledIncrementalValidatorsOperation(project, delta, true);
                operation.run(monitor);
            }
            IProject[] iProjectArray = referenced;
            return iProjectArray;
        }
        catch (InvocationTargetException exc) {
            ValidationPlugin.getPlugin().handleException((Throwable)exc);
            executionMap |= 0x20;
            IProject[] iProjectArray = referenced;
            return iProjectArray;
        }
        catch (Exception exc) {
            ValidationPlugin.getPlugin().handleException((Throwable)exc);
            executionMap |= 0x40;
            IProject[] iProjectArray = referenced;
            return iProjectArray;
        }
        finally {
            this.referencedProjects = null;
        }
    }

    private IProject[] getAllReferencedProjects(IProject project, Set visitedProjects) {
        if (visitedProjects == null) {
            visitedProjects = new HashSet<IProject>();
        } else {
            if (visitedProjects.contains(project)) {
                return this.getReferencedProjects();
            }
            visitedProjects.add(project);
        }
        if (this.referencedProjects == null) {
            this.referencedProjects = new ArrayList();
        }
        try {
            if (project.isAccessible()) {
                IProject[] refProjArray = project.getReferencedProjects();
                this.collectReferecedProject(refProjArray);
                int i = 0;
                while (i < refProjArray.length) {
                    IProject refProject = refProjArray[i];
                    this.getAllReferencedProjects(refProject, visitedProjects);
                    ++i;
                }
            }
            return this.getReferencedProjects();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private void collectReferecedProject(IProject[] refProjArray) {
        int i = 0;
        while (i < refProjArray.length) {
            IProject project = refProjArray[i];
            if (!this.referencedProjects.contains(project)) {
                this.referencedProjects.add(project);
            }
            ++i;
        }
    }

    private IProject[] getReferencedProjects() {
        IProject[] refProjArray = new IProject[this.referencedProjects.size()];
        int i = 0;
        while (i < this.referencedProjects.size()) {
            refProjArray[i] = (IProject)this.referencedProjects.get(i);
            ++i;
        }
        return refProjArray;
    }

    private boolean isReferencedProjectInDelta(IProject[] referenced) {
        IProject p = null;
        int i = 0;
        while (i < referenced.length) {
            p = referenced[i];
            IResourceDelta delta = this.getDelta(p);
            if (delta != null && delta.getAffectedChildren().length > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void performFullBuildForReferencedProjectChanged(IProgressMonitor monitor, ProjectConfiguration prjp) throws InvocationTargetException {
        this.performFullBuild(monitor, prjp, true);
    }

    private void performFullBuild(IProgressMonitor monitor, ProjectConfiguration prjp) throws InvocationTargetException {
        this.performFullBuild(monitor, prjp, false);
    }

    private void performFullBuild(IProgressMonitor monitor, ProjectConfiguration prjp, boolean onlyDependentValidators) throws InvocationTargetException {
        ValidatorMetaData[] enabledValidators = prjp.getEnabledFullBuildValidators(true, onlyDependentValidators);
        if (enabledValidators != null && enabledValidators.length > 0) {
            Set enabledValidatorsSet = InternalValidatorManager.wrapInSet((ValidatorMetaData[])enabledValidators);
            EnabledValidatorsOperation op = new EnabledValidatorsOperation(this.getProject(), enabledValidatorsSet, true){};
            op.run(monitor);
        }
    }
}

