/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.options;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.internal.resources.XMLWriter;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.IncludePathContainerInitializer;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.project.IIncludePathContainer;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.PHPNature;
import org.eclipse.php.internal.core.project.options.IPhpProjectOptionChangeListener;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathEntry;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.core.util.FileUtils;
import org.eclipse.php.internal.core.util.project.observer.IProjectClosedObserver;
import org.eclipse.php.internal.core.util.project.observer.ProjectRemovedObserversAttacher;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PHPProjectOptions {
    private static final String LOCATION_INCLUDE_PATH = "Include Path";
    private static final String OWNER_PHP_INCLUDE_PATH = "phpIncludePath";
    private static final String OWNER_ATTRIBUTE = "Owner";
    public static final String BUILDER_ID = "org.eclipse.php.core.PhpIncrementalProjectBuilder";
    static final IIncludePathEntry[] EMPTY_INCLUDEPATH = new IIncludePathEntry[0];
    private static final String PREF_QUALIFIER = "org.eclipse.php.core.projectOptions";
    private static final String OLD_FILE_NAME = ".projectOptions";
    private static final String TAG_OPTION = "projectOption";
    private static final String TAG_OPTIONS = "phpProjectOptions";
    public static final String USER_LIBRARY_CONTAINER_ID = "org.eclipse.php.USER_LIBRARY";
    private ILock includePathEntriesLock = Job.getJobManager().newLock();
    private IIncludePathEntry[] includePathEntries = null;
    private final Map<String, List<IPhpProjectOptionChangeListener>> optionsChangeListenersMap = new HashMap<String, List<IPhpProjectOptionChangeListener>>();
    private IProject project;

    public static PHPProjectOptions forProject(IProject project) {
        if (!project.exists() || !project.isAccessible()) {
            return null;
        }
        PHPNature nature = null;
        try {
            nature = (PHPNature)project.getNature("org.eclipse.php.core.PHPNature");
        }
        catch (CoreException e) {
            PHPCorePlugin.log(e);
        }
        if (nature != null) {
            return nature.getOptions();
        }
        return null;
    }

    public static IIncludePathContainer getIncludePathContainer(IPath path, IProject project2) {
        return null;
    }

    public static IncludePathContainerInitializer getIncludePathContainerInitializer(String string) {
        return null;
    }

    public static IPath getIncludePathVariable(String variableName) {
        return IncludePathVariableManager.instance().getIncludePathVariable(variableName);
    }

    public static String[] getIncludePathVariableNames() {
        return IncludePathVariableManager.instance().getIncludePathVariableNames();
    }

    public static IPath getResolvedVariablePath(IPath path) {
        return IncludePathVariableManager.instance().getIncludePathVariable(path.toString());
    }

    public static void setIncludePathVariables(String[] names, IPath[] paths, SubProgressMonitor monitor) {
        IncludePathVariableManager.instance().setIncludePathVariables(names, paths, monitor);
    }

    public PHPProjectOptions(IProject project) {
        this.project = project;
        ProjectRemovedObserversAttacher.getInstance().addProjectClosedObserver(project, new IProjectClosedObserver(){

            public void closed() {
                PHPProjectOptions.this.optionsChangeListenersMap.clear();
            }
        });
    }

    private void ensureIncludePathRead() {
        this.includePathEntriesLock.acquire();
        try {
            if (this.includePathEntries != null) {
                return;
            }
            this.loadIncludePath();
            this.loadOldConfiguration();
        }
        finally {
            this.includePathEntriesLock.release();
        }
    }

    public void addOptionChangeListener(String optionKey, IPhpProjectOptionChangeListener optionChangeListener) {
        List<IPhpProjectOptionChangeListener> optionChangeListeners = this.optionsChangeListenersMap.get(optionKey);
        if (optionChangeListeners == null) {
            optionChangeListeners = new ArrayList<IPhpProjectOptionChangeListener>();
            this.optionsChangeListenersMap.put(optionKey, optionChangeListeners);
        }
        if (!optionChangeListeners.contains(optionChangeListener)) {
            optionChangeListeners.add(optionChangeListener);
        }
    }

    public void removeOptionChangeListener(String optionKey, IPhpProjectOptionChangeListener optionChangeListener) {
        List<IPhpProjectOptionChangeListener> optionChangeListeners = this.optionsChangeListenersMap.get(optionKey);
        if (optionChangeListeners != null) {
            optionChangeListeners.remove(optionChangeListener);
        }
    }

    public void notifyOptionChangeListeners(String key, Object oldValue, Object newValue) {
        List<IPhpProjectOptionChangeListener> optionChangeListeners = this.optionsChangeListenersMap.get(key);
        if (optionChangeListeners == null) {
            return;
        }
        for (IPhpProjectOptionChangeListener phpProjectOptionChangeListener : optionChangeListeners) {
            phpProjectOptionChangeListener.notifyOptionChanged(oldValue, newValue);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public Object getOption(String key) {
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences preferences = projectScope.getNode(PREF_QUALIFIER);
        return preferences.get(key, null);
    }

    public void setOption(String key, Object value) {
        Object oldValue = this.getOption(key);
        if (oldValue != null ? value != null && value.equals(oldValue) : value == null) {
            return;
        }
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences preferences = projectScope.getNode(PREF_QUALIFIER);
        preferences.put(key, value.toString());
        this.flushPrefs();
        this.notifyOptionChangeListeners(key, oldValue, value);
    }

    public Object removeOption(String key) {
        Object object = this.getOption(key);
        if (object != null) {
            ProjectScope projectScope = new ProjectScope(this.project);
            IEclipsePreferences preferences = projectScope.getNode(PREF_QUALIFIER);
            preferences.remove(key);
            this.flushPrefs();
        }
        return object;
    }

    private void flushPrefs() {
        try {
            ProjectScope projectScope = new ProjectScope(this.project);
            IEclipsePreferences preferences = projectScope.getNode(PREF_QUALIFIER);
            preferences.flush();
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
    }

    public Object removeOptionNotify(String key) {
        Object object = this.removeOption(key);
        this.notifyOptionChangeListeners(key, object, null);
        return object;
    }

    public void modifyIncludePathEntry(IIncludePathEntry newEntry, IProject jproject, IPath containerPath, IProgressMonitor monitor) {
        throw new RuntimeException("implement me");
    }

    public IIncludePathEntry[] readRawIncludePath() {
        this.ensureIncludePathRead();
        return this.includePathEntries == null ? EMPTY_INCLUDEPATH : this.includePathEntries;
    }

    public void removeResourceFromIncludePath(IResource resource) {
        this.ensureIncludePathRead();
        if (this.includePathEntries == null || this.includePathEntries.length == 0) {
            return;
        }
        ArrayList<IIncludePathEntry> newIncludePathEntries = new ArrayList<IIncludePathEntry>(this.includePathEntries.length);
        int i = 0;
        while (i < this.includePathEntries.length) {
            if (this.includePathEntries[i].getResource() != resource) {
                newIncludePathEntries.add(this.includePathEntries[i]);
            }
            ++i;
        }
        try {
            this.setRawIncludePath(newIncludePathEntries.toArray(new IIncludePathEntry[newIncludePathEntries.size()]), null);
            return;
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
            return;
        }
    }

    public void renameResourceAtIncludePath(IResource from, IResource to) {
        this.ensureIncludePathRead();
        if (this.includePathEntries == null || this.includePathEntries.length == 0) {
            return;
        }
        ArrayList<IIncludePathEntry> newIncludePathEntries = new ArrayList<IIncludePathEntry>(this.includePathEntries.length);
        int i = 0;
        while (i < this.includePathEntries.length) {
            if (this.includePathEntries[i].getResource() == from) {
                IIncludePathEntry newSourceEntry = IncludePathEntry.newProjectEntry(to.getFullPath(), to, false);
                newIncludePathEntries.add(newSourceEntry);
            } else {
                newIncludePathEntries.add(this.includePathEntries[i]);
            }
            ++i;
        }
        try {
            this.setRawIncludePath(newIncludePathEntries.toArray(new IIncludePathEntry[newIncludePathEntries.size()]), null);
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
        }
    }

    public void setRawIncludePath(IIncludePathEntry[] newIncludePathEntries, SubProgressMonitor subProgressMonitor) {
        this.ensureIncludePathRead();
        IIncludePathEntry[] oldValue = this.includePathEntries == null ? EMPTY_INCLUDEPATH : this.includePathEntries;
        this.includePathEntries = newIncludePathEntries;
        IncludePathEntry.updateProjectReferences(this.includePathEntries, oldValue, this.project, subProgressMonitor);
        this.saveIncludePath();
        this.notifyOptionChangeListeners("org.eclipse.php.core.includePath", oldValue, newIncludePathEntries);
    }

    private void saveIncludePath() {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            XMLWriter xmlWriter = new XMLWriter((OutputStream)s);
            xmlWriter.startTag("includepath", null);
            IIncludePathEntry[] entries = this.includePathEntries == null ? EMPTY_INCLUDEPATH : this.includePathEntries;
            int i = 0;
            while (i < entries.length) {
                ((IncludePathEntry)entries[i]).elementEncode(xmlWriter, this.project.getFullPath(), true);
                ++i;
            }
            xmlWriter.endTag("includepath");
            xmlWriter.flush();
            xmlWriter.close();
            ProjectScope projectScope = new ProjectScope(this.project);
            IEclipsePreferences preferences = projectScope.getNode(PREF_QUALIFIER);
            preferences.put("org.eclipse.php.core.includePath", new String(s.toByteArray()));
            this.flushPrefs();
            this.validateIncludePath();
        }
        catch (IOException e) {
            PHPCorePlugin.log(e);
        }
    }

    private void loadIncludePath() {
        try {
            Element cpElement;
            ProjectScope projectScope = new ProjectScope(this.project);
            IEclipsePreferences preferences = projectScope.getNode(PREF_QUALIFIER);
            String includePathXml = preferences.get("org.eclipse.php.core.includePath", null);
            if (includePathXml == null) {
                block19: {
                    URI location = this.project.getFile(new Path(".settings").append(PREF_QUALIFIER).addFileExtension("prefs")).getLocationURI();
                    if (location != null) {
                        try {
                            File file = FileUtils.toLocalFile(location, null);
                            BufferedInputStream input = null;
                            try {
                                try {
                                    input = new BufferedInputStream(new FileInputStream(file));
                                    Properties result = new Properties();
                                    result.load(input);
                                    includePathXml = result.getProperty("org.eclipse.php.core.includePath");
                                }
                                catch (Exception exception) {
                                    FileUtil.safeClose(input);
                                    break block19;
                                }
                            }
                            catch (Throwable throwable) {
                                FileUtil.safeClose(input);
                                throw throwable;
                            }
                            FileUtil.safeClose((InputStream)input);
                        }
                        catch (CoreException coreException) {}
                    }
                }
                if (includePathXml == null) {
                    return;
                }
            }
            StringReader reader = new StringReader(includePathXml);
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
                }
                catch (Exception exception) {
                    throw new IOException(CoreMessages.getString("PHPProjectOptions_1"));
                }
            }
            finally {
                ((Reader)reader).close();
            }
            ArrayList<IIncludePathEntry> paths = new ArrayList<IIncludePathEntry>();
            NodeList list = cpElement.getElementsByTagName("includepathentry");
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.getNodeType() == 1) {
                    IIncludePathEntry entry = IncludePathEntry.elementDecode((Element)node, this);
                    paths.add(entry);
                }
                ++i;
            }
            int pathSize = paths.size();
            this.includePathEntries = new IIncludePathEntry[pathSize];
            paths.toArray(this.includePathEntries);
        }
        catch (IOException e) {
            PHPCorePlugin.log(e);
        }
    }

    private void loadOldConfiguration() {
        IFile optionsFile = this.project.getFile(OLD_FILE_NAME);
        if (!optionsFile.exists()) {
            return;
        }
        ArrayList<IIncludePathEntry> paths = new ArrayList<IIncludePathEntry>();
        try {
            Element cpElement;
            InputStreamReader reader = new InputStreamReader(optionsFile.getContents());
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
                }
                catch (Exception exception) {
                    throw new IOException(CoreMessages.getString("PHPProjectOptions_1"));
                }
            }
            finally {
                ((Reader)reader).close();
            }
            if (!cpElement.getNodeName().equalsIgnoreCase(TAG_OPTIONS)) {
                throw new IOException(CoreMessages.getString("PHPProjectOptions_1"));
            }
            NodeList list = cpElement.getElementsByTagName(TAG_OPTION);
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                Element element = (Element)list.item(i);
                String key = element.getAttribute("name");
                String value = element.getFirstChild().getNodeValue().trim();
                ProjectScope projectScope = new ProjectScope(this.project);
                IEclipsePreferences preferences = projectScope.getNode(PREF_QUALIFIER);
                preferences.put(key, value);
                ++i;
            }
            list = cpElement.getElementsByTagName("includepath");
            if (list.getLength() > 0) {
                Element includePathElement = (Element)list.item(0);
                list = includePathElement.getElementsByTagName("includepathentry");
                length = list.getLength();
                int i2 = 0;
                while (i2 < length) {
                    Node node = list.item(i2);
                    if (node.getNodeType() == 1) {
                        IIncludePathEntry entry = IncludePathEntry.elementDecode((Element)node, this);
                        paths.add(entry);
                    }
                    ++i2;
                }
                int pathSize = paths.size();
                this.includePathEntries = new IIncludePathEntry[pathSize];
                paths.toArray(this.includePathEntries);
            }
            this.saveIncludePath();
            optionsFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            PHPCorePlugin.log(e);
        }
        catch (CoreException e) {
            PHPCorePlugin.log(e);
        }
    }

    public void validateIncludePath() {
        this.ensureIncludePathRead();
        if (this.includePathEntries == null || this.includePathEntries.length == 0) {
            return;
        }
        this.clearMarkers();
        IIncludePathEntry[] iIncludePathEntryArray = this.includePathEntries;
        int n = this.includePathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IIncludePathEntry element = iIncludePathEntryArray[n2];
            String message = element.validate();
            if (message != null) {
                this.addError(message);
            }
            ++n2;
        }
    }

    private void addError(String message) {
        try {
            IMarker marker = this.project.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("location", (Object)LOCATION_INCLUDE_PATH);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("priority", 2);
            marker.setAttribute("severity", 1);
            marker.setAttribute(OWNER_ATTRIBUTE, (Object)OWNER_PHP_INCLUDE_PATH);
        }
        catch (CoreException coreException) {}
    }

    private void clearMarkers() {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.project.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker element = iMarkerArray[n2];
                if (OWNER_PHP_INCLUDE_PATH.equals(element.getAttribute(OWNER_ATTRIBUTE))) {
                    element.delete();
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }
}

