/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.options.includepath;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.resources.XMLWriter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathEntryDescriptor;
import org.eclipse.php.internal.core.util.preferences.Key;
import org.eclipse.php.internal.core.util.preferences.XMLPreferencesReader;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.w3c.dom.Element;

public class IncludePathEntry
implements IIncludePathEntry {
    public static final String TAG_INCLUDEPATH = "includepath";
    public static final String TAG_INCLUDEPATHENTRY = "includepathentry";
    public static final String TAG_ENTRY_KIND = "kind";
    public static final String TAG_CONTENT_KIND = "contentKind";
    public static final String TAG_PATH = "path";
    public static final String TAG_RESOURCE = "resource";
    public static final String TAG_ROOTPATH = "rootpath";
    public static final String TAG_EXPORTED = "exported";
    public static final String TAG_CREATEDREFERENCE = "createdReference";
    public int entryKind;
    public int contentKind;
    public IPath path;
    public IResource resource;
    public boolean isExported;
    private boolean createdReference;

    public IncludePathEntry(int contentKind, int entryKind, IPath path, IResource resource, boolean isExported) {
        this.contentKind = contentKind;
        this.entryKind = entryKind;
        this.path = path;
        this.resource = resource;
        this.isExported = isExported;
    }

    public static List getIncludePathEntriesFromPreferences(Key preferenceKey, IProject project, ProjectScope projectScope, IWorkingCopyManager workingCopyManager) {
        ArrayList<IIncludePathEntry> entries = new ArrayList<IIncludePathEntry>();
        HashMap[] maps = XMLPreferencesReader.read(preferenceKey, projectScope, workingCopyManager);
        if (maps.length > 0) {
            int entryCount = 0;
            while (entryCount < maps.length) {
                IncludePathEntryDescriptor descriptor = new IncludePathEntryDescriptor();
                descriptor.restoreFromMap(maps[entryCount]);
                entries.add(IncludePathEntry.elementDecode(descriptor, project.getFullPath()));
                ++entryCount;
            }
        }
        return entries;
    }

    public static List getIncludePathEntriesFromPreferences(String entriesString, IProject project) {
        ArrayList<IIncludePathEntry> entries = new ArrayList<IIncludePathEntry>();
        HashMap[] maps = XMLPreferencesReader.getHashFromStoredValue(entriesString);
        if (maps.length > 0) {
            int entryCount = 0;
            while (entryCount < maps.length) {
                IncludePathEntryDescriptor descriptor = new IncludePathEntryDescriptor();
                descriptor.restoreFromMap(maps[entryCount]);
                entries.add(IncludePathEntry.elementDecode(descriptor, project.getFullPath()));
                ++entryCount;
            }
        }
        return entries;
    }

    public int getContentKind() {
        return this.contentKind;
    }

    public int getEntryKind() {
        return this.entryKind;
    }

    public IPath getPath() {
        return this.path;
    }

    public IResource getResource() {
        return this.resource;
    }

    public boolean isExported() {
        return this.isExported;
    }

    public static IIncludePathEntry elementDecode(Element element, PHPProjectOptions options) {
        IPath projectPath = options.getProject().getFullPath();
        String entryKindAttr = element.getAttribute(TAG_ENTRY_KIND);
        String contentKindAttr = element.getAttribute(TAG_CONTENT_KIND);
        String pathAttr = element.getAttribute(TAG_PATH);
        String resourceAttr = element.getAttribute(TAG_RESOURCE);
        boolean isExported = element.getAttribute(TAG_EXPORTED).equals("true");
        IIncludePathEntry entry = IncludePathEntry.getEntry(pathAttr, entryKindAttr, contentKindAttr, resourceAttr, isExported, projectPath);
        return entry;
    }

    public static IIncludePathEntry elementDecode(IncludePathEntryDescriptor descriptor, IPath projectPath) {
        IIncludePathEntry entry = IncludePathEntry.getEntry(descriptor.getPath(), descriptor.getEntryKind(), descriptor.getContentKind(), descriptor.getResourceName(), descriptor.isExported(), projectPath);
        return entry;
    }

    public static IIncludePathEntry getEntry(String sPath, String sEntryKind, String sContentKind, String sResource, boolean isExported, IPath projectPath) {
        Path path = new Path(sPath);
        int entryKind = IncludePathEntry.entryKindFromString(sEntryKind);
        if (entryKind != 4 && entryKind != 5 && !path.isAbsolute()) {
            path = projectPath.append((IPath)path);
        }
        IProject resource = null;
        IIncludePathEntry entry = null;
        switch (entryKind) {
            case 2: {
                try {
                    resource = ResourcesPlugin.getWorkspace().getRoot().getProject(sResource);
                }
                catch (Exception exception) {}
                entry = IncludePathEntry.newProjectEntry((IPath)path, (IResource)resource, isExported);
                break;
            }
            case 1: 
            case 6: {
                entry = new IncludePathEntry(IncludePathEntry.contentKindFromString(sContentKind), 1, (IPath)path, (IResource)resource, isExported);
                break;
            }
            case 3: {
                entry = IncludePathEntry.newSourceEntry((IPath)path, resource);
                break;
            }
            case 4: {
                entry = IncludePathEntry.newVariableEntry((IPath)path, resource, isExported);
                break;
            }
            case 5: {
                entry = IncludePathEntry.newContainerEntry((IPath)path, resource, isExported);
                break;
            }
            default: {
                throw new AssertionError((Object)NLS.bind((String)CoreMessages.getString("includePath_unknownKind"), (Object)sEntryKind));
            }
        }
        return entry;
    }

    public static IIncludePathEntry newProjectEntry(IPath path, IResource resource, boolean isExported) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path for IIncludePathEntry must be absolute");
        }
        return new IncludePathEntry(1, 2, path, resource, isExported);
    }

    public static IIncludePathEntry newContainerEntry(IPath containerPath, IResource containerResource, boolean isExported) {
        if (containerPath == null) {
            throw new IllegalArgumentException("Container path cannot be null");
        }
        if (containerPath.segmentCount() < 1) {
            throw new IllegalArgumentException("Illegal include path container path: '" + containerPath.makeRelative().toString() + "', must have at least one segment (containerID+hints)");
        }
        return new IncludePathEntry(1, 5, containerPath, containerResource, isExported);
    }

    public static IIncludePathEntry newVariableEntry(IPath variablePath, IResource variableResource, boolean isExported) {
        if (variablePath == null) {
            throw new IllegalArgumentException("Variable path cannot be null");
        }
        if (variablePath.segmentCount() < 1) {
            throw new IllegalArgumentException("Illegal classpath variable path: '" + variablePath.makeRelative().toString() + "', must have at least one segment");
        }
        return new IncludePathEntry(1, 4, variablePath, variableResource, isExported);
    }

    public static IIncludePathEntry newSourceEntry(IPath path, IResource resource) {
        if (path == null) {
            throw new IllegalArgumentException("Source path cannot be null");
        }
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path for IIncludePathEntry must be absolute");
        }
        return new IncludePathEntry(1, 3, path, resource, false);
    }

    public void elementEncode(XMLWriter writer, IPath projectPath, boolean newLine) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(TAG_ENTRY_KIND, IncludePathEntry.entryKindToString(this.entryKind));
        parameters.put(TAG_CONTENT_KIND, IncludePathEntry.contentKindToString(this.contentKind));
        parameters.put(TAG_CREATEDREFERENCE, this.createdReference ? "true" : "false");
        IPath xmlPath = this.path;
        if (this.entryKind != 4 && this.entryKind != 5 && projectPath != null && projectPath.isPrefixOf(xmlPath)) {
            if (xmlPath.segment(0).equals(projectPath.segment(0))) {
                xmlPath = xmlPath.removeFirstSegments(1);
                xmlPath = xmlPath.makeRelative();
            } else {
                xmlPath = xmlPath.makeAbsolute();
            }
        }
        parameters.put(TAG_PATH, String.valueOf(xmlPath));
        if (this.resource != null) {
            parameters.put(TAG_RESOURCE, this.resource.getName());
        }
        if (this.isExported) {
            parameters.put(TAG_EXPORTED, "true");
        }
        writer.printTag(TAG_INCLUDEPATHENTRY, parameters);
        writer.endTag(TAG_INCLUDEPATHENTRY);
    }

    public String elementEncode(IPath projectPath) {
        IncludePathEntryDescriptor descriptor = new IncludePathEntryDescriptor(this, projectPath);
        return descriptor.toString();
    }

    public static void updateProjectReferences(IIncludePathEntry[] newEntries, IIncludePathEntry[] oldEntries, final IProject project, SubProgressMonitor monitor) {
        try {
            String projectName;
            boolean changedReferences = false;
            final IProjectDescription projectDescription = project.getDescription();
            ArrayList<IProject> referenced = new ArrayList<IProject>();
            ArrayList<String> referencedNames = new ArrayList<String>();
            IProject[] referencedProjects = projectDescription.getReferencedProjects();
            int i = 0;
            while (i < referencedProjects.length) {
                referenced.add(referencedProjects[i]);
                referencedNames.add(referencedProjects[i].getName());
                ++i;
            }
            i = 0;
            while (i < oldEntries.length) {
                int index;
                if (oldEntries[i].getEntryKind() == 2 && !IncludePathEntry.containsProject(newEntries, projectName = oldEntries[i].getPath().lastSegment()) && ((IncludePathEntry)oldEntries[i]).createdReference && (index = referencedNames.indexOf(projectName)) >= 0) {
                    changedReferences = true;
                    referencedNames.remove(index);
                    referenced.remove(index);
                }
                ++i;
            }
            i = 0;
            while (i < newEntries.length) {
                if (newEntries[i].getEntryKind() == 2 && !IncludePathEntry.containsProject(oldEntries, projectName = newEntries[i].getPath().lastSegment()) && !referencedNames.contains(projectName)) {
                    changedReferences = true;
                    ((IncludePathEntry)newEntries[i]).createdReference = true;
                    referenced.add(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
                    referencedNames.add(projectName);
                }
                ++i;
            }
            if (changedReferences) {
                IProject[] referenceProjects = referenced.toArray(new IProject[referenced.size()]);
                projectDescription.setReferencedProjects(referenceProjects);
                WorkspaceJob job = new WorkspaceJob(CoreMessages.getString("IncludePathEntry_2")){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        project.setDescription(projectDescription, monitor);
                        return Status.OK_STATUS;
                    }
                };
                job.setRule((ISchedulingRule)project.getParent());
                job.schedule();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static boolean containsProject(IIncludePathEntry[] entries, String projectName) {
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 2 && entries[i].getPath().lastSegment().equals(projectName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static int entryKindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("prj")) {
            return 2;
        }
        if (kindStr.equalsIgnoreCase("var")) {
            return 4;
        }
        if (kindStr.equalsIgnoreCase("con")) {
            return 5;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 3;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        if (kindStr.equalsIgnoreCase("jre")) {
            return 6;
        }
        return -1;
    }

    static String entryKindToString(int kind) {
        switch (kind) {
            case 2: {
                return "prj";
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 6: {
                return "jre";
            }
            case 4: {
                return "var";
            }
            case 5: {
                return "con";
            }
        }
        return "unknown";
    }

    static int contentKindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("binary")) {
            return 2;
        }
        if (kindStr.equalsIgnoreCase("source")) {
            return 1;
        }
        return -1;
    }

    static String contentKindToString(int kind) {
        switch (kind) {
            case 2: {
                return "binary";
            }
            case 1: {
                return "source";
            }
        }
        return "unknown";
    }

    public String validate() {
        String message = null;
        switch (this.entryKind) {
            case 2: {
                if (this.resource != null && this.resource.exists()) break;
                message = String.valueOf(CoreMessages.getString("IncludePathEntry_4")) + this.path.toOSString();
                break;
            }
            case 1: 
            case 6: {
                File file;
                if (this.resource != null && this.resource.exists() || (file = new File(this.path.toOSString())).exists()) break;
                message = String.valueOf(CoreMessages.getString("IncludePathEntry_5")) + this.path.toOSString();
                break;
            }
            case 3: {
                if (this.resource != null && this.resource.exists()) break;
                message = String.valueOf(CoreMessages.getString("IncludePathEntry_6")) + this.path.toOSString();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new AssertionError((Object)NLS.bind((String)CoreMessages.getString("includePath_unknownKind"), (Object)""));
            }
        }
        return message;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.contentKind;
        result = 31 * result + this.entryKind;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncludePathEntry other = (IncludePathEntry)obj;
        if (this.contentKind != other.contentKind) {
            return false;
        }
        if (this.entryKind != other.entryKind) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }
}

