/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.properties.handlers;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.core.documentModel.IWorkspaceModelListener;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencePropagatorFactory;
import org.eclipse.php.internal.core.preferences.PreferencesPropagator;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;

public class PhpVersionChangedHandler
implements IWorkspaceModelListener {
    private HashMap projectListeners = new HashMap();
    private HashMap preferencesPropagatorListeners = new HashMap();
    private PreferencesPropagator preferencesPropagator;
    private static final String NODES_QUALIFIER = "org.eclipse.php.core";
    private static final IPreferenceStore store = PHPCorePlugin.getDefault().getPreferenceStore();
    private static PhpVersionChangedHandler instance = new PhpVersionChangedHandler();

    private PhpVersionChangedHandler() {
        PreferencePropagatorFactory.getInstance();
        this.preferencesPropagator = PreferencePropagatorFactory.getPreferencePropagator(NODES_QUALIFIER, store);
    }

    public static PhpVersionChangedHandler getInstance() {
        return instance;
    }

    public synchronized void projectModelAdded(IProject project) {
        if (project == null || this.projectListeners.get(project) != null) {
            return;
        }
        PHPWorkspaceModelManager.getInstance().addWorkspaceModelListener(project.getName(), instance);
        this.projectListeners.put(project, new HashSet());
        PreferencesPropagatorListener listener = new PreferencesPropagatorListener(project);
        this.preferencesPropagatorListeners.put(project, listener);
        this.preferencesPropagator.addPropagatorListener(listener, "phpVersion");
    }

    public synchronized void projectModelRemoved(IProject project) {
        PreferencesPropagatorListener listener = (PreferencesPropagatorListener)this.preferencesPropagatorListeners.get(project);
        this.preferencesPropagator.removePropagatorListener(listener, "phpVersion");
        this.preferencesPropagatorListeners.remove(project);
        this.projectListeners.remove(project);
        PHPWorkspaceModelManager.getInstance().removeWorkspaceModelListener(project.getName(), instance);
    }

    public void projectModelChanged(IProject project) {
    }

    private void projectVersionChanged(IProject project, PreferencesPropagatorEvent event) {
        HashSet listeners = (HashSet)this.projectListeners.get(project);
        if (listeners != null) {
            for (IPreferencesPropagatorListener listener : listeners) {
                listener.preferencesEventOccured(event);
            }
        }
    }

    public void addPhpVersionChangedListener(IPreferencesPropagatorListener listener) {
        IProject project = listener.getProject();
        HashSet listeners = (HashSet)this.projectListeners.get(project);
        if (listeners == null) {
            this.projectModelAdded(project);
            listeners = (HashSet)this.projectListeners.get(project);
        }
        listeners.add(listener);
    }

    public void removePhpVersionChangedListener(IPreferencesPropagatorListener listener) {
        if (listener == null) {
            return;
        }
        IProject project = listener.getProject();
        HashSet listeners = (HashSet)this.projectListeners.get(project);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    private class PreferencesPropagatorListener
    implements IPreferencesPropagatorListener {
        private IProject project;

        public PreferencesPropagatorListener(IProject project) {
            this.project = project;
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            String preferencesValue;
            if (event.getNewValue() == null) {
                String newValue = PreferencesSupport.getWorkspacePreferencesValue((String)event.getKey(), PHPCorePlugin.getDefault().getPreferenceStore());
                if (newValue == null || newValue.equals(event.getOldValue())) {
                    return;
                }
                event = new PreferencesPropagatorEvent(event.getSource(), event.getOldValue(), newValue, event.getKey());
            } else if (event.getOldValue() == null && (preferencesValue = PreferencesSupport.getWorkspacePreferencesValue((String)event.getKey(), PHPCorePlugin.getDefault().getPreferenceStore())) != null && preferencesValue.equals(event.getNewValue())) {
                return;
            }
            PhpVersionChangedHandler.this.projectVersionChanged(this.project, event);
        }

        public IProject getProject() {
            return this.project;
        }
    }
}

