/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.resources;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistryListener;

public class ExternalFilesRegistry {
    private static final ExternalFilesRegistry instance = new ExternalFilesRegistry();
    private final HashMap<String, IFile> externalFilesRegistry = new HashMap();
    private final ListenerList listeners = new ListenerList();
    private IProject externalFilesProject = ResourcesPlugin.getWorkspace().getRoot().getProject("external_" + System.currentTimeMillis());

    private ExternalFilesRegistry() {
    }

    public static ExternalFilesRegistry getInstance() {
        return instance;
    }

    public synchronized void addFileEntry(String localPath, IFile externalFile) {
        if (!this.externalFilesRegistry.containsKey(localPath)) {
            this.externalFilesRegistry.put(localPath, externalFile);
            this.notifyEntryChange(localPath, true);
        }
    }

    public IFile getFileEntry(String localPath) {
        IFile file = this.externalFilesRegistry.get(localPath);
        Collection<IFile> coll = this.externalFilesRegistry.values();
        for (IFile iFile : coll) {
            if (!iFile.getFullPath().equals((Object)new Path(localPath))) continue;
            file = iFile;
            break;
        }
        return file;
    }

    public synchronized void removeFileEntry(String localPath) {
        if (this.externalFilesRegistry.remove(localPath) != null) {
            this.notifyEntryChange(localPath, false);
        }
    }

    private void notifyEntryChange(String localPath, boolean isAddition) {
        Object[] listenersList;
        Object[] objectArray = listenersList = this.listeners.getListeners();
        int n = listenersList.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (isAddition) {
                ((ExternalFilesRegistryListener)element).externalFileAdded(localPath);
            } else {
                ((ExternalFilesRegistryListener)element).externalFileRemoved(localPath);
            }
            ++n2;
        }
    }

    public boolean isEntryExist(String localPath) {
        if (this.externalFilesRegistry.containsKey(localPath)) {
            return true;
        }
        Collection<IFile> coll = this.externalFilesRegistry.values();
        for (IFile iFile : coll) {
            if (!iFile.getFullPath().equals((Object)new Path(localPath))) continue;
            return true;
        }
        return false;
    }

    public boolean isEntryExist(IFile file) {
        if (file == null) {
            return false;
        }
        Collection<IFile> coll = this.externalFilesRegistry.values();
        for (IFile iFile : coll) {
            if (!iFile.getFullPath().toOSString().equals(file.getFullPath().toOSString())) continue;
            return true;
        }
        return false;
    }

    public void addListener(ExternalFilesRegistryListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ExternalFilesRegistryListener listener) {
        this.listeners.remove((Object)listener);
    }

    public IFile[] getAllAsIFiles() {
        Collection<IFile> coll = this.externalFilesRegistry.values();
        IFile[] result = new ExternalFileWrapper[coll.size()];
        coll.toArray(result);
        return result;
    }

    public IProject getExternalFilesProject() {
        return this.externalFilesProject;
    }
}

