/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.util.DefaultCacheManager;
import org.eclipse.php.internal.core.util.MapXMLReader;
import org.eclipse.php.internal.core.util.MapXMLWriter;
import org.xml.sax.InputSource;

public class IncludeCacheManager {
    private static final String INCLUDES_MAP_XML = "includes.xml";
    private Object lock = new Object();
    private File includeXMLFile;
    private DefaultCacheManager cacheManager;

    public IncludeCacheManager(DefaultCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.includeXMLFile = new File(cacheManager.getSharedCacheDirectory(), INCLUDES_MAP_XML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map includePathChanged(IProject project, List includePaths) {
        Map cachedMap = null;
        Object object = this.lock;
        synchronized (object) {
            String key = project.getName();
            cachedMap = this.getCachedMap();
            List oldPaths = cachedMap.put(key, includePaths);
            if (oldPaths != null) {
                this.checkPaths(oldPaths, cachedMap);
                this.deletePaths(oldPaths);
            }
            this.saveMap(cachedMap);
        }
        return cachedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map projectRemoved(IProject project) {
        Map cachedMap = null;
        Object object = this.lock;
        synchronized (object) {
            String key = project.getName();
            cachedMap = this.getCachedMap();
            List pathsToRemove = (List)cachedMap.remove(key);
            if (pathsToRemove != null) {
                this.checkPaths(pathsToRemove, cachedMap);
                this.deletePaths(pathsToRemove);
            }
            this.saveMap(cachedMap);
        }
        return cachedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map phpVersionChanged(IProject project, String oldVersion, String newVersion) {
        if (oldVersion == null || newVersion == null) {
            return null;
        }
        Map cachedMap = null;
        Object object = this.lock;
        synchronized (object) {
            String key = project.getName();
            cachedMap = this.getCachedMap();
            List oldPaths = (List)cachedMap.get(key);
            if (oldPaths != null) {
                ArrayList<String> newNames = new ArrayList<String>(oldPaths.size());
                int i = 0;
                while (i < oldPaths.size()) {
                    newNames.add(((String)oldPaths.get(i)).replaceAll(oldVersion, newVersion));
                    ++i;
                }
                cachedMap.put(key, newNames);
                this.checkPaths(oldPaths, cachedMap);
                this.deletePaths(oldPaths);
            }
            this.saveMap(cachedMap);
        }
        return cachedMap;
    }

    public void checkCache() {
        Map cachedMap = this.getCachedMap();
        IProject[] projects = PHPWorkspaceModelManager.getInstance().listProjects();
        HashMap<String, IProject> projectsMap = new HashMap<String, IProject>();
        int i = 0;
        while (i < projects.length) {
            projectsMap.put(projects[i].getName(), projects[i]);
            ++i;
        }
        ArrayList pathsToRemove = new ArrayList();
        Set keysSet = cachedMap.keySet();
        Object[] keys = new Object[keysSet.size()];
        keysSet.toArray(keys);
        int i2 = 0;
        while (i2 < keys.length) {
            if (!projectsMap.containsKey(keys[i2])) {
                List list = (List)cachedMap.remove(keys[i2]);
                pathsToRemove.addAll(list);
            }
            ++i2;
        }
        this.checkPaths(pathsToRemove, cachedMap);
        this.deletePaths(pathsToRemove);
    }

    private void deletePaths(List pathsToRemove) {
        Iterator paths = pathsToRemove.iterator();
        File sharedDirectory = this.cacheManager.getSharedCacheDirectory();
        while (paths.hasNext()) {
            File file = new File(sharedDirectory, (String)paths.next());
            file.delete();
        }
    }

    private void checkPaths(List pathsToRemove, Map cachedMap) {
        HashMap tempMap = new HashMap();
        Iterator values = cachedMap.values().iterator();
        while (values.hasNext()) {
            Iterator paths = ((List)values.next()).iterator();
            while (paths.hasNext()) {
                tempMap.put(paths.next(), "dummy");
            }
        }
        int i = pathsToRemove.size() - 1;
        while (i >= 0) {
            if (tempMap.containsKey(pathsToRemove.get(i))) {
                pathsToRemove.remove(i);
            }
            --i;
        }
    }

    private void saveMap(Map cachedMap) {
        PrintWriter xmlWriter = null;
        try {
            try {
                xmlWriter = new MapXMLWriter(new FileOutputStream(this.includeXMLFile));
                ((MapXMLWriter)xmlWriter).writeMap(cachedMap);
            }
            catch (Exception e) {
                PHPCorePlugin.log(e);
                if (xmlWriter != null) {
                    xmlWriter.flush();
                    xmlWriter.close();
                }
            }
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.flush();
                xmlWriter.close();
            }
        }
    }

    private Map getCachedMap() {
        Map map = null;
        try {
            if (this.includeXMLFile.exists()) {
                map = MapXMLReader.readMap(new InputSource(new InputStreamReader((InputStream)new FileInputStream(this.includeXMLFile), "UTF8")));
            }
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }
}

