/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.parser.VariableContextBuilder;
import org.eclipse.php.internal.core.phpModel.phpElementData.BasicPHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlockImp;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPTask;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableTypeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariablesTypeManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.util.ICachable;

public class SerializationUtil {
    private static String currentFileName;

    public static void serialize(ICachable[] datas, DataOutputStream output) throws IOException {
        if (datas != null) {
            output.writeInt(datas.length);
            ICachable[] iCachableArray = datas;
            int n = datas.length;
            int n2 = 0;
            while (n2 < n) {
                ICachable element = iCachableArray[n2];
                SerializationUtil.serialize((PHPFileData)element, output);
                ++n2;
            }
        } else {
            output.writeInt(0);
        }
    }

    private static void serialize(PHPFileData fileData, DataOutputStream output) throws IOException {
        if (fileData != null) {
            currentFileName = fileData.getName();
            SerializationUtil.writeString(currentFileName, output);
            SerializationUtil.serialize(fileData.getUserData(), output);
            SerializationUtil.serialize(fileData.getClasses(), output);
            SerializationUtil.serialize(fileData.getFunctions(), output);
            SerializationUtil.serialize(fileData.getVariableTypeManager(), output);
            SerializationUtil.serialize(fileData.getIncludeFiles(), output);
            SerializationUtil.serialize(fileData.getConstants(), output);
            SerializationUtil.serialize(fileData.getMarkers(), output);
            SerializationUtil.serialize(fileData.getPHPBlocks(), output);
            SerializationUtil.serialize(fileData.getDocBlock(), output);
            output.writeLong(fileData.getCreationTimeLastModified());
        }
    }

    private static void serialize(UserData userData, DataOutputStream output) throws IOException {
        if (userData != null) {
            output.writeBoolean(true);
            output.writeInt(userData.getStartPosition());
            output.writeInt(userData.getEndPosition());
            output.writeInt(userData.getStopPosition());
            output.writeInt(userData.getStopLine());
        } else {
            output.writeBoolean(false);
        }
    }

    private static void serialize(PHPClassData[] classes, DataOutputStream output) throws IOException {
        if (classes != null) {
            output.writeInt(classes.length);
            PHPClassData[] pHPClassDataArray = classes;
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                PHPClassData element = pHPClassDataArray[n2];
                SerializationUtil.serialize(element, output);
                ++n2;
            }
        }
    }

    private static void serialize(PHPClassData classData, DataOutputStream output) throws IOException {
        if (classData != null) {
            SerializationUtil.writeString(classData.getName(), output);
            output.writeInt(classData.getModifiers());
            SerializationUtil.serialize(classData.getDocBlock(), output);
            SerializationUtil.serialize(classData.getUserData(), output);
            SerializationUtil.serialize(classData.getSuperClassData(), output);
            SerializationUtil.serialize(classData.getInterfacesNamesData(), output);
            SerializationUtil.serialize(classData.getVars(), output);
            SerializationUtil.serialize(classData.getConsts(), output);
            SerializationUtil.serialize(classData.getFunctions(), output);
        }
    }

    private static void serialize(PHPClassConstData[] consts, DataOutputStream output) throws IOException {
        if (consts != null) {
            output.writeInt(consts.length);
            PHPClassConstData[] pHPClassConstDataArray = consts;
            int n = consts.length;
            int n2 = 0;
            while (n2 < n) {
                PHPClassConstData element = pHPClassConstDataArray[n2];
                SerializationUtil.serialize(element, output);
                ++n2;
            }
        }
    }

    private static void serialize(PHPClassConstData data, DataOutputStream output) throws IOException {
        if (data != null) {
            SerializationUtil.writeString(data.getName(), output);
            SerializationUtil.writeString(data.getValue(), output);
            SerializationUtil.serialize(data.getDocBlock(), output);
            SerializationUtil.serialize(data.getUserData(), output);
        }
    }

    private static void serialize(PHPClassVarData[] vars, DataOutputStream output) throws IOException {
        if (vars != null) {
            output.writeInt(vars.length);
            PHPClassVarData[] pHPClassVarDataArray = vars;
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                PHPClassVarData element = pHPClassVarDataArray[n2];
                SerializationUtil.serialize(element, output);
                ++n2;
            }
        }
    }

    private static void serialize(PHPClassVarData var, DataOutputStream output) throws IOException {
        if (var != null) {
            SerializationUtil.writeString(var.getName(), output);
            output.writeInt(var.getModifiers());
            SerializationUtil.writeString(var.getClassType(), output);
            SerializationUtil.serialize(var.getDocBlock(), output);
            SerializationUtil.serialize(var.getUserData(), output);
        }
    }

    private static void serialize(PHPClassData.PHPInterfaceNameData[] interfacesNamesData, DataOutputStream output) throws IOException {
        if (interfacesNamesData != null) {
            output.writeInt(interfacesNamesData.length);
            PHPClassData.PHPInterfaceNameData[] pHPInterfaceNameDataArray = interfacesNamesData;
            int n = interfacesNamesData.length;
            int n2 = 0;
            while (n2 < n) {
                PHPClassData.PHPInterfaceNameData element = pHPInterfaceNameDataArray[n2];
                SerializationUtil.serialize(element, output);
                ++n2;
            }
        }
    }

    private static void serialize(PHPClassData.PHPInterfaceNameData phpInterfaceNameData, DataOutputStream output) throws IOException {
        if (phpInterfaceNameData != null) {
            SerializationUtil.writeString(phpInterfaceNameData.getName(), output);
            SerializationUtil.serialize(phpInterfaceNameData.getUserData(), output);
        }
    }

    private static void serialize(PHPClassData.PHPSuperClassNameData superClassData, DataOutputStream output) throws IOException {
        if (superClassData != null) {
            SerializationUtil.writeString(superClassData.getName(), output);
            SerializationUtil.serialize(superClassData.getUserData(), output);
        }
    }

    private static void serialize(PHPDocBlock docBlock, DataOutputStream output) throws IOException {
        output.writeBoolean(docBlock != null);
        if (docBlock != null) {
            SerializationUtil.writeString(docBlock.getShortDescription(), output);
            SerializationUtil.writeString(docBlock.getLongDescription(), output);
            SerializationUtil.serialize(docBlock.getTagsAsArray(), output);
            output.writeInt(docBlock.getType());
            output.writeInt(docBlock.getStartPosition());
            output.writeInt(docBlock.getEndPosition());
        }
    }

    private static void serialize(PHPConstantData[] constants, DataOutputStream output) throws IOException {
        if (constants != null) {
            output.writeInt(constants.length);
            PHPConstantData[] pHPConstantDataArray = constants;
            int n = constants.length;
            int n2 = 0;
            while (n2 < n) {
                PHPConstantData element = pHPConstantDataArray[n2];
                SerializationUtil.serialize(element, output);
                ++n2;
            }
        }
    }

    private static void serialize(PHPConstantData constant, DataOutputStream output) throws IOException {
        if (constant != null) {
            SerializationUtil.writeString(constant.getName(), output);
            SerializationUtil.writeString(constant.getValue(), output);
            SerializationUtil.serialize(constant.getUserData(), output);
            SerializationUtil.serialize(constant.getDocBlock(), output);
        }
    }

    private static void serialize(PHPDocTag[] tags, DataOutputStream output) throws IOException {
        if (tags != null) {
            output.writeInt(tags.length);
            PHPDocTag[] pHPDocTagArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag element = pHPDocTagArray[n2];
                SerializationUtil.serialize(element, output);
                ++n2;
            }
        }
    }

    private static void serialize(PHPDocTag tag, DataOutputStream output) throws IOException {
        if (tag != null) {
            output.writeInt(tag.getID());
            SerializationUtil.writeString(tag.getValue(), output);
        }
    }

    private static void serialize(PHPBlock[] phpBlocks, DataOutputStream output) throws IOException {
        if (phpBlocks != null) {
            output.writeInt(phpBlocks.length);
            PHPBlock[] pHPBlockArray = phpBlocks;
            int n = phpBlocks.length;
            int n2 = 0;
            while (n2 < n) {
                PHPBlock element = pHPBlockArray[n2];
                SerializationUtil.serialize(element, output);
                ++n2;
            }
        }
    }

    private static void serialize(PHPBlock phpBlock, DataOutputStream output) throws IOException {
        if (phpBlock != null) {
            SerializationUtil.serialize(phpBlock.getPHPStartTag(), output);
            SerializationUtil.serialize(phpBlock.getPHPEndTag(), output);
        }
    }

    private static void serialize(IPHPMarker[] markers, DataOutputStream output) throws IOException {
        if (markers != null) {
            output.writeInt(markers.length);
            IPHPMarker[] iPHPMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IPHPMarker element = iPHPMarkerArray[n2];
                SerializationUtil.serialize(element, output);
                ++n2;
            }
        }
    }

    private static void serialize(IPHPMarker marker, DataOutputStream output) throws IOException {
        if (marker != null) {
            SerializationUtil.writeString(marker.getDescription(), output);
            SerializationUtil.writeString(marker.getType(), output);
            if (marker instanceof PHPTask) {
                SerializationUtil.writeString(((PHPTask)marker).getTaskName(), output);
            }
            SerializationUtil.serialize(marker.getUserData(), output);
        }
    }

    private static void serialize(PHPVariablesTypeManager variableTypeManager, DataOutputStream output) throws IOException {
        Map contextsToVariables = variableTypeManager.getContextsToVariables();
        Iterator keys = contextsToVariables.keySet().iterator();
        output.writeInt(contextsToVariables.size());
        while (keys.hasNext()) {
            PHPCodeContext key = (PHPCodeContext)keys.next();
            PHPVariableData[] list = (PHPVariableData[])contextsToVariables.get(key);
            SerializationUtil.serialize(key, output);
            output.writeInt(list.length);
            PHPVariableData[] pHPVariableDataArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                PHPVariableData element = pHPVariableDataArray[n2];
                SerializationUtil.serialize(element, output);
                ++n2;
            }
        }
        Map variables = variableTypeManager.getVariablesInstansiation();
        keys = variables.keySet().iterator();
        output.writeInt(variables.size());
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List list = (List)variables.get(key);
            SerializationUtil.writeString(key, output);
            output.writeInt(list.size());
            int i = 0;
            while (i < list.size()) {
                PHPVariableTypeData data = (PHPVariableTypeData)list.get(i);
                SerializationUtil.serialize(data, output);
                ++i;
            }
        }
    }

    private static void serialize(PHPVariableTypeData data, DataOutputStream output) throws IOException {
        SerializationUtil.writeString(data.getType(), output);
        output.writeInt(data.getLine());
        output.writeInt(data.getPosition());
        output.writeBoolean(data.isUserDocumentation());
    }

    private static void serialize(PHPCodeContext key, DataOutputStream output) throws IOException {
        SerializationUtil.writeString(key.getContainerClassName(), output);
        SerializationUtil.writeString(key.getContainerFunctionName(), output);
    }

    private static void serialize(PHPIncludeFileData[] includeFiles, DataOutputStream output) throws IOException {
        if (includeFiles != null) {
            output.writeInt(includeFiles.length);
            PHPIncludeFileData[] pHPIncludeFileDataArray = includeFiles;
            int n = includeFiles.length;
            int n2 = 0;
            while (n2 < n) {
                PHPIncludeFileData element = pHPIncludeFileDataArray[n2];
                SerializationUtil.serialize(element, output);
                ++n2;
            }
        }
    }

    private static void serialize(PHPIncludeFileData includeFile, DataOutputStream output) throws IOException {
        if (includeFile != null) {
            SerializationUtil.writeString(includeFile.getIncludingType(), output);
            SerializationUtil.serialize((PHPCodeData)includeFile, output);
        }
    }

    private static void serialize(PHPVariableData phpVariableData, DataOutputStream output) throws IOException {
        if (phpVariableData != null) {
            SerializationUtil.writeString(phpVariableData.getName(), output);
            output.writeBoolean(phpVariableData.isGlobal());
            SerializationUtil.serialize(phpVariableData.getDocBlock(), output);
            SerializationUtil.serialize(phpVariableData.getUserData(), output);
        }
    }

    private static void serialize(PHPCodeData phpCodeData, DataOutputStream output) throws IOException {
        if (phpCodeData != null) {
            SerializationUtil.writeString(phpCodeData.getName(), output);
            SerializationUtil.serialize(phpCodeData.getDocBlock(), output);
            SerializationUtil.serialize(phpCodeData.getUserData(), output);
        }
    }

    private static void serialize(PHPFunctionData[] functions, DataOutputStream output) throws IOException {
        if (functions != null) {
            output.writeInt(functions.length);
            PHPFunctionData[] pHPFunctionDataArray = functions;
            int n = functions.length;
            int n2 = 0;
            while (n2 < n) {
                PHPFunctionData element = pHPFunctionDataArray[n2];
                SerializationUtil.serialize(element, output);
                ++n2;
            }
        }
    }

    private static void serialize(PHPFunctionData function, DataOutputStream output) throws IOException {
        if (function != null) {
            SerializationUtil.writeString(function.getName(), output);
            output.writeInt(function.getModifiers());
            SerializationUtil.serialize(function.getDocBlock(), output);
            SerializationUtil.serialize(function.getUserData(), output);
            SerializationUtil.serialize(function.getParameters(), output);
            SerializationUtil.writeString(function.getReturnType(), output);
        }
    }

    private static void serialize(PHPFunctionData.PHPFunctionParameter[] parameters, DataOutputStream output) throws IOException {
        if (parameters != null) {
            output.writeInt(parameters.length);
            PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                PHPFunctionData.PHPFunctionParameter element = pHPFunctionParameterArray[n2];
                SerializationUtil.serialize(element, output);
                ++n2;
            }
        }
    }

    private static void serialize(PHPFunctionData.PHPFunctionParameter parameter, DataOutputStream output) throws IOException {
        if (parameter != null) {
            SerializationUtil.writeString(parameter.getName(), output);
            SerializationUtil.serialize(parameter.getUserData(), output);
            output.writeBoolean(parameter.isReference());
            output.writeBoolean(parameter.isConst());
            SerializationUtil.writeString(parameter.getClassType(), output);
            SerializationUtil.writeString(parameter.getDefaultValue(), output);
        }
    }

    public static PHPFileData[] deserializePHPFileDataArray(DataInputStream inputStream) throws IOException {
        int size = inputStream.readInt();
        PHPFileData[] datas = new PHPFileData[size];
        int i = 0;
        while (i < size) {
            datas[i] = SerializationUtil.deserializePHPFileData(inputStream);
            ++i;
        }
        return datas;
    }

    private static PHPFileData deserializePHPFileData(DataInputStream inputStream) throws IOException {
        PHPCodeData element;
        String fileName;
        currentFileName = fileName = SerializationUtil.readString(inputStream);
        UserData userData = SerializationUtil.deserializeUserData(inputStream);
        PHPClassData[] classes = SerializationUtil.deserializeClassDataArray(inputStream);
        PHPFunctionData[] functions = SerializationUtil.deserializeFunctionDataArray(inputStream);
        PHPVariablesTypeManager variablesTypeManager = SerializationUtil.deserializeVariableTypeManager(inputStream);
        PHPIncludeFileData[] includeFiles = SerializationUtil.deserializeIncludeDataArray(inputStream);
        PHPConstantData[] constants = SerializationUtil.deserializeConstantDataArray(inputStream);
        IPHPMarker[] markers = SerializationUtil.deserializeMarkersDataArray(inputStream);
        PHPBlock[] phpBlocks = SerializationUtil.deserializeBlockArray(inputStream);
        PHPDocBlock docBlock = SerializationUtil.deserializeDocBlock(inputStream);
        long lastModified = inputStream.readLong();
        PHPFileData data = PHPCodeDataFactory.createPHPFileData(fileName, userData, classes, functions, variablesTypeManager, includeFiles, constants, markers, phpBlocks, docBlock, lastModified);
        PHPCodeData[] pHPCodeDataArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            element = pHPCodeDataArray[n2];
            element.setContainer(data);
            ++n2;
        }
        pHPCodeDataArray = functions;
        n = functions.length;
        n2 = 0;
        while (n2 < n) {
            element = pHPCodeDataArray[n2];
            element.setContainer(data);
            ++n2;
        }
        pHPCodeDataArray = includeFiles;
        n = includeFiles.length;
        n2 = 0;
        while (n2 < n) {
            element = pHPCodeDataArray[n2];
            element.setContainer(data);
            ++n2;
        }
        pHPCodeDataArray = constants;
        n = constants.length;
        n2 = 0;
        while (n2 < n) {
            element = pHPCodeDataArray[n2];
            element.setContainer(data);
            ++n2;
        }
        return data;
    }

    private static UserData deserializeUserData(DataInputStream input) throws IOException {
        boolean hasUserData = input.readBoolean();
        UserData userData = null;
        if (hasUserData) {
            int startPosition = input.readInt();
            int endPosition = input.readInt();
            int stopPosition = input.readInt();
            int stopLine = input.readInt();
            userData = PHPCodeDataFactory.createUserData(currentFileName, startPosition, endPosition, stopPosition, stopLine);
        }
        return userData;
    }

    private static PHPClassData[] deserializeClassDataArray(DataInputStream inputStream) throws IOException {
        int size = inputStream.readInt();
        PHPClassData[] datas = PHPCodeDataFactory.EMPTY_CLASS_DATA_ARRAY;
        if (size > 0) {
            datas = new PHPClassData[size];
            int i = 0;
            while (i < datas.length) {
                datas[i] = SerializationUtil.deserializeClassData(inputStream);
                ++i;
            }
        }
        return datas;
    }

    private static PHPClassData deserializeClassData(DataInputStream inputStream) throws IOException {
        PHPCodeData element;
        String name = SerializationUtil.readString(inputStream);
        int modifier = inputStream.readInt();
        PHPDocBlock docBlock = SerializationUtil.deserializeDocBlock(inputStream);
        UserData userData = SerializationUtil.deserializeUserData(inputStream);
        PHPClassData.PHPSuperClassNameData superClass = SerializationUtil.deserializeSuperClass(inputStream);
        PHPClassData.PHPInterfaceNameData[] interfaces = SerializationUtil.deserializeInterfacesArray(inputStream);
        PHPClassVarData[] vars = SerializationUtil.deserializeClassVarDataArray(inputStream);
        PHPClassConstData[] consts = SerializationUtil.deserializeClassConstArray(inputStream);
        PHPFunctionData[] functions = SerializationUtil.deserializeFunctionDataArray(inputStream);
        PHPClassData rv = PHPCodeDataFactory.createPHPClassData(name, modifier, docBlock, userData, superClass, interfaces, vars, consts, functions);
        PHPCodeData[] pHPCodeDataArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            element = pHPCodeDataArray[n2];
            element.setContainer(rv);
            ++n2;
        }
        pHPCodeDataArray = consts;
        n = consts.length;
        n2 = 0;
        while (n2 < n) {
            element = pHPCodeDataArray[n2];
            element.setContainer(rv);
            ++n2;
        }
        pHPCodeDataArray = functions;
        n = functions.length;
        n2 = 0;
        while (n2 < n) {
            element = pHPCodeDataArray[n2];
            element.setContainer(rv);
            ++n2;
        }
        return rv;
    }

    private static PHPClassConstData[] deserializeClassConstArray(DataInputStream inputStream) throws IOException {
        int size = inputStream.readInt();
        PHPClassConstData[] datas = PHPCodeDataFactory.EMPTY_CLASS_CONST_DATA_ARRAY;
        if (size > 0) {
            datas = new PHPClassConstData[size];
            int i = 0;
            while (i < datas.length) {
                datas[i] = SerializationUtil.deserializeClassConst(inputStream);
                ++i;
            }
        }
        return datas;
    }

    private static PHPClassConstData deserializeClassConst(DataInputStream inputStream) throws IOException {
        String name = SerializationUtil.readString(inputStream);
        String value = SerializationUtil.readString(inputStream);
        PHPDocBlock docBlock = SerializationUtil.deserializeDocBlock(inputStream);
        UserData userData = SerializationUtil.deserializeUserData(inputStream);
        return PHPCodeDataFactory.createPHPClassConstData(name, value, docBlock, userData);
    }

    private static PHPClassVarData[] deserializeClassVarDataArray(DataInputStream inputStream) throws IOException {
        int size = inputStream.readInt();
        PHPClassVarData[] datas = PHPCodeDataFactory.EMPTY_CLASS_VAR_DATA_ARRAY;
        if (size > 0) {
            datas = new PHPClassVarData[size];
            int i = 0;
            while (i < datas.length) {
                datas[i] = SerializationUtil.deserializeClassVarData(inputStream);
                ++i;
            }
        }
        return datas;
    }

    private static PHPClassVarData deserializeClassVarData(DataInputStream inputStream) throws IOException {
        String name = SerializationUtil.readString(inputStream);
        int modifier = inputStream.readInt();
        String classType = SerializationUtil.readString(inputStream);
        PHPDocBlock docBlock = SerializationUtil.deserializeDocBlock(inputStream);
        UserData userData = SerializationUtil.deserializeUserData(inputStream);
        return PHPCodeDataFactory.createPHPClassVarData(name, modifier, classType, docBlock, userData);
    }

    private static PHPClassData.PHPInterfaceNameData[] deserializeInterfacesArray(DataInputStream inputStream) throws IOException {
        int size = inputStream.readInt();
        PHPClassData.PHPInterfaceNameData[] datas = PHPCodeDataFactory.EMPTY_INTERFACES_DATA_ARRAY;
        if (size > 0) {
            datas = new PHPClassData.PHPInterfaceNameData[size];
            int i = 0;
            while (i < datas.length) {
                datas[i] = SerializationUtil.deserializeInterfaces(inputStream);
                ++i;
            }
        }
        return datas;
    }

    private static PHPClassData.PHPInterfaceNameData deserializeInterfaces(DataInputStream inputStream) throws IOException {
        String name = SerializationUtil.readString(inputStream);
        UserData userData = SerializationUtil.deserializeUserData(inputStream);
        return PHPCodeDataFactory.createPHPInterfaceNameData(name, userData);
    }

    private static PHPClassData.PHPSuperClassNameData deserializeSuperClass(DataInputStream inputStream) throws IOException {
        String name = SerializationUtil.readString(inputStream);
        UserData userData = SerializationUtil.deserializeUserData(inputStream);
        return PHPCodeDataFactory.createPHPSuperClassNameData(name, userData);
    }

    private static PHPDocBlock deserializeDocBlock(DataInputStream inputStream) throws IOException {
        boolean exist = inputStream.readBoolean();
        if (exist) {
            String shortDescription = SerializationUtil.readString(inputStream);
            String longDescription = SerializationUtil.readString(inputStream);
            PHPDocTag[] tags = SerializationUtil.deserializePHPDocTagArray(inputStream);
            int type = inputStream.readInt();
            int startPosition = inputStream.readInt();
            int endPosition = inputStream.readInt();
            PHPDocBlockImp rv = new PHPDocBlockImp(shortDescription, longDescription, tags, type);
            rv.setStartPosition(startPosition);
            rv.setEndPosition(endPosition);
            return rv;
        }
        return null;
    }

    private static PHPBlock[] deserializeBlockArray(DataInputStream inputStream) throws IOException {
        int size = inputStream.readInt();
        PHPBlock[] datas = PHPCodeDataFactory.EMPTY_PHP_BLOCK_ARRAY;
        if (size > 0) {
            datas = new PHPBlock[size];
            int i = 0;
            while (i < datas.length) {
                datas[i] = SerializationUtil.deserializeBlock(inputStream);
                ++i;
            }
        }
        return datas;
    }

    private static PHPBlock deserializeBlock(DataInputStream inputStream) throws IOException {
        UserData startTag = SerializationUtil.deserializeUserData(inputStream);
        UserData endTag = SerializationUtil.deserializeUserData(inputStream);
        return new PHPBlock(startTag, endTag);
    }

    private static IPHPMarker[] deserializeMarkersDataArray(DataInputStream inputStream) throws IOException {
        int size = inputStream.readInt();
        IPHPMarker[] datas = PHPCodeDataFactory.EMPTY_MARKERS_DATA_ARRAY;
        if (size > 0) {
            datas = new IPHPMarker[size];
            int i = 0;
            while (i < datas.length) {
                datas[i] = SerializationUtil.deserializeMarkerData(inputStream);
                ++i;
            }
        }
        return datas;
    }

    private static IPHPMarker deserializeMarkerData(DataInputStream inputStream) throws IOException {
        String description = SerializationUtil.readString(inputStream);
        String type = SerializationUtil.readString(inputStream);
        boolean isTask = "TASK".equals(type);
        String taskName = null;
        if (isTask) {
            taskName = SerializationUtil.readString(inputStream);
        }
        UserData userData = SerializationUtil.deserializeUserData(inputStream);
        return isTask ? new PHPTask(taskName, description, userData) : new PHPMarker(type, description, userData);
    }

    private static PHPConstantData[] deserializeConstantDataArray(DataInputStream inputStream) throws IOException {
        int size = inputStream.readInt();
        PHPConstantData[] datas = PHPCodeDataFactory.EMPTY_CONSTANT_DATA_ARRAY;
        if (size > 0) {
            datas = new PHPConstantData[size];
            int i = 0;
            while (i < datas.length) {
                datas[i] = SerializationUtil.deserializeConstantData(inputStream);
                ++i;
            }
        }
        return datas;
    }

    private static PHPConstantData deserializeConstantData(DataInputStream inputStream) throws IOException {
        String name = SerializationUtil.readString(inputStream);
        String value = SerializationUtil.readString(inputStream);
        UserData userData = SerializationUtil.deserializeUserData(inputStream);
        PHPDocBlock docBlock = SerializationUtil.deserializeDocBlock(inputStream);
        return PHPCodeDataFactory.createPHPConstantData(name, value, userData, docBlock);
    }

    private static PHPIncludeFileData[] deserializeIncludeDataArray(DataInputStream inputStream) throws IOException {
        int size = inputStream.readInt();
        PHPIncludeFileData[] datas = PHPCodeDataFactory.EMPTY_INCLUDE_DATA_ARRAY;
        if (size > 0) {
            datas = new PHPIncludeFileData[size];
            int i = 0;
            while (i < datas.length) {
                datas[i] = SerializationUtil.deserializeIncludeData(inputStream);
                ++i;
            }
        }
        return datas;
    }

    private static PHPIncludeFileData deserializeIncludeData(DataInputStream inputStream) throws IOException {
        String includingType = SerializationUtil.readString(inputStream);
        String name = SerializationUtil.readString(inputStream);
        PHPDocBlock docBlock = SerializationUtil.deserializeDocBlock(inputStream);
        UserData userData = SerializationUtil.deserializeUserData(inputStream);
        return PHPCodeDataFactory.createPHPIncludeFileData(includingType, name, docBlock, userData);
    }

    private static PHPVariablesTypeManager deserializeVariableTypeManager(DataInputStream inputStream) throws IOException {
        int size = inputStream.readInt();
        HashMap<PHPCodeContext, PHPVariableData[]> contextsToVariables = new HashMap<PHPCodeContext, PHPVariableData[]>(size);
        int i = 0;
        while (i < size) {
            PHPCodeContext codeContext = SerializationUtil.deserializeCodeContext(inputStream);
            PHPVariableData[] list = SerializationUtil.deserializePHPVariableDataArray(inputStream);
            contextsToVariables.put(codeContext, list);
            ++i;
        }
        size = inputStream.readInt();
        HashMap<String, List<PHPVariableTypeData>> variables = new HashMap<String, List<PHPVariableTypeData>>(size);
        int i2 = 0;
        while (i2 < size) {
            String key = SerializationUtil.readString(inputStream);
            int listSize = inputStream.readInt();
            ArrayList<PHPVariableTypeData> list = new ArrayList<PHPVariableTypeData>(listSize);
            int j = 0;
            while (j < listSize) {
                list.add(SerializationUtil.deserializePHPVariableTypeData(inputStream));
                ++j;
            }
            variables.put(key, list);
            ++i2;
        }
        if (variables.isEmpty()) {
            return PHPCodeDataFactory.EMPTY_PHP_VARIABLES_TYPE_MANAGER;
        }
        return VariableContextBuilder.createPHPVariablesTypeManager(contextsToVariables, variables);
    }

    private static PHPVariableTypeData deserializePHPVariableTypeData(DataInputStream inputStream) throws IOException {
        String type = SerializationUtil.readString(inputStream);
        int line = inputStream.readInt();
        int position = inputStream.readInt();
        boolean userDocumentation = inputStream.readBoolean();
        return VariableContextBuilder.createVariableTypeData(type, line, position, userDocumentation);
    }

    private static PHPVariableData[] deserializePHPVariableDataArray(DataInputStream inputStream) throws IOException {
        PHPVariableData[] datas = new PHPVariableData[inputStream.readInt()];
        int i = 0;
        while (i < datas.length) {
            datas[i] = SerializationUtil.deserializePHPVariableData(inputStream);
            ++i;
        }
        return datas;
    }

    private static PHPVariableData deserializePHPVariableData(DataInputStream inputStream) throws IOException {
        String name = SerializationUtil.readString(inputStream);
        boolean isGlobal = inputStream.readBoolean();
        PHPDocBlock docBlock = SerializationUtil.deserializeDocBlock(inputStream);
        UserData userData = SerializationUtil.deserializeUserData(inputStream);
        return PHPCodeDataFactory.createPHPVariableData(name, isGlobal, docBlock, userData);
    }

    private static PHPCodeContext deserializeCodeContext(DataInputStream inputStream) throws IOException {
        String className = SerializationUtil.readString(inputStream);
        String functionName = SerializationUtil.readString(inputStream);
        return ModelSupport.createContext(className, functionName);
    }

    private static PHPFunctionData[] deserializeFunctionDataArray(DataInputStream inputStream) throws IOException {
        int size = inputStream.readInt();
        PHPFunctionData[] datas = PHPCodeDataFactory.EMPTY_FUNCTIONS_DATA_ARRAY;
        if (size > 0) {
            datas = new PHPFunctionData[size];
            int i = 0;
            while (i < datas.length) {
                datas[i] = SerializationUtil.deserializeFunctionData(inputStream);
                ++i;
            }
        }
        return datas;
    }

    private static PHPFunctionData deserializeFunctionData(DataInputStream inputStream) throws IOException {
        String name = SerializationUtil.readString(inputStream);
        int modifier = inputStream.readInt();
        PHPDocBlock docBlock = SerializationUtil.deserializeDocBlock(inputStream);
        UserData userData = SerializationUtil.deserializeUserData(inputStream);
        PHPFunctionData.PHPFunctionParameter[] parameter = SerializationUtil.deserializeFunctionsParameterArray(inputStream);
        String returnType = SerializationUtil.readString(inputStream);
        PHPFunctionData rv = PHPCodeDataFactory.createPHPFuctionData(name, modifier, docBlock, userData, parameter, returnType);
        PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray = parameter;
        int n = parameter.length;
        int n2 = 0;
        while (n2 < n) {
            PHPFunctionData.PHPFunctionParameter element = pHPFunctionParameterArray[n2];
            element.setContainer(rv);
            ++n2;
        }
        return rv;
    }

    private static PHPFunctionData.PHPFunctionParameter[] deserializeFunctionsParameterArray(DataInputStream inputStream) throws IOException {
        int size = inputStream.readInt();
        PHPFunctionData.PHPFunctionParameter[] datas = PHPCodeDataFactory.EMPTY_FUNCTION_PARAMETER_DATA_ARRAY;
        if (size > 0) {
            datas = new PHPFunctionData.PHPFunctionParameter[size];
            int i = 0;
            while (i < datas.length) {
                datas[i] = SerializationUtil.deserializeFunctionsParameter(inputStream);
                ++i;
            }
        }
        return datas;
    }

    private static PHPFunctionData.PHPFunctionParameter deserializeFunctionsParameter(DataInputStream inputStream) throws IOException {
        String name = SerializationUtil.readString(inputStream);
        UserData userData = SerializationUtil.deserializeUserData(inputStream);
        boolean isReference = inputStream.readBoolean();
        boolean isConst = inputStream.readBoolean();
        String classType = SerializationUtil.readString(inputStream);
        String defaultValue = SerializationUtil.readString(inputStream);
        return PHPCodeDataFactory.createPHPFunctionParameter(name, userData, isReference, isConst, classType, defaultValue);
    }

    private static PHPDocTag[] deserializePHPDocTagArray(DataInputStream input) throws IOException {
        int size = input.readInt();
        PHPDocTag[] datas = PHPCodeDataFactory.EMPTY_PHP_DOC_TAG;
        if (size > 0) {
            datas = new PHPDocTag[size];
            int i = 0;
            while (i < datas.length) {
                datas[i] = SerializationUtil.deserializePHPDocTag(input);
                ++i;
            }
        }
        return datas;
    }

    private static PHPDocTag deserializePHPDocTag(DataInputStream input) throws IOException {
        BasicPHPDocTag tag = new BasicPHPDocTag(input.readInt(), SerializationUtil.readString(input));
        return tag;
    }

    private static String readString(DataInputStream in) throws IOException {
        boolean exist = in.readBoolean();
        if (exist) {
            return in.readUTF();
        }
        return null;
    }

    private static void writeString(String str, DataOutputStream out) throws IOException {
        out.writeBoolean(str != null);
        if (str != null) {
            out.writeUTF(str);
        }
    }
}

