/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.communication;

import java.net.Socket;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.daemon.AbstractDebuggerCommunicationDaemon;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSession;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;

public class XDebugCommunicationDaemon
extends AbstractDebuggerCommunicationDaemon {
    public static final String XDEBUG_DEBUGGER_ID = "org.eclipse.php.debug.core.xdebugDebugger";
    private PortChangeListener portChangeListener;

    public void init() {
        this.initDeamonChangeListener();
        super.init();
    }

    protected void initDeamonChangeListener() {
        if (this.portChangeListener == null) {
            Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
            this.portChangeListener = new PortChangeListener();
            preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.portChangeListener);
        }
    }

    public int getReceiverPort() {
        return PHPDebugPlugin.getDebugPort(XDEBUG_DEBUGGER_ID);
    }

    public String getDebuggerID() {
        return XDEBUG_DEBUGGER_ID;
    }

    public boolean isDebuggerDaemon() {
        return true;
    }

    protected void startConnectionThread(Socket socket) {
        DBGpSession session;
        if (DBGpLogger.debugSession()) {
            DBGpLogger.debug("Connection established: " + socket.toString());
        }
        if ((session = new DBGpSession(socket)).isActive() && !DBGpSessionHandler.getInstance().fireSessionAdded(session)) {
            session.endSession();
        }
    }

    private class PortChangeListener
    implements Preferences.IPropertyChangeListener {
        private PortChangeListener() {
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.php.debug.core.xdebug_port")) {
                XDebugCommunicationDaemon.this.resetSocket();
            }
        }
    }
}

